/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.ui.ReportTreeCellRenderer;
import org.coode.parsers.oppl.testcase.ui.ReportTreeModel;
import org.coode.parsers.oppl.testcase.ui.ReportingTestRunner;
import org.coode.parsers.oppl.testcase.ui.SummaryPanel;
import org.coode.parsers.oppl.testcase.ui.report.Report;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.util.ComponentFactory;

public class OPPLTestCaseRunPanel
extends JPanel {
    private static final long serialVersionUID = 20100L;
    protected final ReportTreeModel resultTreeModel = new ReportTreeModel();
    protected final JTree resultTree = new JTree(this.resultTreeModel);
    protected final SummaryPanel summaryPanel = new SummaryPanel();
    private final TreeModelListener treeModelLister = new TreeModelListener(){

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.expandUnsucessfulNodes();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.expandUnsucessfulNodes();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.expandUnsucessfulNodes();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.expandUnsucessfulNodes();
        }

        private void expandUnsucessfulNodes() {
            TreePath[] unsuccessfulTreePaths;
            for (TreePath treePath : unsuccessfulTreePaths = OPPLTestCaseRunPanel.this.resultTreeModel.getUnsuccessfulTreePaths()) {
                OPPLTestCaseRunPanel.this.resultTree.expandPath(treePath);
            }
        }
    };

    public OPPLTestCaseRunPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        JScrollPane resultTreeScrollPane = ComponentFactory.createScrollPane((JComponent)this.resultTree);
        resultTreeScrollPane.setBorder(ComponentFactory.createTitledBorder((String)"Test cases results"));
        this.resultTree.setCellRenderer(new ReportTreeCellRenderer());
        this.resultTreeModel.addTreeModelListener(this.treeModelLister);
        this.add((Component)this.summaryPanel, "North");
        this.add((Component)resultTreeScrollPane, "Center");
    }

    public void runTests(Collection<? extends OPPLTestCase> testCases) {
        this.resultTreeModel.clear();
        this.summaryPanel.clear();
        HashMap<OPPLTestCase, List<Report>> emptyReports = new HashMap<OPPLTestCase, List<Report>>();
        for (OPPLTestCase oPPLTestCase : testCases) {
            emptyReports.put(oPPLTestCase, null);
        }
        this.summaryPanel.addReports(emptyReports);
        for (OPPLTestCase oPPLTestCase : testCases) {
            RunTest runTest = new RunTest(oPPLTestCase);
            runTest.execute();
        }
    }

    private final class RunTest
    extends SwingWorker<Map<OPPLTestCase, List<Report>>, Object> {
        private final OPPLTestCase opplTestCase;

        public RunTest(OPPLTestCase opplTestCase) {
            this.opplTestCase = opplTestCase;
        }

        @Override
        protected Map<OPPLTestCase, List<Report>> doInBackground() throws Exception {
            ReportingTestRunner reportingTestRunner = new ReportingTestRunner(this.opplTestCase);
            return reportingTestRunner.run();
        }

        @Override
        protected void done() {
            try {
                Map reports = (Map)this.get();
                if (reports != null) {
                    OPPLTestCaseRunPanel.this.resultTreeModel.addReports(reports);
                    OPPLTestCaseRunPanel.this.summaryPanel.addReports(reports);
                }
            }
            catch (InterruptedException e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
            catch (ExecutionException e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
    }
}

