/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppltestcase.ui.utils.JOptionPaneEx;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.protege.OPPLTestCaseAnnotationContainer;
import org.coode.parsers.oppl.testcase.protege.Preferences;
import org.coode.parsers.oppl.testcase.ui.OPPLTestCaseEditor;
import org.coode.parsers.oppl.testcase.ui.RunOPPLTestCaseMListButton;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.AnnotationContainer;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.list.AbstractAnnotationsList;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;

public abstract class OPPLTestCaseList
extends AbstractAnnotationsList<OPPLTestCaseAnnotationContainer> {
    private static final long serialVersionUID = 20100L;
    private final MListSectionHeader header = new MListSectionHeader(){

        public String getName() {
            return "OPPL Test Cases";
        }

        public boolean canAdd() {
            return true;
        }
    };
    private final OWLEditorKit owlEditorKit;
    private final OPPLTestCaseEditor editor;
    protected final Map<OPPLTestCase, List<MListButton>> buttons = new HashMap<OPPLTestCase, List<MListButton>>();
    private final OWLModelManagerListener modelManagerListener;

    public OPPLTestCaseList(OWLEditorKit owlEditorKit) {
        super(owlEditorKit);
        this.owlEditorKit = owlEditorKit;
        this.editor = new OPPLTestCaseEditor(this.getOWLEditorKit());
        this.modelManagerListener = new OWLModelManagerListener(){

            public void handleChange(OWLModelManagerChangeEvent event) {
                OPPLTestCaseList.this.buttons.clear();
                OPPLTestCaseList.this.setRootObject(new OPPLTestCaseAnnotationContainer(OPPLTestCaseList.this.getOWLEditorKit()));
            }
        };
        this.getOWLEditorKit().getOWLModelManager().addListener(this.modelManagerListener);
    }

    protected List<OWLOntologyChange> getAddChanges(OWLAnnotation annot) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add((OWLOntologyChange)new AddOntologyAnnotation(((OPPLTestCaseAnnotationContainer)this.getRoot()).getOntology(), annot));
        return changes;
    }

    protected List<OWLOntologyChange> getReplaceChanges(OWLAnnotation oldAnnotation, OWLAnnotation newAnnotation) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add((OWLOntologyChange)new RemoveOntologyAnnotation(((OPPLTestCaseAnnotationContainer)this.getRoot()).getOntology(), oldAnnotation));
        changes.add((OWLOntologyChange)new AddOntologyAnnotation(((OPPLTestCaseAnnotationContainer)this.getRoot()).getOntology(), newAnnotation));
        return changes;
    }

    protected List<OWLOntologyChange> getDeleteChanges(OWLAnnotation annot) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        changes.add((OWLOntologyChange)new RemoveOntologyAnnotation(((OPPLTestCaseAnnotationContainer)this.getRoot()).getOntology(), annot));
        return changes;
    }

    protected void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof AddOntologyAnnotation) && !(oWLOntologyChange instanceof RemoveOntologyAnnotation) || !oWLOntologyChange.getOntology().equals(((OPPLTestCaseAnnotationContainer)this.getRoot()).getOntology())) continue;
            this.refresh();
            return;
        }
    }

    protected OPPLTestCaseEditor getEditor() {
        return this.editor;
    }

    protected void handleAdd() {
        this.getEditor().setEditedObject(null);
        int ret = JOptionPaneEx.showValidatingConfirmDialog((Component)this.getOWLEditorKit().getWorkspace(), "OPPL Test Case Editor", this.getEditor().getEditorComponent(), this.getEditor(), -1, 2, this.getComponentPopupMenu());
        if (ret == 0) {
            OPPLTestCase OPPLTestCase2 = this.getEditor().getEditedObject();
            OWLDataFactory dataFactory = this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().getOWLDataFactory();
            OWLLiteral literal = dataFactory.getOWLLiteral(OPPLTestCase2.toString());
            IRI annotationIRI = Preferences.getTestCaseAnnotationProperty(this.getOWLEditorKit().getOWLModelManager().getOWLDataFactory()).getIRI();
            OWLAnnotation annotation = dataFactory.getOWLAnnotation(dataFactory.getOWLAnnotationProperty(annotationIRI), (OWLAnnotationValue)literal);
            this.getOWLEditorKit().getModelManager().applyChanges(this.getAddChanges(annotation));
        }
    }

    public void setRootObject(OPPLTestCaseAnnotationContainer root) {
        super.setRootObject((AnnotationContainer)root);
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.header);
        if (root != null) {
            for (OWLAnnotation annot : root.getAnnotations()) {
                data.add((Object)new OPPLTestCaseListItem(annot, root.getOPPLTestCase(annot)));
            }
        }
        this.setListData(data.toArray());
        this.revalidate();
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    protected List<MListButton> getListItemButtons(MListItem item) {
        List<MListButton> listItemButtons = new ArrayList<MListButton>(super.getListItemButtons(item));
        if (item instanceof OPPLTestCaseListItem) {
            final OPPLTestCase opplTestCase = ((OPPLTestCaseListItem)item).getOPPLTestCase();
            List<MListButton> list = this.buttons.get(opplTestCase);
            if (list == null) {
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OPPLTestCaseList.this.runTest(opplTestCase);
                    }
                };
                RunOPPLTestCaseMListButton runButton = new RunOPPLTestCaseMListButton(actionListener);
                if (!listItemButtons.contains((Object)runButton)) {
                    listItemButtons.add(runButton);
                }
                this.buttons.put(opplTestCase, listItemButtons);
            } else {
                listItemButtons = list;
            }
        }
        return listItemButtons;
    }

    protected abstract void runTest(OPPLTestCase var1);

    public void dispose() {
        super.dispose();
        this.getOWLEditorKit().getOWLModelManager().removeListener(this.modelManagerListener);
        this.editor.dispose();
    }

    public final class OPPLTestCaseListItem
    extends AbstractAnnotationsList.AnnotationsListItem {
        private final OPPLTestCase opplTestCase;

        public OPPLTestCaseListItem(OWLAnnotation annot, OPPLTestCase opplTestCase) {
            super((AbstractAnnotationsList)OPPLTestCaseList.this, annot);
            this.opplTestCase = (OPPLTestCase)ArgCheck.checkNotNull((Object)opplTestCase, (String)"opplTestCase");
        }

        public boolean handleDelete() {
            boolean toReturn = super.handleDelete();
            OPPLTestCaseList.this.buttons.remove(this.opplTestCase);
            return toReturn;
        }

        public OPPLTestCase getOPPLTestCase() {
            return this.opplTestCase;
        }

        public void handleEdit() {
            OPPLTestCaseList.this.getEditor().setEditedObject(this.getOPPLTestCase());
            int ret = JOptionPaneEx.showValidatingConfirmDialog((Component)OPPLTestCaseList.this.getOWLEditorKit().getWorkspace(), "Test Case Editor", OPPLTestCaseList.this.getEditor().getEditorComponent(), OPPLTestCaseList.this.getEditor(), -1, 2, OPPLTestCaseList.this.getComponentPopupMenu());
            if (ret == 0) {
                OPPLTestCase newOPPLTestCase = OPPLTestCaseList.this.getEditor().getEditedObject();
                OWLDataFactory dataFactory = OPPLTestCaseList.this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().getOWLDataFactory();
                OWLLiteral literal = dataFactory.getOWLLiteral(newOPPLTestCase.toString());
                IRI annotationIRI = Preferences.getTestCaseAnnotationProperty(OPPLTestCaseList.this.getOWLEditorKit().getOWLModelManager().getOWLDataFactory()).getIRI();
                OWLAnnotation newAnnotation = dataFactory.getOWLAnnotation(dataFactory.getOWLAnnotationProperty(annotationIRI), (OWLAnnotationValue)literal);
                if (!newAnnotation.equals(this.getAnnotation())) {
                    OPPLTestCaseList.this.buttons.remove(this.getOPPLTestCase());
                    List<OWLOntologyChange> changes = OPPLTestCaseList.this.getReplaceChanges(this.getAnnotation(), newAnnotation);
                    OPPLTestCaseList.this.getOWLEditorKit().getModelManager().applyChanges(changes);
                }
            }
        }
    }
}

