/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.OPPLTestCaseParser;
import org.coode.parsers.oppl.testcase.protege.DuplicateOPPLTestCaseNameException;
import org.coode.parsers.oppl.testcase.protege.OPPLTestCaseAnnotationContainer;
import org.coode.parsers.oppl.testcase.protege.ProtegeParserFactory;
import org.coode.parsers.oppl.ui.autocompletionmatcher.ProtegeOPPLTestCaseAutoCompletionMatcher;
import org.coode.parsers.ui.AutoCompleter;
import org.coode.parsers.ui.ExpressionChecker;
import org.coode.parsers.ui.ExpressionEditor;
import org.coode.parsers.ui.autocompletionmatcher.AutoCompletionMatcher;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;

public class OPPLTestCaseEditor
extends AbstractOWLObjectEditor<OPPLTestCase>
implements VerifiedInputEditor {
    protected final OWLEditorKit oek;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private JPanel mainPanel;
    protected OPPLTestCase opplTestCase = null;
    protected final Set<OPPLTestCase> otherOPPLTestCases = new HashSet<OPPLTestCase>();
    protected final ExpressionEditor<OPPLTestCase> editor;
    private final ProtegeOPPLTestCaseAutoCompletionMatcher autoCompletionMatcher;

    public OPPLTestCaseEditor(OWLEditorKit owlEditorKit) {
        this.oek = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.otherOPPLTestCases.addAll(new OPPLTestCaseAnnotationContainer(this.oek).getOPPLTestCases());
        this.editor = new ExpressionEditor(this.oek.getOWLModelManager().getOWLOntologyManager(), (ExpressionChecker)new OPPLExpressionChecker<OPPLTestCase>(this.oek){

            @Override
            protected OPPLTestCase parse(String text) {
                ProtegeParserFactory parserFactory = new ProtegeParserFactory(OPPLTestCaseEditor.this.oek);
                OPPLTestCaseParser parser = parserFactory.build(this.getListener());
                OPPLTestCase toReturn = null;
                OPPLTestCase parsed = parser.parse(text, (RuntimeExceptionHandler)new ShowMessageRuntimeExceptionHandler(OPPLTestCaseEditor.this.getEditorComponent()));
                if (parsed != null && !this.isNameUnique(parsed)) {
                    this.getListener().reportThrowable((Throwable)new DuplicateOPPLTestCaseNameException(parsed.getName()), 1, 0, parsed.getName().length());
                } else {
                    toReturn = parsed;
                }
                return toReturn;
            }

            private final boolean isNameUnique(OPPLTestCase test) {
                boolean found = false;
                Iterator<OPPLTestCase> iterator = OPPLTestCaseEditor.this.otherOPPLTestCases.iterator();
                while (!found && iterator.hasNext()) {
                    OPPLTestCase existingOPPLTestCase = iterator.next();
                    found = test.getName().compareTo(existingOPPLTestCase.getName()) == 0;
                }
                return !found;
            }
        });
        this.autoCompletionMatcher = new ProtegeOPPLTestCaseAutoCompletionMatcher(this.oek);
        new AutoCompleter(this.editor, (AutoCompletionMatcher)this.autoCompletionMatcher);
        this.editor.addStatusChangedListener(new org.coode.parsers.ui.InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OPPLTestCaseEditor.this.opplTestCase = (OPPLTestCase)OPPLTestCaseEditor.this.editor.createObject();
                OPPLTestCaseEditor.this.handleChange();
            }
        });
        this.initGUI();
    }

    protected void handleChange() {
        boolean newStatus = this.check();
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(newStatus);
        }
    }

    private void initGUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.editor.setPreferredSize(new Dimension(300, 200));
        this.mainPanel.add((Component)this.editor, "Center");
    }

    private boolean check() {
        return this.opplTestCase != null;
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        if (listener != null) {
            listener.verifiedStatusChanged(this.check());
            this.listeners.add(listener);
        }
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.oek;
    }

    public String getEditorTypeName() {
        return "OPPL Test Case";
    }

    public boolean canEdit(Object object) {
        return true;
    }

    public JComponent getEditorComponent() {
        return this.mainPanel;
    }

    public OPPLTestCase getEditedObject() {
        return this.opplTestCase;
    }

    public boolean setEditedObject(OPPLTestCase editedObject) {
        this.otherOPPLTestCases.clear();
        this.otherOPPLTestCases.addAll(new OPPLTestCaseAnnotationContainer(this.getOWLEditorKit()).getOPPLTestCases());
        if (editedObject != null) {
            this.otherOPPLTestCases.remove(editedObject);
            this.editor.setText(editedObject.toString());
        } else {
            this.editor.setText("");
        }
        return true;
    }

    public void dispose() {
        this.autoCompletionMatcher.dispose();
    }
}

