/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.testcase.protege;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.common.SystemErrorEcho;
import org.coode.parsers.oppl.testcase.OPPLTestCase;
import org.coode.parsers.oppl.testcase.OPPLTestCaseParser;
import org.coode.parsers.oppl.testcase.protege.Preferences;
import org.coode.parsers.oppl.testcase.protege.ProtegeParserFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.AnnotationContainer;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class OPPLTestCaseAnnotationContainer
implements AnnotationContainer {
    private final OWLEditorKit owlEditorKit;
    private final OWLAnnotationProperty testCaseAnnotationProperty;
    protected final OPPLTestCaseParser parser;

    public OPPLTestCaseAnnotationContainer(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.testCaseAnnotationProperty = Preferences.getTestCaseAnnotationProperty(this.getOWLEditorKit().getOWLModelManager().getOWLDataFactory());
        ProtegeParserFactory parserFactory = new ProtegeParserFactory(this.getOWLEditorKit());
        this.parser = parserFactory.build((ErrorListener)new SystemErrorEcho());
    }

    public Set<OWLAnnotation> getAnnotations() {
        OWLOntology activeOntology = this.getOWLEditorKit().getOWLModelManager().getActiveOntology();
        Set toReturn = activeOntology.getAnnotations();
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            OWLAnnotation annotation = (OWLAnnotation)iterator.next();
            OPPLTestCase extracted = this.getOPPLTestCase(annotation);
            if (extracted != null) continue;
            iterator.remove();
        }
        return toReturn;
    }

    public OPPLTestCase getOPPLTestCase(OWLAnnotation annotation) {
        OPPLTestCase extracted = null;
        if (annotation.getProperty().equals(this.testCaseAnnotationProperty)) {
            OWLAnnotationValue value = annotation.getValue();
            extracted = (OPPLTestCase)value.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<OPPLTestCase>(){

                public OPPLTestCase visit(OWLLiteral literal) {
                    String input = literal.getLiteral();
                    OPPLTestCase parsed = OPPLTestCaseAnnotationContainer.this.parser.parse(input, (RuntimeExceptionHandler)new ShowMessageRuntimeExceptionHandler((Component)OPPLTestCaseAnnotationContainer.this.getOWLEditorKit().getOWLWorkspace()));
                    return parsed;
                }
            });
        }
        return extracted;
    }

    public Set<OPPLTestCase> getOPPLTestCases() {
        Set<OWLAnnotation> annotations = this.getAnnotations();
        HashSet<OPPLTestCase> toReturn = new HashSet<OPPLTestCase>(annotations.size());
        for (OWLAnnotation owlAnnotation : annotations) {
            toReturn.add(this.getOPPLTestCase(owlAnnotation));
        }
        return toReturn;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public OWLOntology getOntology() {
        return this.getOWLEditorKit().getOWLModelManager().getActiveOntology();
    }
}

