/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui.rendering;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.ActionListItem;
import org.coode.oppl.protege.ui.OPPLSelectClauseListItem;
import org.coode.oppl.protege.ui.OWLObjectListItem;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public class VariableOWLCellRenderer
extends OWLCellRenderer
implements ListCellRenderer {
    private final ConstraintSystem constraintSystem;
    private final OWLCellRenderer defaultRenderer;
    private final OWLEditorKit owlEditorKit;

    public VariableOWLCellRenderer(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem, OWLCellRenderer defaultRenderer) {
        super(owlEditorKit);
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.defaultRenderer = (OWLCellRenderer)ArgCheck.checkNotNull((Object)defaultRenderer, (String)"defaultRenderer");
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.setHighlightKeywords(true);
        this.setWrap(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component toReturn = this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof ActionListItem) {
            ActionListItem actionListItem = (ActionListItem)value;
            OWLAxiomChange axiomChange = actionListItem.getAxiomChange();
            toReturn = super.getListCellRendererComponent(list, (Object)axiomChange.getAxiom(), index, isSelected, cellHasFocus);
        }
        if (value instanceof OPPLSelectClauseListItem) {
            OWLAxiom axiom = ((OPPLSelectClauseListItem)value).getAxiom();
            toReturn = super.getListCellRendererComponent(list, (Object)axiom, index, isSelected, cellHasFocus);
        }
        if (value instanceof OWLObjectListItem) {
            toReturn = super.getListCellRendererComponent(list, (Object)((OWLObjectListItem)value).getOwlObject(), index, isSelected, cellHasFocus);
        }
        return toReturn;
    }

    public String getRendering(Object object) {
        if (object instanceof OWLObject) {
            ManchesterSyntaxRenderer manchesterSyntaxRenderer = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).getOPPLFactory().getManchesterSyntaxRenderer(this.getConstraintSystem());
            OWLObject owlObject = (OWLObject)object;
            owlObject.accept((OWLObjectVisitor)manchesterSyntaxRenderer);
            return manchesterSyntaxRenderer.toString();
        }
        return super.getRendering(object);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }
}

