/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui.rendering;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.utils.ArgCheck;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLObject;

public class BindingTreeRenderer
extends OWLCellRenderer {
    private final DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
    private final ConstraintSystem constraintSystem;

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public BindingTreeRenderer(OWLEditorKit owlEditorKit, ConstraintSystem cs) {
        super(owlEditorKit);
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)cs, (String)"constraint system");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component toReturn = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            toReturn = this.defaultTreeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (userObject instanceof OWLObject) {
                toReturn = super.getTreeCellRendererComponent(tree, userObject, selected, expanded, leaf, row, hasFocus);
            } else if (userObject instanceof BindingNode) {
                toReturn = this.defaultTreeCellRenderer.getTreeCellRendererComponent(tree, ((BindingNode)userObject).render(this.getConstraintSystem()), selected, expanded, leaf, row, hasFocus);
            }
        }
        return toReturn;
    }
}

