/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.exceptions.OPPLException;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.protege.ui.OPPLMacroListener;
import org.coode.oppl.protege.ui.OPPLMacroStatusChange;
import org.coode.oppl.protege.ui.ScopeEditor;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifyingOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.semanticweb.owlapi.model.OWLObject;

public class VariableListItem
implements MListItem,
OPPLMacroStatusChange {
    protected Variable<?> variable;
    private final OWLEditorKit owlEditorKit;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    private final List<OPPLMacroListener> listeners = new ArrayList<OPPLMacroListener>();
    private final boolean isEditable;
    private final boolean isDeleteable;
    private final ConstraintSystem constraintSystem;

    public VariableListItem(Variable<?> variable, ConstraintSystem constraintSystem, OWLEditorKit owlEditorKit, boolean isEditable, boolean isDeleatable) {
        this.variable = (Variable)ArgCheck.checkNotNull(variable, (String)"variable");
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.isEditable = isEditable;
        this.isDeleteable = isDeleatable;
        this.runtimeExceptionHandler = new ShowMessageRuntimeExceptionHandler((Component)this.getOwlEditorKit().getOWLWorkspace());
    }

    public String getTooltip() {
        StringBuilder toReturnBuilder = new StringBuilder(this.variable.getName());
        boolean first = true;
        toReturnBuilder.append(" = ");
        for (OWLObject value : this.getConstraintSystem().getVariableBindings(this.variable, this.getRuntimeExceptionHandler())) {
            String rendering = first ? this.owlEditorKit.getModelManager().getRendering(value) : ", " + this.owlEditorKit.getModelManager().getRendering(value);
            toReturnBuilder.append(rendering);
        }
        return toReturnBuilder.toString();
    }

    public boolean handleDelete() {
        this.notifyListeners(this.getVariable());
        for (OPPLMacroListener l : new ArrayList<OPPLMacroListener>(this.getListeners())) {
            this.removeOPPLMacroListener(l);
        }
        return true;
    }

    public void handleEdit() {
        try {
            VariableScopeChecker checker = this.getConstraintSystem().getOPPLFactory().getVariableScopeChecker();
            final ScopeEditor scopeEditor = ScopeEditor.getTypeScopeEditor(this.variable.getType(), checker, this.owlEditorKit);
            final VerifyingOptionPane optionPane = new VerifyingOptionPane(scopeEditor){
                private static final long serialVersionUID = 20100L;

                public void selectInitialValue() {
                }
            };
            if (this.owlEditorKit.getModelManager().getReasoner() instanceof NoOpReasoner) {
                JOptionPane.showMessageDialog((Component)this.owlEditorKit.getWorkspace(), "You are not using any reasoner, in order to scope variables, please activate reasoning.", "No Reasoner", 0);
            } else {
                final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                    public void verifiedStatusChanged(boolean verified) {
                        optionPane.setOKEnabled(verified);
                    }
                };
                scopeEditor.addStatusChangedListener(verificationListener);
                JDialog dlg = optionPane.createDialog((Component)this.owlEditorKit.getWorkspace(), null);
                dlg.setModal(false);
                dlg.setTitle(scopeEditor.getTitle());
                dlg.setResizable(true);
                dlg.pack();
                dlg.setLocationRelativeTo((Component)this.owlEditorKit.getWorkspace());
                dlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        Object retVal = optionPane.getValue();
                        if (retVal != null && retVal.equals(0)) {
                            VariableScope<?> variableScope = scopeEditor.getVariableScope();
                            try {
                                VariableListItem.this.variable = VariableListItem.this.getConstraintSystem().createVariable(VariableListItem.this.getVariable().getName(), VariableListItem.this.getVariable().getType(), variableScope);
                            }
                            catch (OPPLException e1) {
                                throw new RuntimeException(e1);
                            }
                        }
                        scopeEditor.removeStatusChangedListener(verificationListener);
                    }
                });
                dlg.setVisible(true);
            }
        }
        catch (OPPLException e2) {
            JOptionPane.showMessageDialog((Component)this.owlEditorKit.getWorkspace(), "Choose a reasoner first");
        }
    }

    public boolean isDeleteable() {
        return this.isDeleteable;
    }

    public boolean isEditable() {
        return this.isEditable && this.variable.getType() != VariableTypeFactory.getCONSTANTVariableType();
    }

    public Variable<?> getVariable() {
        return this.variable;
    }

    @Override
    public void addOPPLMacroListener(OPPLMacroListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeOPPLMacroListener(OPPLMacroListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(Variable<?> variable1) {
        for (OPPLMacroListener listener : this.listeners) {
            listener.handleDeletedVariable(variable1);
        }
    }

    private Collection<OPPLMacroListener> getListeners() {
        return this.listeners;
    }

    protected final OWLEditorKit getOwlEditorKit() {
        return this.owlEditorKit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isDeleteable ? 1231 : 1237);
        result = 31 * result + (this.isEditable ? 1231 : 1237);
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableListItem other = (VariableListItem)obj;
        if (this.isDeleteable != other.isDeleteable) {
            return false;
        }
        if (this.isEditable != other.isEditable) {
            return false;
        }
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }
}

