/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.protege.ui.OPPLMList;
import org.coode.oppl.protege.ui.VariableListItem;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.variabletypes.InputVariable;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLObject;

public class VariableList
extends OPPLMList {
    private static final long serialVersionUID = 20100L;
    private final VariableListCellRenderer variableListCellRenderer = new VariableListCellRenderer();
    protected final OWLEditorKit owlEditorKit;
    protected ConstraintSystem constraintSystem;

    public VariableList(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.owlEditorKit = owlEditorKit;
        this.constraintSystem = constraintSystem;
        this.setModel(new DefaultListModel());
        this.setCellRenderer(this.variableListCellRenderer);
    }

    protected void handleDelete() {
        super.handleDelete();
        Object selectedValue = this.getSelectedValue();
        if (selectedValue != null) {
            this.getDefaultModel().removeElement(selectedValue);
        }
    }

    protected OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public ListCellRenderer<Object> getVariableListCellRenderer() {
        return this.variableListCellRenderer;
    }

    class VariableListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 20100L;

        VariableListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof VariableListItem) {
                Variable<?> variable = ((VariableListItem)value).getVariable();
                VariableScope variableScope = (VariableScope)variable.accept((VariableVisitorEx)new AbstractVariableVisitorExAdapter<VariableScope<?>>(null){

                    public <P extends OWLObject> VariableScope<?> visit(InputVariable<P> v) {
                        return v.getVariableScope();
                    }
                });
                String variableScopeString = null;
                if (variableScope == null) {
                    variableScopeString = "";
                } else {
                    String rendering = VariableList.this.owlEditorKit.getModelManager().getRendering(variableScope.getScopingObject());
                    variableScopeString = "[" + variableScope.getDirection() + " " + rendering + "] ";
                }
                label.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(variable instanceof GeneratedVariable ? "cog.png" : "user-icon.gif")));
                label.setText(VariableList.this.constraintSystem.render(variable) + ":" + variable.getType() + variableScopeString);
            }
            return label;
        }
    }
}

