/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.exceptions.InvalidVariableNameException;
import org.coode.oppl.exceptions.OPPLException;
import org.coode.oppl.protege.ui.AbstractVariableEditor;
import org.coode.oppl.protege.ui.NoDefaultFocusVerifyingOptionPane;
import org.coode.oppl.protege.ui.ScopeEditor;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.coode.oppl.variabletypes.VariableTypeName;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.model.OWLException;

public class VariableEditor
extends AbstractVariableEditor<InputVariable<?>> {
    private static final long serialVersionUID = 20100L;
    protected final OWLEditorKit owlEditorKit;
    private final ConstraintSystem constraintSystem;
    private final JLabel typeScopeLabel = new JLabel();
    protected final Map<JRadioButton, VariableType<?>> jRadioButtonTypeMap = new HashMap();
    protected final Map<VariableType<?>, JRadioButton> typeJRadioButonMap = new HashMap();
    protected VariableScope<?> lastVariableScope = null;
    protected JButton createScopeButton = new JButton("Create");
    protected JButton editScopeButton = new JButton("Edit");
    protected JButton deleteScopeButton = new JButton("Clear");

    public VariableEditor(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.setLayout(new BorderLayout());
        this.variableNameExpressionEditor = new ExpressionEditor(owlEditorKit, (OWLExpressionChecker)new OWLExpressionChecker<String>(){
            private String variableName;

            public void check(String text) throws OWLExpressionParserException {
                this.variableName = null;
                if (!text.matches("(\\?)?(\\w)+")) {
                    throw new OWLExpressionParserException((Throwable)new InvalidVariableNameException(text));
                }
                this.variableName = text.startsWith("?") ? text : "?" + text;
            }

            public String createObject(String text) throws OWLExpressionParserException {
                this.check(text);
                return this.variableName;
            }
        });
        JPanel variableNamePanel = new JPanel(new BorderLayout());
        variableNamePanel.setBorder(ComponentFactory.createTitledBorder((String)"Variable name:"));
        for (KeyListener l : this.variableNameExpressionEditor.getKeyListeners()) {
            this.variableNameExpressionEditor.removeKeyListener(l);
        }
        this.variableNameExpressionEditor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                if (newState) {
                    VariableEditor.this.handleChange();
                }
            }
        });
        variableNamePanel.add((Component)this.variableNameExpressionEditor);
        this.add((Component)variableNamePanel, "North");
        this.variableTypeButtonGroup = new ButtonGroup();
        JPanel variableTypePanel = new JPanel(new FlowLayout());
        for (VariableTypeName variableTypeName : VariableTypeName.values()) {
            JRadioButton typeRadioButton = new JRadioButton(variableTypeName.name());
            typeRadioButton.addActionListener(new ChangeTypeActionListener());
            this.variableTypeButtonGroup.add(typeRadioButton);
            variableTypePanel.add(typeRadioButton);
            VariableType variableType = VariableTypeFactory.getVariableType((VariableTypeName)variableTypeName);
            this.jRadioButtonTypeMap.put(typeRadioButton, variableType);
            this.typeJRadioButonMap.put(variableType, typeRadioButton);
        }
        this.typeJRadioButonMap.get(VariableTypeFactory.getVariableType((VariableTypeName)VariableTypeName.values()[0])).setSelected(true);
        JPanel scopeBorderPanel = new JPanel(new BorderLayout());
        scopeBorderPanel.setBorder(ComponentFactory.createTitledBorder((String)"Variable Scope"));
        this.createScopeButton.setEnabled(false);
        this.editScopeButton.setEnabled(false);
        this.deleteScopeButton.setEnabled(false);
        JToolBar scopeToolBar = new JToolBar();
        scopeToolBar.setFloatable(false);
        scopeToolBar.add(this.createScopeButton);
        this.createScopeButton.addActionListener(new EditScopeActionListener(false));
        this.editScopeButton.addActionListener(new EditScopeActionListener(true));
        this.deleteScopeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableEditor.this.lastVariableScope = null;
                VariableEditor.this.createScopeButton.setEnabled(true);
                VariableEditor.this.handleChange();
            }
        });
        scopeToolBar.add(this.editScopeButton);
        scopeToolBar.add(this.deleteScopeButton);
        scopeBorderPanel.add((Component)scopeToolBar, "North");
        JPanel variableTypeAndScopePanel = new JPanel(new BorderLayout());
        variableTypeAndScopePanel.add((Component)scopeBorderPanel, "North");
        variableTypeAndScopePanel.add((Component)variableTypePanel, "Center");
        JPanel typeScopeLabelPanel = new JPanel(new FlowLayout());
        typeScopeLabelPanel.add(this.typeScopeLabel);
        variableTypeAndScopePanel.add((Component)typeScopeLabelPanel, "South");
        variableTypeAndScopePanel.setBorder(ComponentFactory.createTitledBorder((String)"Variable Type"));
        this.add((Component)variableTypeAndScopePanel, "Center");
    }

    protected void handleChange() {
        JRadioButton selectedJRadioButton = this.findSelectedButton();
        VariableType<?> type = this.jRadioButtonTypeMap.get(selectedJRadioButton);
        if (this.check()) {
            try {
                String variableName = (String)this.variableNameExpressionEditor.createObject();
                this.updateVariable(variableName, type);
                this.updateTypeScope(type);
                this.notifyListeners();
                this.repaint();
            }
            catch (OPPLException e) {
                this.notifyListeners();
                throw new RuntimeException(e);
            }
            catch (OWLExpressionParserException e) {
                this.notifyListeners();
                throw new RuntimeException(e);
            }
            catch (OWLException e) {
                this.notifyListeners();
                throw new RuntimeException(e);
            }
        } else {
            this.updateTypeScope(type);
            this.notifyListeners();
        }
        this.setupButtonsEnabling();
    }

    private void setupButtonsEnabling() {
        this.createScopeButton.setEnabled(this.lastVariableScope == null);
        this.editScopeButton.setEnabled(!this.createScopeButton.isEnabled());
        this.deleteScopeButton.setEnabled(this.editScopeButton.isEnabled());
    }

    private void updateTypeScope(VariableType<?> type) {
        if (this.lastVariableScope != null && type != null) {
            this.findSelectedButton();
            JRadioButton radioButton = this.findSelectedButton();
            if (radioButton != null) {
                this.typeScopeLabel.setText(String.format("[%s %s]", this.lastVariableScope.getDirection(), this.owlEditorKit.getModelManager().getRendering(this.lastVariableScope.getScopingObject())));
            }
        } else {
            this.typeScopeLabel.setText("");
        }
    }

    @Override
    protected boolean check() {
        try {
            boolean toReturn = true;
            this.variableNameExpressionEditor.createObject();
            VariableType<?> selectedValue = this.jRadioButtonTypeMap.get(this.findSelectedButton());
            toReturn = selectedValue instanceof VariableType;
            return toReturn;
        }
        catch (OWLExpressionParserException e) {
            return false;
        }
        catch (OWLException e) {
            return false;
        }
    }

    private void updateVariable(String variableName, VariableType<?> type) throws OPPLException {
        if (this.getVariable() != null) {
            this.getConstraintSystem().removeVariable(this.getVariable());
        }
        super.setVariable(this.getConstraintSystem().createVariable(variableName, type, this.lastVariableScope));
    }

    @Override
    public void setVariable(InputVariable<?> v) {
        this.clear();
        this.lastVariableScope = v.getVariableScope();
        this.variableNameExpressionEditor.setText(v.getName());
        this.typeJRadioButonMap.get(v.getType()).setSelected(true);
        this.updateTypeScope(v.getType());
    }

    @Override
    public void dispose() {
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    public String getEditorName() {
        return "Input Variable";
    }

    private class ChangeTypeActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            VariableEditor.this.lastVariableScope = null;
            VariableEditor.this.createScopeButton.setEnabled(true);
            VariableEditor.this.handleChange();
        }
    }

    private final class EditScopeActionListener
    implements ActionListener {
        protected final boolean useScope;

        protected EditScopeActionListener(boolean scope) {
            this.useScope = scope;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariableType<?> variableType = VariableEditor.this.jRadioButtonTypeMap.get(VariableEditor.this.findSelectedButton());
            try {
                VariableScopeChecker variableScopeChecker = VariableEditor.this.getConstraintSystem().getOPPLFactory().getVariableScopeChecker();
                final ScopeEditor scopeEditor = ScopeEditor.getTypeScopeEditor(variableType, variableScopeChecker, VariableEditor.this.owlEditorKit);
                if (this.useScope) {
                    scopeEditor.setScope(VariableEditor.this.lastVariableScope);
                }
                final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(scopeEditor);
                final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                    public void verifiedStatusChanged(boolean verified) {
                        optionPane.setOKEnabled(verified);
                    }
                };
                scopeEditor.addStatusChangedListener(verificationListener);
                JDialog dlg = optionPane.createDialog((Component)VariableEditor.this.owlEditorKit.getWorkspace(), null);
                dlg.setModal(true);
                dlg.setTitle(scopeEditor.getTitle());
                dlg.setResizable(true);
                dlg.pack();
                dlg.setLocationRelativeTo((Component)VariableEditor.this.owlEditorKit.getWorkspace());
                dlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e1) {
                        Object retVal = optionPane.getValue();
                        if (retVal != null && retVal.equals(0)) {
                            VariableEditor.this.lastVariableScope = scopeEditor.getVariableScope();
                            VariableEditor.this.handleChange();
                        }
                        if (EditScopeActionListener.this.useScope) {
                            VariableEditor.this.deleteScopeButton.setEnabled(true);
                            VariableEditor.this.editScopeButton.setEnabled(true);
                        }
                        scopeEditor.removeStatusChangedListener(verificationListener);
                        scopeEditor.dispose();
                    }
                });
                dlg.setVisible(true);
            }
            catch (OPPLException exception) {
                JOptionPane.showMessageDialog((Component)VariableEditor.this.owlEditorKit.getWorkspace(), "Select a reasoner before");
            }
        }
    }
}

