/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableScopeChecker;
import org.coode.oppl.VariableScopes;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class ScopeEditor
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 20100L;
    protected final OWLEditorKit owlEditorKit;
    private final List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private VariableScope<?> variableScope = null;
    private final String title;
    private final VariableScopeChecker checker;

    public VariableScopeChecker getChecker() {
        return this.checker;
    }

    protected ScopeEditor(String title, VariableScopeChecker checker, OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.title = title;
        this.checker = checker;
    }

    public VariableScope<?> getVariableScope() {
        return this.variableScope;
    }

    protected final void setVariableScope(VariableScope<?> variableScope) {
        this.variableScope = variableScope;
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            listener.verifiedStatusChanged(this.variableScope != null);
        }
    }

    public static ScopeEditor getTypeScopeEditor(VariableType<?> variableType, final VariableScopeChecker checker, final OWLEditorKit owlEditorKit) {
        ScopeEditor toReturn = (ScopeEditor)variableType.accept((VariableTypeVisitorEx)new VariableTypeVisitorEx<ScopeEditor>(){

            public ScopeEditor visitCLASSVariableType(CLASSVariableType classVariableType) {
                return new ClassScopeEditor(owlEditorKit, checker);
            }

            public ScopeEditor visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
                return new PropertyScopeEditor(owlEditorKit, checker, false);
            }

            public ScopeEditor visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
                return new PropertyScopeEditor(owlEditorKit, checker, true);
            }

            public ScopeEditor visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
                return new IndividualScopeEditor(checker, owlEditorKit);
            }

            public ScopeEditor visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
                return null;
            }

            public ScopeEditor visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
                return null;
            }
        });
        return toReturn;
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.notifyListeners();
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public String getTitle() {
        return this.title;
    }

    public abstract void dispose();

    public abstract void setScope(VariableScope<?> var1);

    static class PropertyScopeEditor
    extends ScopeEditor
    implements ChangeListener {
        private static final long serialVersionUID = 20100L;
        private final ButtonGroup directionButtonGroup = new ButtonGroup();
        private final Map<JRadioButton, VariableScopes.Direction> radioButtonDirectionMap = new HashMap<JRadioButton, VariableScopes.Direction>();
        private final AbstractHierarchySelectorPanel<?> propertyTree;
        private static final String PROPERTY_TITLE = "Property Variable Scope";
        private final boolean isDataProperty;

        public PropertyScopeEditor(OWLEditorKit owlEditorKit, VariableScopeChecker checker, boolean isDataProperty) {
            super(PROPERTY_TITLE, checker, owlEditorKit);
            this.isDataProperty = isDataProperty;
            this.setLayout(new BorderLayout());
            JRadioButton superPropertyRadioButton = new JRadioButton(VariableScopes.Direction.SUBPROPERTYOF.toString());
            superPropertyRadioButton.setSelected(true);
            this.radioButtonDirectionMap.put(superPropertyRadioButton, VariableScopes.Direction.SUBPROPERTYOF);
            this.directionButtonGroup.add(superPropertyRadioButton);
            JRadioButton subPropertyRadioButton = new JRadioButton(VariableScopes.Direction.SUPERPROPERTYOF.toString());
            this.radioButtonDirectionMap.put(subPropertyRadioButton, VariableScopes.Direction.SUPERPROPERTYOF);
            this.directionButtonGroup.add(subPropertyRadioButton);
            JPanel directionPanel = new JPanel(new GridLayout(0, 2));
            directionPanel.setBorder(ComponentFactory.createTitledBorder((String)"Direction"));
            directionPanel.add(subPropertyRadioButton);
            directionPanel.add(superPropertyRadioButton);
            subPropertyRadioButton.setSelected(true);
            this.add((Component)directionPanel, "North");
            this.propertyTree = isDataProperty ? new OWLDataPropertySelectorPanel(this.owlEditorKit) : new OWLObjectPropertySelectorPanel(this.owlEditorKit);
            this.propertyTree.addSelectionListener((ChangeListener)this);
            JPanel propertyPaneBorder = new JPanel(new BorderLayout());
            JScrollPane propertyPane = ComponentFactory.createScrollPane(this.propertyTree);
            propertyPaneBorder.setBorder(ComponentFactory.createTitledBorder((String)"Scoping property"));
            propertyPane.setSize(new Dimension(100, 50));
            propertyPaneBorder.add(propertyPane);
            this.add((Component)propertyPaneBorder, "South");
        }

        public void valueChanged(TreeSelectionEvent e) {
        }

        private JRadioButton findSelectedButton() {
            JRadioButton button = null;
            Enumeration<AbstractButton> directions = this.directionButtonGroup.getElements();
            boolean found = false;
            while (!found && directions.hasMoreElements()) {
                button = (JRadioButton)directions.nextElement();
                found = button.isSelected();
            }
            return found ? button : null;
        }

        @Override
        public void dispose() {
            this.propertyTree.removeSelectionListener((ChangeListener)this);
        }

        @Override
        public void setScope(VariableScope<?> scope) {
            if (this.isDataProperty) {
                OWLDataPropertySelectorPanel panel = (OWLDataPropertySelectorPanel)this.propertyTree;
                panel.setSelection((OWLDataProperty)scope.getScopingObject());
            } else {
                OWLObjectPropertySelectorPanel panel = (OWLObjectPropertySelectorPanel)this.propertyTree;
                panel.setSelection((OWLObjectProperty)scope.getScopingObject());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            OWLObject lastPathComponent = this.propertyTree.getSelectedObject();
            JRadioButton selectedButton = this.findSelectedButton();
            if (selectedButton != null) {
                VariableScopes.Direction direction = this.radioButtonDirectionMap.get(selectedButton);
                this.setVariableScope(null);
                if (lastPathComponent != null && direction != null) {
                    if (direction.equals((Object)VariableScopes.Direction.SUBPROPERTYOF)) {
                        if (lastPathComponent instanceof OWLDataProperty) {
                            this.setVariableScope((VariableScope<?>)VariableScopes.buildSubPropertyVariableScope((OWLDataProperty)((OWLDataProperty)lastPathComponent), (VariableScopeChecker)this.getChecker()));
                        } else if (lastPathComponent instanceof OWLObjectProperty) {
                            this.setVariableScope((VariableScope<?>)VariableScopes.buildSubPropertyVariableScope((OWLPropertyExpression)((OWLObjectProperty)lastPathComponent), (VariableScopeChecker)this.getChecker()));
                        }
                    }
                    if (direction.equals((Object)VariableScopes.Direction.SUPERPROPERTYOF)) {
                        if (lastPathComponent instanceof OWLDataProperty) {
                            this.setVariableScope((VariableScope<?>)VariableScopes.buildSuperPropertyVariableScope((OWLPropertyExpression)((OWLDataProperty)lastPathComponent), (VariableScopeChecker)this.getChecker()));
                        } else if (lastPathComponent instanceof OWLObjectProperty) {
                            this.setVariableScope((VariableScope<?>)VariableScopes.buildSuperPropertyVariableScope((OWLPropertyExpression)((OWLObjectProperty)lastPathComponent), (VariableScopeChecker)this.getChecker()));
                        }
                    }
                }
            }
        }
    }

    static class IndividualScopeEditor
    extends ScopeEditor
    implements InputVerificationStatusChangedListener {
        private static final long serialVersionUID = 20100L;
        private final ExpressionEditor<OWLClassExpression> editor;
        private static final String INDIVIDUAL_TITLE = "Individual Variable Scope";

        public IndividualScopeEditor(VariableScopeChecker checker, OWLEditorKit owlEditorKit) {
            super(INDIVIDUAL_TITLE, checker, owlEditorKit);
            this.editor = new ExpressionEditor(this.owlEditorKit, this.owlEditorKit.getModelManager().getOWLExpressionCheckerFactory().getOWLClassExpressionChecker());
            this.setLayout(new BorderLayout());
            this.editor.addStatusChangedListener((InputVerificationStatusChangedListener)this);
            this.editor.setSize(new Dimension(100, 50));
            JPanel editorPaneBorder = new JPanel(new BorderLayout());
            JScrollPane editorPane = ComponentFactory.createScrollPane(this.editor);
            editorPaneBorder.setBorder(ComponentFactory.createTitledBorder((String)"Scoping Class Description"));
            editorPaneBorder.add(editorPane);
            this.add((Component)editorPaneBorder, "Center");
        }

        public void verifiedStatusChanged(boolean newState) {
            this.setVariableScope(null);
            if (newState) {
                try {
                    this.setVariableScope((VariableScope<?>)VariableScopes.buildIndividualVariableScope((OWLClassExpression)((OWLClassExpression)this.editor.createObject()), (VariableScopeChecker)this.getChecker()));
                }
                catch (OWLException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void dispose() {
            this.editor.removeStatusChangedListener((InputVerificationStatusChangedListener)this);
        }

        @Override
        public void setScope(VariableScope<?> scope) {
            OWLObject scopingObject = scope.getScopingObject();
            this.editor.setText(this.owlEditorKit.getModelManager().getRendering(scopingObject));
        }
    }

    static class ClassScopeEditor
    extends ScopeEditor
    implements InputVerificationStatusChangedListener,
    ChangeListener {
        private static final long serialVersionUID = 20100L;
        private final ExpressionEditor<OWLClassExpression> editor;
        private final ButtonGroup directionButtonGroup;
        private final Map<JRadioButton, VariableScopes.Direction> radioButtonDirectionMap;
        private final Map<VariableScopes.Direction, JRadioButton> directionRadioButtonMap;
        private static final String CLASS_TITLE = "Class Variable Scope";

        public ClassScopeEditor(OWLEditorKit owlEditorKit, VariableScopeChecker checker) {
            super(CLASS_TITLE, checker, owlEditorKit);
            this.editor = new ExpressionEditor(this.owlEditorKit, this.owlEditorKit.getOWLModelManager().getOWLExpressionCheckerFactory().getOWLClassExpressionChecker());
            this.directionButtonGroup = new ButtonGroup();
            this.radioButtonDirectionMap = new HashMap<JRadioButton, VariableScopes.Direction>();
            this.directionRadioButtonMap = new HashMap<VariableScopes.Direction, JRadioButton>();
            this.setLayout(new BorderLayout());
            JRadioButton superClassRadioButton = new JRadioButton(VariableScopes.Direction.SUPERCLASSOF.toString());
            superClassRadioButton.setSelected(true);
            this.radioButtonDirectionMap.put(superClassRadioButton, VariableScopes.Direction.SUPERCLASSOF);
            this.directionRadioButtonMap.put(VariableScopes.Direction.SUPERCLASSOF, superClassRadioButton);
            this.directionButtonGroup.add(superClassRadioButton);
            superClassRadioButton.getModel().addChangeListener(this);
            JRadioButton subClassRadioButton = new JRadioButton(VariableScopes.Direction.SUBCLASSOF.toString());
            this.radioButtonDirectionMap.put(subClassRadioButton, VariableScopes.Direction.SUBCLASSOF);
            this.directionRadioButtonMap.put(VariableScopes.Direction.SUBCLASSOF, subClassRadioButton);
            this.directionButtonGroup.add(subClassRadioButton);
            JPanel directionPanel = new JPanel(new GridLayout(0, 2));
            directionPanel.setBorder(ComponentFactory.createTitledBorder((String)"Direction"));
            directionPanel.add(subClassRadioButton);
            directionPanel.add(superClassRadioButton);
            subClassRadioButton.setSelected(true);
            this.editor.addStatusChangedListener((InputVerificationStatusChangedListener)this);
            this.editor.setPreferredSize(new Dimension(100, 100));
            this.add((Component)directionPanel, "North");
            JPanel editorPaneBorder = new JPanel(new BorderLayout());
            editorPaneBorder.setBorder(ComponentFactory.createTitledBorder((String)"Scoping Class Description"));
            JScrollPane editorPane = ComponentFactory.createScrollPane(this.editor);
            editorPaneBorder.add(editorPane);
            this.add((Component)editorPaneBorder, "Center");
        }

        private JRadioButton findSelectedButton() {
            JRadioButton button = null;
            Enumeration<AbstractButton> directions = this.directionButtonGroup.getElements();
            boolean found = false;
            while (!found && directions.hasMoreElements()) {
                button = (JRadioButton)directions.nextElement();
                found = button.isSelected();
            }
            return found ? button : null;
        }

        public void verifiedStatusChanged(boolean newState) {
            JRadioButton button;
            this.setVariableScope(null);
            if (newState && (button = this.findSelectedButton()) != null) {
                VariableScopes.Direction direction = this.radioButtonDirectionMap.get(button);
                OWLClassExpression object = null;
                try {
                    object = (OWLClassExpression)this.editor.createObject();
                }
                catch (OWLException e) {
                    throw new RuntimeException(e);
                }
                if (direction.equals((Object)VariableScopes.Direction.SUPERCLASSOF)) {
                    this.setVariableScope((VariableScope<?>)VariableScopes.buildSuperClassVariableScope((OWLClassExpression)object, (VariableScopeChecker)this.getChecker()));
                }
                if (direction.equals((Object)VariableScopes.Direction.SUBCLASSOF)) {
                    this.setVariableScope((VariableScope<?>)VariableScopes.buildSubClassVariableScope((OWLClassExpression)object, (VariableScopeChecker)this.getChecker()));
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JRadioButton selectedButton = this.findSelectedButton();
            if (selectedButton != null) {
                VariableScopes.Direction direction = this.radioButtonDirectionMap.get(selectedButton);
                OWLClassExpression object = null;
                try {
                    object = (OWLClassExpression)this.editor.createObject();
                    if (direction.equals((Object)VariableScopes.Direction.SUPERCLASSOF)) {
                        this.setVariableScope((VariableScope<?>)VariableScopes.buildSuperClassVariableScope((OWLClassExpression)object, (VariableScopeChecker)this.getChecker()));
                    }
                    if (direction.equals((Object)VariableScopes.Direction.SUBCLASSOF)) {
                        this.setVariableScope((VariableScope<?>)VariableScopes.buildSubClassVariableScope((OWLClassExpression)object, (VariableScopeChecker)this.getChecker()));
                    }
                }
                catch (OWLException ex) {
                    this.setVariableScope(null);
                }
            }
        }

        @Override
        public void dispose() {
            this.editor.removeStatusChangedListener((InputVerificationStatusChangedListener)this);
        }

        @Override
        public void setScope(VariableScope<?> scope) {
            this.editor.setText(this.owlEditorKit.getModelManager().getRendering(scope.getScopingObject()));
            JRadioButton radioButton = this.directionRadioButtonMap.get(scope.getDirection());
            if (radioButton != null) {
                radioButton.setSelected(true);
            }
        }
    }
}

