/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.exceptions.OPPLException;
import org.coode.oppl.protege.ui.OPPLMList;
import org.coode.oppl.protege.ui.OPPLMacroListener;
import org.coode.oppl.protege.ui.OPPLMacroStatusChange;
import org.coode.oppl.protege.ui.OWLObjectListItem;
import org.coode.oppl.protege.ui.VariableList;
import org.coode.oppl.protege.ui.VariableListItem;
import org.coode.oppl.protege.ui.rendering.VariableOWLCellRenderer;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLObjectList
extends OPPLMList
implements ActionListener,
OPPLMacroStatusChange,
ListDataListener {
    private static final long serialVersionUID = 20100L;
    private final ConstraintSystem constraintSystem;
    private final List<Variable<?>> variables = new ArrayList();
    private final List<OPPLMacroListener> listeners = new ArrayList<OPPLMacroListener>();
    private final OWLEditorKit owlEditorKit;

    protected OWLObjectList(ConstraintSystem cs, OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.constraintSystem = cs;
        this.setCellRenderer(new VariableOWLCellRenderer(owlEditorKit, this.constraintSystem, new OWLCellRenderer(owlEditorKit)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof CreateNewVariableButton) {
            this.createVariable();
        } else if (e.getSource() instanceof AddToVariableButton) {
            this.addToVariable();
        }
    }

    private void addToVariable() {
        Object selectedValue = this.getSelectedValue();
        if (selectedValue instanceof OWLObjectListItem) {
            OWLObject owlObject = ((OWLObjectListItem)selectedValue).getOwlObject();
            VariableList variableList = new VariableList(this.owlEditorKit, this.constraintSystem);
            VariableType variableType = VariableTypeFactory.getVariableType((OWLObject)owlObject);
            for (Variable<?> variable : this.getVariables()) {
                if (!variable.getType().equals(variableType)) continue;
                variableList.getDefaultModel().addElement(new VariableListItem(variable, this.getConstraintSystem(), this.getOWLEditorKit(), false, false));
            }
            JScrollPane panel = ComponentFactory.createScrollPane((JComponent)((Object)variableList));
            JOptionPane jOptionPane = new JOptionPane(panel, 3, 2);
            JDialog jDialog = jOptionPane.createDialog(this.getParent(), "Choose your Variable");
            jDialog.pack();
            jDialog.setVisible(true);
            Object value = variableList.getSelectedValue();
            if (value instanceof VariableListItem) {
                Variable<?> selectedVariable = ((VariableListItem)value).getVariable();
                boolean added = this.constraintSystem.addLeaf(selectedVariable, owlObject);
                if (!added) {
                    JOptionPane.showMessageDialog(this.getParent(), "Incompatible variable selected", this.owlEditorKit.getModelManager().getRendering(owlObject), -1);
                } else {
                    this.notifyAdded2Variable(selectedVariable, owlObject);
                }
            }
        }
    }

    private void createVariable() {
        Object[] selectedValues;
        for (Object object : selectedValues = this.getSelectedValues()) {
            if (!(object instanceof OWLObjectListItem)) continue;
            OWLObjectListItem owlObjectListItem = (OWLObjectListItem)object;
            OWLObject owlObject = owlObjectListItem.getOwlObject();
            VariableType variableType = VariableTypeFactory.getVariableType((OWLObject)owlObject);
            try {
                String name = JOptionPane.showInputDialog("Please input a name for the variable that will generalise this entity: ");
                if (name == null) continue;
                name = name.startsWith("?") ? name : "?" + name;
                InputVariable variable = this.getConstraintSystem().createVariable(name, variableType, null);
                boolean added = this.getConstraintSystem().addLeaf((Variable)variable, owlObject);
                if (added) {
                    this.addVariable((Variable<?>)variable);
                    this.getDefaultModel().removeElement(owlObjectListItem);
                    continue;
                }
                JOptionPane.showMessageDialog(this.getParent(), "Incompatible variable selected", this.owlEditorKit.getModelManager().getRendering(owlObject), -1);
            }
            catch (OPPLException opplException) {
                opplException.printStackTrace();
            }
        }
    }

    private void addVariable(Variable<?> variable) {
        this.variables.add(variable);
        this.notifyAddedVariable(variable);
    }

    protected List<MListButton> getListItemButtons(MListItem item) {
        ArrayList<MListButton> toReturn = new ArrayList<MListButton>(super.getListItemButtons(item));
        toReturn.add(new CreateNewVariableButton(this));
        if (!this.getVariables().isEmpty()) {
            Iterator<Variable<?>> it = this.getVariables().iterator();
            boolean found = false;
            while (!found && it.hasNext()) {
                Variable<?> existingVariable = it.next();
                VariableType existingVariableType = existingVariable.getType();
                if (!(item instanceof OWLObjectListItem)) continue;
                VariableType itemVariableType = VariableTypeFactory.getVariableType((OWLObject)((OWLObjectListItem)item).getOwlObject());
                found = existingVariableType.equals(itemVariableType);
            }
            if (found) {
                toReturn.add(new AddToVariableButton(this));
            }
        }
        return toReturn;
    }

    private void notifyAddedVariable(Variable<?> variable) {
        for (OPPLMacroListener listener : this.listeners) {
            listener.handleGeneralisedOWLObject(variable);
        }
    }

    private void notifyAdded2Variable(Variable<?> variable, OWLObject owlObject) {
        for (OPPLMacroListener listener : this.listeners) {
            listener.handleGeneralisedOWLObject(variable, owlObject);
        }
    }

    @Override
    public void addOPPLMacroListener(OPPLMacroListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeOPPLMacroListener(OPPLMacroListener listener) {
        this.listeners.remove(listener);
    }

    public List<Variable<?>> getVariables() {
        return this.variables;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        Object source = e.getSource();
        if (source instanceof DefaultListModel) {
            this.updateVariables((DefaultListModel)source);
        }
    }

    private void updateVariables(DefaultListModel<Object> model) {
        this.variables.clear();
        for (int i = 0; i < model.getSize(); ++i) {
            VariableListItem item = (VariableListItem)model.getElementAt(i);
            this.variables.add(item.getVariable());
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        Object source = e.getSource();
        if (source instanceof DefaultListModel) {
            this.updateVariables((DefaultListModel)source);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        Object source = e.getSource();
        if (source instanceof DefaultListModel) {
            this.updateVariables((DefaultListModel)source);
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    static class AddToVariableButton
    extends MListButton {
        protected AddToVariableButton(ActionListener actionListener) {
            super("Add to Variable", new Color(0, 0, 255), actionListener);
        }

        public void paintButtonContent(Graphics2D g) {
            int stringWidth = g.getFontMetrics().getStringBounds((String)"V+", (Graphics)g).getBounds().width;
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            g.drawString("V+", this.getBounds().x + w / 2 - stringWidth / 2, this.getBounds().y + g.getFontMetrics().getAscent() / 2 + h / 2);
        }
    }

    static class CreateNewVariableButton
    extends MListButton {
        protected CreateNewVariableButton(ActionListener actionListener) {
            super("Create new Variable", new Color(0, 0, 255), actionListener);
        }

        public void paintButtonContent(Graphics2D g) {
            int stringWidth = g.getFontMetrics().getStringBounds((String)"V*", (Graphics)g).getBounds().width;
            int w = this.getBounds().width;
            int h = this.getBounds().height;
            g.drawString("V*", this.getBounds().x + w / 2 - stringWidth / 2, this.getBounds().y + g.getFontMetrics().getAscent() / 2 + h / 2);
        }
    }
}

