/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.protege.ui.AxiomEditor;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OWLAxiomChangeEditor
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private final OWLEditorKit owlEditorKit;
    private final AxiomEditor axiomEditor;
    private final ButtonGroup actionButtonGroup = new ButtonGroup();
    private final Map<JRadioButton, String> radioButtonActionMap = new HashMap<JRadioButton, String>();
    private final Map<String, JRadioButton> actionStringRadioButtonMap = new HashMap<String, JRadioButton>();
    private OWLAxiomChange owlAxiomChange;

    public OWLAxiomChangeEditor(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.owlEditorKit = owlEditorKit;
        this.axiomEditor = new AxiomEditor(this.owlEditorKit, constraintSystem);
        this.axiomEditor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OWLAxiomChangeEditor.this.handleChange();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel actionPanel = new JPanel(new GridLayout(0, 2));
        JRadioButton addRadioButton = new JRadioButton("ADD");
        addRadioButton.setSelected(true);
        this.radioButtonActionMap.put(addRadioButton, "ADD");
        this.actionStringRadioButtonMap.put("ADD", addRadioButton);
        this.actionButtonGroup.add(addRadioButton);
        actionPanel.add(addRadioButton);
        JRadioButton removeRadioButton = new JRadioButton("REMOVE");
        this.radioButtonActionMap.put(removeRadioButton, "REMOVE");
        this.actionStringRadioButtonMap.put("REMOVE", removeRadioButton);
        this.actionButtonGroup.add(removeRadioButton);
        actionPanel.add(removeRadioButton);
        actionPanel.setBorder(ComponentFactory.createTitledBorder((String)"Action Type:"));
        this.setLayout(new BorderLayout());
        this.add((Component)actionPanel, "North");
        this.add((Component)this.axiomEditor, "Center");
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        listener.verifiedStatusChanged(this.check());
        this.listeners.add(listener);
    }

    private boolean check() {
        return this.findSelectedButton() != null && this.axiomEditor.getAxiom() != null;
    }

    public void handleChange() {
        boolean isValid = this.check();
        if (isValid) {
            OWLAxiom axiom = this.axiomEditor.getAxiom();
            JRadioButton selectedButton = this.findSelectedButton();
            String action = this.radioButtonActionMap.get(selectedButton);
            OWLOntology activeOntology = this.owlEditorKit.getOWLModelManager().getActiveOntology();
            this.owlAxiomChange = action.equals("ADD") ? new AddAxiom(activeOntology, axiom) : new RemoveAxiom(activeOntology, axiom);
        }
        this.notifyLIstenrs(isValid);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyLIstenrs(boolean newState) {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            listener.verifiedStatusChanged(newState);
        }
    }

    private JRadioButton findSelectedButton() {
        JRadioButton button = null;
        Enumeration<AbstractButton> actions = this.actionButtonGroup.getElements();
        boolean found = false;
        while (!found && actions.hasMoreElements()) {
            button = (JRadioButton)actions.nextElement();
            found = button.isSelected();
        }
        return found ? button : null;
    }

    public OWLAxiomChange getOwlAxiomChange() {
        return this.owlAxiomChange;
    }

    public void dispose() {
    }

    public void setOWLAxiomChange(OWLAxiomChange owlAxiomChange) {
        this.clear();
        JRadioButton radioButton = owlAxiomChange.isAddAxiom() ? this.actionStringRadioButtonMap.get("ADD") : this.actionStringRadioButtonMap.get("REMOVE");
        radioButton.setSelected(true);
        this.axiomEditor.setOWLAxiom(owlAxiomChange.getAxiom());
    }

    public void clear() {
        JRadioButton button = null;
        Enumeration<AbstractButton> actions = this.actionButtonGroup.getElements();
        while (actions.hasMoreElements()) {
            button = (JRadioButton)actions.nextElement();
            button.setSelected(false);
        }
        this.axiomEditor.clear();
    }
}

