/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.coode.oppl.ChangeExtractor;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ExecutionMonitor;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.OPPLScriptVisitorEx;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.ActionList;
import org.coode.oppl.protege.ui.ActionListModel;
import org.coode.oppl.protege.ui.CopyAction;
import org.coode.oppl.protege.ui.InstantiationTableModel;
import org.coode.oppl.protege.ui.OPPLEditor;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.protege.ui.rendering.InstantiationTableCellRenderer;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.utils.EvaluationResults;
import org.coode.oppl.validation.OPPLScriptValidator;
import org.coode.oppl.variabletypes.InputVariable;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.ui.list.OWLLinkedObjectList;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public final class OPPLView
extends AbstractOWLViewComponent
implements InputVerificationStatusChangedListener {
    private static final String INSTANTIATED_AXIOMS_TITLE = "Instantiated axioms: ";
    private static final String BINDINGS_TITLE = "Bindings";
    private static final String AFFECTED_AXIOMS_TITLE = "Affected axioms";
    private RuntimeExceptionHandler runtimeExceptionHandler;
    private static final long serialVersionUID = 20100L;
    private static final String OPPL_COMPUTATION_IN_PROGRESS_PLEASE_WAIT = "OPPL Computation in progress...please wait";
    protected OPPLEditor editor;
    protected final ReasonerOPPLScriptValiator validator = new ReasonerOPPLScriptValiator();
    protected final JButton evaluate = new JButton("Evaluate");
    protected final JButton stopEvaluation = new JButton("Cancel");
    protected final JButton execute = new JButton("Execute");
    protected ActionList affectedAxioms;
    protected final InstantiatedAxiomListModel instantiatedAxiomListModel = new InstantiatedAxiomListModel();
    protected OWLLinkedObjectList instantiatedAxiomsList;
    protected OPPLScript statementModel;
    protected JDialog window;
    protected JScrollPane affectedScrollPane;
    protected JScrollPane instantiatedScrollPane;
    protected final JCheckBox considerImportClosureCheckBox = new JCheckBox("When removing consider Active Ontology Imported Closure", false);
    protected final CopyAction copyResultsAction = new CopyAction("Copy results to Clipboard");
    protected final BoundedRangeModel progressBarModel = new DefaultBoundedRangeModel();
    protected TableModel bindingTableModel = InstantiationTableModel.getNoOPPLScriptTableModel();
    protected final JTable bindingTable = new JTable(this.bindingTableModel);
    protected JScrollPane bindingTreeScrollPane;
    protected OPPLChangeDetectorSwingWorker opplSwingWorker;

    protected void disposeOWLView() {
        this.editor.removeStatusChangedListener(this);
        this.editor.dispose();
        ProtegeParserFactory.getInstance(this.getOWLEditorKit()).dispose();
    }

    protected void initialiseOWLView() {
        this.setLayout(new BorderLayout());
        JSplitPane mainPanel = new JSplitPane(0);
        mainPanel.setDividerLocation(0.6);
        mainPanel.setResizeWeight(0.6);
        JPanel statementPanel = new JPanel(new BorderLayout());
        ProtegeParserFactory.reset();
        OPPLAbstractFactory opplFactory = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).getOPPLFactory();
        this.runtimeExceptionHandler = new ShowMessageRuntimeExceptionHandler((Component)((Object)this));
        this.affectedAxioms = new ActionList(this.getOWLEditorKit(), new ConstraintSystem(this.getOWLEditorKit().getModelManager().getActiveOntology(), this.getOWLEditorKit().getModelManager().getOWLOntologyManager(), opplFactory), false);
        this.instantiatedAxiomsList = new OWLLinkedObjectList(this.getOWLEditorKit());
        this.instantiatedAxiomsList.setModel((ListModel)this.instantiatedAxiomListModel);
        OWLCellRenderer cellRenderer = new OWLCellRenderer(this.getOWLEditorKit());
        cellRenderer.setWrap(true);
        cellRenderer.setHighlightKeywords(true);
        this.considerImportClosureCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OPPLView.this.affectedAxioms.getDefaultModel().clear();
                OPPLView.this.affectedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)"Affected axioms: "));
                OPPLView.this.evaluate.setEnabled(OPPLView.this.statementModel != null);
                OPPLView.this.copyResultsAction.setEnabled(false);
                OPPLView.this.execute.setEnabled(false);
            }
        });
        this.instantiatedAxiomsList.setCellRenderer((ListCellRenderer)cellRenderer);
        this.editor = new OPPLEditor(this.getOWLEditorKit(), this.validator);
        this.editor.setPreferredSize(new Dimension(200, 300));
        statementPanel.add((Component)this.evaluate, "South");
        mainPanel.add((Component)statementPanel, "top");
        JSplitPane effects = new JSplitPane();
        this.affectedScrollPane = ComponentFactory.createScrollPane((JComponent)((Object)this.affectedAxioms));
        this.instantiatedScrollPane = ComponentFactory.createScrollPane((JComponent)this.instantiatedAxiomsList);
        this.instantiatedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)INSTANTIATED_AXIOMS_TITLE));
        this.affectedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)AFFECTED_AXIOMS_TITLE));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.copyResultsAction);
        statementPanel.add((Component)ComponentFactory.createScrollPane((JComponent)this.editor), "Center");
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add((Component)toolBar, "West");
        toolBarPanel.add((Component)this.considerImportClosureCheckBox, "East");
        bottomPanel.add((Component)toolBarPanel, "North");
        effects.add((Component)this.affectedScrollPane, "left");
        JSplitPane instantiatonPanel = new JSplitPane();
        this.bindingTreeScrollPane = ComponentFactory.createScrollPane((JComponent)this.bindingTable);
        this.bindingTreeScrollPane.setBorder(ComponentFactory.createTitledBorder((String)BINDINGS_TITLE));
        instantiatonPanel.add((Component)this.bindingTreeScrollPane, "left");
        instantiatonPanel.add((Component)this.instantiatedScrollPane, "right");
        effects.add((Component)instantiatonPanel, "right");
        bottomPanel.add((Component)effects, "Center");
        mainPanel.add((Component)bottomPanel, "bottom");
        this.add(mainPanel, "Center");
        this.add(this.execute, "South");
        this.evaluate.setEnabled(false);
        this.execute.setEnabled(false);
        this.copyResultsAction.setEnabled(false);
        this.evaluate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OPPLView.this.evaluate.setEnabled(false);
                OPPLView.this.copyResultsAction.setEnabled(false);
                OPPLView.this.setupOPPLProgressMonitor();
                OPPLView.this.opplSwingWorker = new OPPLChangeDetectorSwingWorker();
                OPPLView.this.window.pack();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OPPLView.this.window.setVisible(true);
                    }
                });
                OPPLView.this.opplSwingWorker.execute();
            }
        });
        this.stopEvaluation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OPPLView.this.opplSwingWorker.cancel(true);
            }
        });
        this.affectedAxioms.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                OPPLView.this.execute.setEnabled(OPPLView.this.affectedAxioms.getModel().getSize() > 0);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                OPPLView.this.execute.setEnabled(OPPLView.this.affectedAxioms.getModel().getSize() > 0);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                OPPLView.this.execute.setEnabled(OPPLView.this.affectedAxioms.getModel().getSize() > 0);
            }
        });
        this.execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionListModel model = (ActionListModel)OPPLView.this.affectedAxioms.getModel();
                OPPLView.this.setupOPPLProgressMonitor();
                OPPLView.this.window.pack();
                List<OWLAxiomChange> changes = model.getOWLAxiomChanges();
                OPPLExecutorSwingWorker executorSwingWorker = new OPPLExecutorSwingWorker(changes);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OPPLView.this.affectedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)OPPLView.AFFECTED_AXIOMS_TITLE));
                        OPPLView.this.editor.clear();
                        OPPLView.this.window.setVisible(true);
                    }
                });
                executorSwingWorker.execute();
                model.clear();
            }
        });
        this.editor.addStatusChangedListener(this);
        this.bindingTable.setDefaultRenderer(OWLObject.class, new InstantiationTableCellRenderer(this.getOWLEditorKit()));
        this.bindingTable.setDefaultRenderer(Set.class, new InstantiationTableCellRenderer(this.getOWLEditorKit()));
        this.bindingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && OPPLView.this.bindingTable.getModel() instanceof InstantiationTableModel) {
                    InstantiationTableModel instantiationTableModel = (InstantiationTableModel)OPPLView.this.bindingTable.getModel();
                    int[] selectedRows = OPPLView.this.bindingTable.getSelectedRows();
                    HashSet<BindingNode> bindingNodes = new HashSet<BindingNode>(selectedRows.length);
                    for (int i : selectedRows) {
                        bindingNodes.add(instantiationTableModel.getLeaves().get(i));
                    }
                    OPPLView.this.instantiatedAxiomListModel.setBindingNodes(bindingNodes);
                }
            }
        });
    }

    protected final void setupOPPLProgressMonitor() {
        JPanel panel = new JPanel(new BorderLayout(7, 7));
        this.progressBarModel.setValue(0);
        JProgressBar progressBar = new JProgressBar(this.progressBarModel);
        JPanel progressPanel = new JPanel(new FlowLayout(1));
        progressPanel.add(progressBar);
        progressPanel.add(this.stopEvaluation);
        panel.add((Component)progressPanel, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel(OPPL_COMPUTATION_IN_PROGRESS_PLEASE_WAIT);
        panel.add((Component)label, "North");
        this.window = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)this.getOWLEditorKit().getWorkspace()), "OPPL Engine progress", true);
        this.window.setLocation(400, 400);
        JPanel holderPanel = new JPanel(new BorderLayout(7, 7));
        holderPanel.add((Component)panel, "North");
        holderPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)holderPanel, "North");
        this.window.pack();
        Dimension windowSize = this.window.getSize();
        this.window.setSize(400, windowSize.height);
        this.window.setResizable(false);
    }

    public void verifiedStatusChanged(boolean newState) {
        this.instantiatedAxiomListModel.clear();
        this.bindingTableModel = InstantiationTableModel.getNoOPPLScriptTableModel();
        this.bindingTable.setModel(this.bindingTableModel);
        this.evaluate.setEnabled(newState);
        this.copyResultsAction.setEnabled(false);
        this.bindingTreeScrollPane.setBorder(ComponentFactory.createTitledBorder((String)BINDINGS_TITLE));
        this.affectedAxioms.getDefaultModel().clear();
        this.affectedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)AFFECTED_AXIOMS_TITLE));
        if (newState) {
            this.statementModel = this.editor.getOPPLScript();
            this.bindingTableModel = new InstantiationTableModel(this.statementModel, this.getOWLEditorKit());
            this.bindingTable.setModel(this.bindingTableModel);
        }
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public void setRuntimeExceptionHandler(RuntimeExceptionHandler runtimeExceptionHandler) {
        this.runtimeExceptionHandler = runtimeExceptionHandler;
    }

    class OPPLChangeDetectorSwingWorker
    extends SwingWorker<List<OWLAxiomChange>, OPPLScript> {
        OPPLChangeDetectorSwingWorker() {
        }

        @Override
        protected void done() {
            try {
                List changes = (List)this.get();
                ActionListModel model = (ActionListModel)OPPLView.this.affectedAxioms.getModel();
                model.clear();
                if (!this.isCancelled()) {
                    if (changes != null) {
                        for (OWLAxiomChange axiomChange : changes) {
                            model.addAction(axiomChange, false, true);
                        }
                        OPPLView.this.revalidate();
                        EvaluationResults evaluationResults = new EvaluationResults(OPPLView.this.statementModel, changes);
                        OPPLView.this.copyResultsAction.setEnabled(true);
                        OPPLView.this.copyResultsAction.setResult(evaluationResults.toString());
                        OPPLView.this.bindingTableModel = new InstantiationTableModel(OPPLView.this.statementModel, OPPLView.this.getOWLEditorKit());
                        OPPLView.this.bindingTable.setModel(OPPLView.this.bindingTableModel);
                        OPPLView.this.bindingTreeScrollPane.setBorder(ComponentFactory.createTitledBorder((String)String.format("%s: %d", OPPLView.BINDINGS_TITLE, OPPLView.this.bindingTableModel.getRowCount())));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OPPLView.this.affectedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)String.format("%s: %d", OPPLView.AFFECTED_AXIOMS_TITLE, OPPLView.this.affectedAxioms.getModel().getSize())));
                                OPPLView.this.window.setVisible(false);
                                OPPLView.this.window.dispose();
                            }
                        });
                    }
                } else {
                    OPPLView.this.evaluate.setEnabled(true);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (CancellationException e) {
                ActionListModel model = (ActionListModel)OPPLView.this.affectedAxioms.getModel();
                model.clear();
                OPPLView.this.evaluate.setEnabled(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OPPLView.this.affectedScrollPane.setBorder(ComponentFactory.createTitledBorder((String)String.format("%s: %d", OPPLView.AFFECTED_AXIOMS_TITLE, OPPLView.this.affectedAxioms.getModel().getSize())));
                        OPPLView.this.window.setVisible(false);
                        OPPLView.this.window.dispose();
                    }
                });
            }
        }

        @Override
        protected List<OWLAxiomChange> doInBackground() {
            ArrayList<OWLAxiomChange> result = new ArrayList<OWLAxiomChange>();
            try {
                ChangeExtractor changeExtractor = new ChangeExtractor(OPPLView.this.getRuntimeExceptionHandler(), new ExecutionMonitor(){

                    public boolean isCancelled() {
                        return OPPLChangeDetectorSwingWorker.this.isCancelled();
                    }

                    public void progressIncrementChanged(int newValue) {
                        OPPLView.this.progressBarModel.setValue(newValue);
                    }
                }, OPPLView.this.considerImportClosureCheckBox.isSelected());
                result.addAll(changeExtractor.visit(OPPLView.this.statementModel));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    class OPPLExecutorSwingWorker
    extends SwingWorker<List<OWLAxiomChange>, OPPLScript> {
        private final List<OWLAxiomChange> changes = new ArrayList<OWLAxiomChange>();

        protected OPPLExecutorSwingWorker(List<OWLAxiomChange> changes) {
            this.changes.addAll(changes);
        }

        @Override
        protected List<OWLAxiomChange> doInBackground() {
            OPPLView.this.getOWLEditorKit().getModelManager().applyChanges(this.changes);
            return this.changes;
        }

        @Override
        protected void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OPPLView.this.window.setVisible(false);
                    OPPLView.this.window.dispose();
                }
            });
        }
    }

    private final class ReasonerOPPLScriptValiator
    implements OPPLScriptValidator {
        public boolean accept(OPPLScript script) {
            OWLReasoner reasoner = OPPLView.this.getOWLEditorKit().getModelManager().getReasoner();
            Boolean accept = (Boolean)script.accept((OPPLScriptVisitorEx)new ScriptVisitor());
            return !(reasoner instanceof NoOpReasoner) || accept != false;
        }

        public String getValidationRuleDescription() {
            return "If the script contains scoped variables the selected reasoner cannot be NoOpReasoner";
        }

        private final class ScriptVisitor
        implements OPPLScriptVisitorEx<Boolean> {
            public Boolean visitActions(List<OWLAxiomChange> changes, Boolean p) {
                return p == null ? true : p;
            }

            public Boolean visit(OPPLQuery q, Boolean p) {
                return p == null ? true : p;
            }

            public Boolean visit(Variable<?> v, Boolean p) {
                AbstractVariableVisitorExAdapter<Boolean> nullScopeDetector = new AbstractVariableVisitorExAdapter<Boolean>(Boolean.valueOf(true)){

                    public <P extends OWLObject> Boolean visit(InputVariable<P> iv) {
                        return iv.getVariableScope() == null;
                    }
                };
                return p == null ? (Boolean)v.accept((VariableVisitorEx)nullScopeDetector) : p != false || (Boolean)v.accept((VariableVisitorEx)nullScopeDetector) != false;
            }
        }
    }

    private final class InstantiatedAxiomListModel
    implements ListModel<OWLAxiom> {
        private final Set<BindingNode> bindingNodes = new HashSet<BindingNode>();
        private final Set<ListDataListener> listeners = new HashSet<ListDataListener>();
        private final List<OWLAxiom> instantiations = new ArrayList<OWLAxiom>();

        private final void init() {
            this.instantiations.clear();
            for (BindingNode leaf : this.getBindingNodes()) {
                this.instantiateAxioms(leaf);
            }
            this.notifyListeners();
        }

        public void clear() {
            this.bindingNodes.clear();
            this.init();
        }

        public void setBindingNodes(Collection<? extends BindingNode> bindingNodes) {
            this.bindingNodes.clear();
            this.bindingNodes.addAll(bindingNodes);
            this.init();
        }

        private void instantiateAxioms(BindingNode leaf) {
            OPPLQuery query;
            if (OPPLView.this.statementModel != null && (query = OPPLView.this.statementModel.getQuery()) != null) {
                PartialOWLObjectInstantiator partialOWLObjectInstantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)new SimpleValueComputationParameters(OPPLView.this.statementModel.getConstraintSystem(), leaf, OPPLView.this.getRuntimeExceptionHandler()));
                List assertedAxioms = query.getAssertedAxioms();
                for (OWLAxiom owlAxiom : assertedAxioms) {
                    this.instantiations.add((OWLAxiom)owlAxiom.accept((OWLObjectVisitorEx)partialOWLObjectInstantiator));
                }
                List axioms = query.getAxioms();
                for (OWLAxiom owlAxiom : axioms) {
                    this.instantiations.add((OWLAxiom)owlAxiom.accept((OWLObjectVisitorEx)partialOWLObjectInstantiator));
                }
            }
        }

        private void notifyListeners() {
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(new ListDataEvent(this, 0, 0, this.instantiations.size() - 1));
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            if (l != null) {
                this.listeners.add(l);
            }
        }

        @Override
        public OWLAxiom getElementAt(int index) {
            return this.instantiations.get(index);
        }

        @Override
        public int getSize() {
            return this.instantiations.size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public Set<BindingNode> getBindingNodes() {
            return new HashSet<BindingNode>(this.bindingNodes);
        }
    }
}

