/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.validation.OPPLScriptValidator;
import org.coode.parsers.oppl.ui.autocompletionmatcher.ProtegeOPPLAutoCompletionMatcher;
import org.coode.parsers.ui.AutoCompleter;
import org.coode.parsers.ui.ExpressionEditor;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.coode.parsers.ui.autocompletionmatcher.AutoCompletionMatcher;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public final class OPPLTextEditor
extends JPanel
implements VerifiedInputEditor,
OWLModelManagerListener {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private final OWLEditorKit owlEditorKit;
    private OPPLScript opplScript = null;
    protected final ExpressionEditor<OPPLScript> editor;
    protected final OPPLScriptValidator validator;
    private final OPPLExpressionChecker<OPPLScript> opplExpressionChecker;
    private final ProtegeOPPLAutoCompletionMatcher autoCompletionMatcher;
    private final OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OPPLTextEditor.this.editor.setText(OPPLTextEditor.this.editor.getText());
        }
    };
    private final OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            OPPLTextEditor.this.editor.setText(OPPLTextEditor.this.editor.getText());
        }
    };

    public OPPLScript getOPPLScript() {
        return this.opplScript;
    }

    public void setOPPLScript(OPPLScript opplScript) {
        String rendering = opplScript.render();
        this.editor.setText(rendering);
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    protected OPPLTextEditor(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, null);
    }

    protected OPPLTextEditor(OWLEditorKit owlEditorKit, OPPLScriptValidator validator) {
        this.owlEditorKit = owlEditorKit;
        this.validator = validator;
        this.opplExpressionChecker = new OPPLExpressionChecker<OPPLScript>(this.getOWLEditorKit()){

            @Override
            protected OPPLScript parse(String text) {
                ProtegeParserFactory factory = ProtegeParserFactory.getInstance(this.getOWLEditorKit());
                OPPLParser parser = factory.build(this.getListener());
                OPPLScript toReturn = parser.parse(text);
                return toReturn;
            }
        };
        this.editor = new ExpressionEditor(this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager(), this.opplExpressionChecker);
        this.editor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OPPLTextEditor.this.handleChange();
            }
        });
        this.getOWLEditorKit().getOWLModelManager().addListener(this.modelManagerListener);
        this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().addOntologyChangeListener(this.ontologyChangeListener);
        this.autoCompletionMatcher = new ProtegeOPPLAutoCompletionMatcher(this.getOWLEditorKit());
        this.getOWLEditorKit().getModelManager().addListener((OWLModelManagerListener)this);
        new AutoCompleter(this.editor, (AutoCompletionMatcher)this.autoCompletionMatcher);
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.add(ComponentFactory.createScrollPane(this.editor));
    }

    protected void handleChange() {
        boolean b = this.check();
        this.notifyListeners(b);
    }

    private boolean check() {
        this.opplScript = (OPPLScript)this.editor.createObject();
        return this.opplScript != null;
    }

    private void notifyListeners(boolean b) {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(b);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add((InputVerificationStatusChangedListener)ArgCheck.checkNotNull((Object)listener, (String)"listener"));
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void clear() {
        this.editor.setText("");
    }

    @Override
    public String getName() {
        return "OPPL Text Editor";
    }

    public void handleChange(OWLModelManagerChangeEvent event) {
        EventType type = event.getType();
        if (type.equals((Object)EventType.REASONER_CHANGED)) {
            this.handleChange();
        }
    }

    public void dispose() {
        this.getOWLEditorKit().getModelManager().removeListener((OWLModelManagerListener)this);
        this.autoCompletionMatcher.dispose();
        this.getOWLEditorKit().getOWLModelManager().removeListener(this.modelManagerListener);
        this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager().removeOntologyChangeListener(this.ontologyChangeListener);
    }
}

