/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.protege.ui.OPPLMList;
import org.coode.oppl.protege.ui.OPPLSelectClauseListItem;
import org.coode.oppl.protege.ui.rendering.VariableOWLCellRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;

public class OPPLSelectClauseList
extends OPPLMList {
    private static final long serialVersionUID = 20100L;
    private final OWLEditorKit owlEditorKit;
    private final ConstraintSystem constraintSystem;

    public OPPLSelectClauseList(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        DefaultListModel<Object> model = this.clearModel();
        this.setModel(model);
        this.setCellRenderer(new OPPLSelectListItemCellRederer());
    }

    private DefaultListModel<Object> clearModel() {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        model.addElement(new MListSectionHeader(){

            public boolean canAdd() {
                return true;
            }

            public String getName() {
                return "SELECT";
            }
        });
        return model;
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Border toReturn = super.createListItemBorder(list, value, index, isSelected, cellHasFocus);
        if (value instanceof OPPLSelectClauseListItem && ((OPPLSelectClauseListItem)value).isAsserted()) {
            toReturn = BorderFactory.createCompoundBorder(toReturn, new OPPLAssertedSelectClauseListItemBorder());
        }
        return toReturn;
    }

    public void clear() {
        this.setModel(this.clearModel());
    }

    public final OWLEditorKit getOwlEditorKit() {
        return this.owlEditorKit;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    private class OPPLSelectListItemCellRederer
    implements ListCellRenderer {
        private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        private final VariableOWLCellRenderer variableAxiomRenderer = new VariableOWLCellRenderer(OPPLSelectClauseList.this.getOwlEditorKit(), OPPLSelectClauseList.this.getConstraintSystem(), new OWLCellRenderer(OPPLSelectClauseList.this.getOwlEditorKit()));

        public OPPLSelectListItemCellRederer() {
            this.variableAxiomRenderer.setHighlightKeywords(true);
            this.variableAxiomRenderer.setWrap(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component toReturn = this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof OPPLSelectClauseListItem) {
                OPPLSelectClauseListItem item = (OPPLSelectClauseListItem)value;
                toReturn = this.variableAxiomRenderer.getListCellRendererComponent(list, item, index, isSelected, cellHasFocus);
            }
            return toReturn;
        }
    }

    private static class OPPLAssertedSelectClauseListItemBorder
    implements Border {
        private static final String ASSERTED = "ASSERTED";

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, c.getFontMetrics((Font)c.getFont()).getStringBounds((String)ASSERTED, (Graphics)c.getGraphics()).getBounds().width + 8, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(Color.DARK_GRAY);
            g.drawString(ASSERTED, x + 4, y + 2 + g.getFontMetrics().getAscent() + g.getFontMetrics().getLeading());
            g.setColor(oldColor);
        }
    }
}

