/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.protege.ui.AxiomEditor;
import org.coode.oppl.protege.ui.OPPLSelectClauseListItem;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;

public class OPPLSelectClauseEditor
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 20100L;
    private final OWLEditorKit owlEditorKit;
    private final ConstraintSystem constraintSystem;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private final AxiomEditor axiomEditor;
    private final JCheckBox assertedCheckBox = new JCheckBox("ASSERTED");
    private OPPLSelectClauseListItem selectListItem;

    public OPPLSelectClauseListItem getSelectListItem() {
        return this.selectListItem;
    }

    public void setSelectListItem(OPPLSelectClauseListItem selectListItem) {
        this.assertedCheckBox.setSelected(selectListItem.isAsserted());
        this.axiomEditor.setOWLAxiom(selectListItem.getAxiom());
    }

    public OPPLSelectClauseEditor(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.setLayout(new BorderLayout());
        this.owlEditorKit = owlEditorKit;
        this.constraintSystem = constraintSystem;
        this.axiomEditor = new AxiomEditor(this.owlEditorKit, this.constraintSystem);
        JPanel axiomEditorPanel = new JPanel(new BorderLayout());
        axiomEditorPanel.add(ComponentFactory.createScrollPane((JComponent)this.axiomEditor));
        this.axiomEditor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OPPLSelectClauseEditor.this.handleChange();
            }
        });
        this.add((Component)axiomEditorPanel, "Center");
        this.assertedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OPPLSelectClauseEditor.this.handleChange();
            }
        });
        this.add((Component)this.assertedCheckBox, "East");
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.check());
    }

    private boolean check() {
        return this.axiomEditor.getAxiom() != null;
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void handleChange() {
        boolean isValid = this.check();
        if (isValid) {
            this.selectListItem = new OPPLSelectClauseListItem(this.assertedCheckBox.getModel().isSelected(), this.axiomEditor.getAxiom());
        }
        this.notifyListeners(isValid);
    }

    private void notifyListeners(boolean isValid) {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            listener.verifiedStatusChanged(isValid);
        }
    }

    public void dispose() {
    }
}

