/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.coode.oppl.InstantiatedOPPLScript;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.semanticweb.owlapi.model.OWLException;

public abstract class OPPLScriptInstantiationEditor<P extends InstantiatedOPPLScript>
implements VerifiedInputEditor,
InputVerificationStatusChangedListener {
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    protected ExpressionEditor<P> editor;
    protected OWLEditorKit owlEditorKit;
    protected JPanel mainPane = new JPanel(new BorderLayout());
    protected P instantiatedScript = null;

    public OPPLScriptInstantiationEditor(P instantiatedOPPLScript, OWLEditorKit owlEditorKit) {
        this.instantiatedScript = instantiatedOPPLScript;
        this.owlEditorKit = owlEditorKit;
        this.init();
    }

    protected void init() {
        this.editor = this.getScriptExpressionEditor();
        this.removeKeyListeners();
        this.setupAutoCompleter();
    }

    protected abstract void setupAutoCompleter();

    protected abstract ExpressionEditor<P> getScriptExpressionEditor();

    private void removeKeyListeners() {
        KeyListener[] keyListeners;
        for (KeyListener keyListener : keyListeners = this.editor.getKeyListeners()) {
            this.editor.removeKeyListener(keyListener);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        this.notifyListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListener(InputVerificationStatusChangedListener listener) {
        boolean valid = this.instantiatedScript != null ? this.instantiatedScript.isValid() : false;
        listener.verifiedStatusChanged(valid);
    }

    public void verifiedStatusChanged(boolean newState) {
        this.instantiatedScript = null;
        if (newState) {
            try {
                this.instantiatedScript = (InstantiatedOPPLScript)this.editor.createObject();
                this.handleChange();
            }
            catch (OWLExpressionParserException e) {
                e.printStackTrace();
            }
            catch (OWLException e) {
                e.printStackTrace();
            }
        }
        this.handleChange();
    }

    public void handleChange() {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            this.notifyListener(listener);
        }
    }

    public void clear() {
        this.mainPane.removeAll();
        this.init();
    }

    public void dispose() {
        this.editor.removeStatusChangedListener((InputVerificationStatusChangedListener)this);
    }

    public InstantiatedOPPLScript getEditedObject() {
        return this.instantiatedScript;
    }

    public JComponent getEditorComponent() {
        return this.mainPane;
    }
}

