/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OWLObjectAbstractor;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.ActionList;
import org.coode.oppl.protege.ui.ActionListItem;
import org.coode.oppl.protege.ui.ActionListModel;
import org.coode.oppl.protege.ui.OPPLMacroListener;
import org.coode.oppl.protege.ui.OWLObjectList;
import org.coode.oppl.protege.ui.OWLObjectListItem;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.protege.ui.VariableList;
import org.coode.oppl.protege.ui.VariableListItem;
import org.coode.oppl.protege.ui.rendering.VariableOWLCellRenderer;
import org.coode.oppl.utils.AbstractVariableVisitorExAdapter;
import org.coode.oppl.variabletypes.InputVariable;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OPPLMacroView
extends AbstractOWLViewComponent
implements OWLOntologyChangeListener,
ListDataListener,
OPPLMacroListener {
    private static final long serialVersionUID = 20100L;
    private RuntimeExceptionHandler runtimeExceptionHandler;
    protected ActionList recordedActions;
    private OWLObjectList entities;
    protected VariableList variableList;
    protected JButton recordButton;
    protected JButton stopButton;
    private JButton copy2ClipboardButton;
    private JButton clearButton;
    protected ConstraintSystem constraintSystem;

    public void initialiseOWLView() {
        this.constraintSystem = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).getOPPLFactory().createConstraintSystem();
        this.runtimeExceptionHandler = new ShowMessageRuntimeExceptionHandler((Component)((Object)this));
        this.setLayout(new BorderLayout());
        this.recordedActions = new ActionList(this.getOWLEditorKit(), this.constraintSystem, false);
        JScrollPane recordedActionsScrollPane = ComponentFactory.createScrollPane((JComponent)((Object)this.recordedActions));
        JPanel recordedActionBorderPanel = new JPanel(new BorderLayout());
        recordedActionBorderPanel.setBorder(ComponentFactory.createTitledBorder((String)"Recorded actions"));
        recordedActionBorderPanel.add(recordedActionsScrollPane);
        JToolBar recorderToolBar = new JToolBar();
        this.recordButton = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("record-button.jpg")));
        this.recordButton.setToolTipText("Start Recording");
        this.recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLModelManager modelManager = OPPLMacroView.this.getOWLEditorKit().getModelManager();
                modelManager.addOntologyChangeListener((OWLOntologyChangeListener)OPPLMacroView.this);
                OPPLMacroView.this.stopButton.setEnabled(true);
                OPPLMacroView.this.recordButton.setEnabled(false);
            }
        });
        this.stopButton = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("stop-button.jpg")));
        this.stopButton.setToolTipText("Stop Recording");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OPPLMacroView.this.getOWLEditorKit().getModelManager().removeOntologyChangeListener((OWLOntologyChangeListener)OPPLMacroView.this);
                OPPLMacroView.this.recordButton.setEnabled(true);
                OPPLMacroView.this.stopButton.setEnabled(false);
            }
        });
        this.copy2ClipboardButton = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("copy2Cipboard.jpg")));
        this.copy2ClipboardButton.setToolTipText("Copy OPPL");
        this.copy2ClipboardButton.setEnabled(false);
        this.copy2ClipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder opplString = new StringBuilder();
                DefaultListModel<Object> variableModel = OPPLMacroView.this.variableList.getDefaultModel();
                boolean first = true;
                for (int i = 0; i < variableModel.getSize(); ++i) {
                    Object variableElement = variableModel.getElementAt(i);
                    if (!(variableElement instanceof VariableListItem)) continue;
                    Variable<?> v = ((VariableListItem)variableElement).getVariable();
                    String variableString = " " + v.toString();
                    VariableScope variableScope = (VariableScope)v.accept((VariableVisitorEx)new AbstractVariableVisitorExAdapter<VariableScope<?>>(null){

                        public <P extends OWLObject> VariableScope<?> visit(InputVariable<P> iv) {
                            return iv.getVariableScope();
                        }
                    });
                    if (variableScope != null) {
                        String scopeString = "[" + variableScope.getDirection().toString() + " " + OPPLMacroView.this.getOWLModelManager().getRendering(variableScope.getScopingObject()) + "]";
                        variableString = variableString + scopeString;
                    }
                    if (!first) {
                        opplString.append(',');
                    }
                    first = false;
                    opplString.append(variableString);
                }
                first = true;
                DefaultListModel<Object> actionModel = OPPLMacroView.this.recordedActions.getDefaultModel();
                opplString.append("\nBEGIN");
                VariableOWLCellRenderer cellRenderer = new VariableOWLCellRenderer(OPPLMacroView.this.getOWLEditorKit(), OPPLMacroView.this.constraintSystem, new OWLCellRenderer(OPPLMacroView.this.getOWLEditorKit()));
                for (int i = 0; i < actionModel.getSize(); ++i) {
                    Object actionElement = actionModel.getElementAt(i);
                    if (!(actionElement instanceof ActionListItem)) continue;
                    OWLAxiomChange axiomChange = ((ActionListItem)actionElement).getAxiomChange();
                    String isCommaThere = first ? "" : ",";
                    first = false;
                    String action = axiomChange.isAddAxiom() ? " \nADD " : " \nREMOVE ";
                    OWLAxiom axiom = axiomChange.getAxiom();
                    String axiomRendering = cellRenderer.getRendering(axiom);
                    opplString.append(isCommaThere);
                    opplString.append(action);
                    opplString.append(axiomRendering);
                }
                opplString.append("\nEND;");
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(opplString.toString());
                c.setContents(selection, selection);
            }
        });
        this.clearButton = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("clearButton.jpg")));
        this.clearButton.setToolTipText("Clear all");
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OPPLMacroView.this.recordedActions.getDefaultModel().clear();
                OPPLMacroView.this.variableList.getDefaultModel().clear();
            }
        });
        recorderToolBar.setFloatable(false);
        recorderToolBar.add(this.recordButton);
        recorderToolBar.add(this.stopButton);
        recorderToolBar.add(this.copy2ClipboardButton);
        recorderToolBar.add(this.clearButton);
        JSplitPane mainPanel = new JSplitPane();
        mainPanel.setBorder(null);
        JPanel recorderPanel = new JPanel(new BorderLayout());
        recorderPanel.add((Component)recorderToolBar, "North");
        recorderPanel.add((Component)recordedActionBorderPanel, "Center");
        this.entities = new OWLObjectList(this.constraintSystem, this.getOWLEditorKit());
        this.entities.addOPPLMacroListener(this);
        this.entities.setModel(new DefaultListModel());
        this.variableList = new VariableList(this.getOWLEditorKit(), this.constraintSystem);
        this.variableList.setModel(new DefaultListModel());
        this.variableList.getModel().addListDataListener(this.entities);
        JScrollPane entitiesPane = ComponentFactory.createScrollPane((JComponent)((Object)this.entities));
        JPanel entitiesBorderPanel = new JPanel(new BorderLayout());
        entitiesBorderPanel.setBorder(ComponentFactory.createTitledBorder((String)"Named entities: "));
        entitiesBorderPanel.add(entitiesPane);
        JScrollPane variablesPane = ComponentFactory.createScrollPane((JComponent)((Object)this.variableList));
        JPanel variableBorderPanel = new JPanel(new BorderLayout());
        variableBorderPanel.setBorder(ComponentFactory.createTitledBorder((String)"Variables: "));
        variableBorderPanel.add(variablesPane);
        JSplitPane entitiesPanel = new JSplitPane(0);
        entitiesPanel.setBorder(null);
        entitiesPanel.add((Component)entitiesBorderPanel, "top");
        entitiesPanel.add((Component)variableBorderPanel, "bottom");
        mainPanel.add((Component)recorderPanel, "left");
        mainPanel.add((Component)entitiesPanel, "right");
        this.add(mainPanel, "Center");
    }

    protected void disposeOWLView() {
        this.getOWLEditorKit().getModelManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.recordedActions.getModel().removeListDataListener(this);
        this.getOWLModelManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.entities.removeOPPLMacroListener(this);
        this.variableList.getModel().removeListDataListener(this.entities);
    }

    /*
     * WARNING - void declaration
     */
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        DefaultListModel<Object> existingListModel = this.recordedActions.getDefaultModel();
        ActionListModel updatedListModel = new ActionListModel(false);
        updatedListModel.addListDataListener(this);
        this.recordedActions.setModel(updatedListModel);
        if (existingListModel != null) {
            void var5_7;
            int size = existingListModel.getSize();
            boolean bl = false;
            while (var5_7 < size) {
                OWLAxiomChange axiomChange = ((ActionListItem)existingListModel.getElementAt((int)var5_7)).getAxiomChange();
                updatedListModel.addAction(axiomChange, false, true);
                ++var5_7;
            }
        }
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof OWLAxiomChange) || ((OWLAxiomChange)oWLOntologyChange).getAxiom() instanceof OWLDeclarationAxiom || !((OWLAxiomChange)oWLOntologyChange).getAxiom().isLogicalAxiom()) continue;
            updatedListModel.addAction((OWLAxiomChange)oWLOntologyChange, false, true);
        }
        this.revalidate();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.clearButton.setEnabled(this.recordedActions.getModel().getSize() > 0);
        this.refreshEntities();
    }

    private void refreshEntities() {
        this.copy2ClipboardButton.setEnabled(this.recordedActions.getModel().getSize() > 0);
        DefaultListModel<Object> model = this.recordedActions.getDefaultModel();
        int size = model.getSize();
        DefaultListModel<Object> entitiesModel = this.entities.getDefaultModel();
        entitiesModel.clear();
        for (int i = 0; i < size; ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof ActionListItem)) continue;
            ActionListItem actionListItem = (ActionListItem)element;
            OWLAxiomChange axiomChange = actionListItem.getAxiomChange();
            OWLAxiom axiom = axiomChange.getAxiom();
            Set referencedEntities = axiom.getSignature();
            for (OWLEntity entity : referencedEntities) {
                boolean found = this.constraintSystem.isVariableIRI(entity.getIRI());
                for (int j = 0; j < entitiesModel.size() && !found; ++j) {
                    Object object = entitiesModel.get(j);
                    if (!(object instanceof OWLObjectListItem)) continue;
                    OWLObjectListItem item = (OWLObjectListItem)object;
                    found = item.getOwlObject().equals(entity);
                }
                if (found) continue;
                entitiesModel.addElement(new OWLObjectListItem((OWLObject)entity));
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.clearButton.setEnabled(this.recordedActions.getModel().getSize() > 0);
        this.refreshEntities();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.clearButton.setEnabled(this.recordedActions.getModel().getSize() > 0);
        this.refreshEntities();
    }

    @Override
    public void handleGeneralisedOWLObject(Variable<?> variable) {
        VariableListItem variableListItem = new VariableListItem(variable, this.getConstraintSystem(), this.getOWLEditorKit(), true, true);
        variableListItem.addOPPLMacroListener(this);
        this.variableList.getDefaultModel().addElement(variableListItem);
        this.updateActions();
    }

    private void updateActions() {
        List<Variable<?>> variables = this.entities.getVariables();
        ActionListModel model = (ActionListModel)this.recordedActions.getModel();
        int size = model.size();
        OWLObjectAbstractor abstractor = new OWLObjectAbstractor(variables, (ValueComputationParameters)new SimpleValueComputationParameters(this.constraintSystem, BindingNode.createNewEmptyBindingNode(), this.getRuntimeExceptionHandler()));
        for (int i = 0; i < size; ++i) {
            ActionListItem anActionListItem = (ActionListItem)model.remove(i);
            OWLAxiomChange axiomChange = anActionListItem.getAxiomChange();
            OWLAxiom axiom = axiomChange.getAxiom();
            OWLAxiom abstractedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)abstractor);
            AddAxiom newChange = axiomChange.isAddAxiom() ? new AddAxiom(this.getOWLModelManager().getActiveOntology(), abstractedAxiom) : new RemoveAxiom(this.getOWLModelManager().getActiveOntology(), abstractedAxiom);
            model.add(i, new ActionListItem((OWLAxiomChange)newChange, false, true));
        }
    }

    @Override
    public void handleDeletedVariable(Variable<?> variable) {
        Set possibleBindings = this.getConstraintSystem().getVariableBindings(variable, this.getRuntimeExceptionHandler());
        ActionListModel model = (ActionListModel)this.recordedActions.getModel();
        for (int i = model.getSize() - 1; i >= 0; --i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof ActionListItem)) continue;
            model.remove(i);
            ActionListItem item = (ActionListItem)element;
            OWLAxiomChange change = item.getAxiomChange();
            OWLAxiom axiom = change.getAxiom();
            for (OWLObject object : possibleBindings) {
                BindingNode bindingNode = new BindingNode(new Assignment(variable, object));
                PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)new SimpleValueComputationParameters(this.constraintSystem, bindingNode, this.getRuntimeExceptionHandler()));
                OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)instantiator);
                AddAxiom newAxiomChange = change.isAddAxiom() ? new AddAxiom(change.getOntology(), instantiatedAxiom) : new RemoveAxiom(change.getOntology(), instantiatedAxiom);
                ActionListItem newItem = new ActionListItem((OWLAxiomChange)newAxiomChange, false, true);
                model.addElement(newItem);
            }
        }
    }

    @Override
    public void handleGeneralisedOWLObject(Variable<?> variable, OWLObject owlObject) {
        this.updateActions();
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }
}

