/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.protege.ui.OPPLBuilder;
import org.coode.oppl.protege.ui.OPPLTextEditor;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.validation.OPPLScriptValidator;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public final class OPPLEditor
extends JTabbedPane
implements VerifiedInputEditor,
ChangeListener {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private final OWLEditorKit owlEditorKit;
    protected final OPPLBuilder opplBuilder;
    protected final OPPLTextEditor opplTextEditor;
    protected OPPLScript opplScript;
    private final OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            OPPLEditor.this.setSelectedComponent(OPPLEditor.this.opplTextEditor);
        }
    };
    private final OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OPPLEditor.this.setSelectedComponent(OPPLEditor.this.opplTextEditor);
        }
    };

    public OPPLScript getOPPLScript() {
        return this.opplScript;
    }

    public void setOPPLScript(OPPLScript opplScript) {
        this.opplTextEditor.setOPPLScript(opplScript);
        this.setSelectedComponent(this.opplTextEditor);
        this.fireStateChanged();
    }

    public final OWLEditorKit getOwlEditorKit() {
        return this.owlEditorKit;
    }

    public OPPLEditor(OWLEditorKit owlEditor, OPPLBuilder builder, OPPLTextEditor textEditor) {
        this.owlEditorKit = owlEditor;
        this.opplBuilder = builder;
        this.opplTextEditor = textEditor;
        this.opplBuilder.addStatusChangedListener(new org.coode.parsers.ui.InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OPPLEditor.this.opplScript = null;
                if (newState) {
                    OPPLEditor.this.opplScript = OPPLEditor.this.opplBuilder.getOPPLScript();
                }
                OPPLEditor.this.handleChange();
            }
        });
        this.opplTextEditor.addStatusChangedListener(new org.coode.parsers.ui.InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OPPLEditor.this.opplScript = null;
                if (newState) {
                    OPPLEditor.this.opplScript = OPPLEditor.this.opplTextEditor.getOPPLScript();
                }
                OPPLEditor.this.handleChange();
            }
        });
        this.getOwlEditorKit().getOWLModelManager().addListener(this.modelManagerListener);
        this.getOwlEditorKit().getOWLModelManager().getOWLOntologyManager().addOntologyChangeListener(this.ontologyChangeListener);
        this.addChangeListener(this);
        this.initGUI();
    }

    public OPPLEditor(OWLEditorKit owlEditor) {
        this(owlEditor, new OPPLBuilder(owlEditor), new OPPLTextEditor(owlEditor));
    }

    public OPPLEditor(OWLEditorKit owlEditor, OPPLScriptValidator validator) {
        this(owlEditor, new OPPLBuilder(owlEditor, validator), new OPPLTextEditor(owlEditor, validator));
    }

    private void initGUI() {
        this.add(this.opplBuilder);
        this.add(this.opplTextEditor);
    }

    protected void handleChange() {
        boolean newStatus = this.check();
        this.notifyListeners(newStatus);
    }

    private boolean check() {
        return this.getOPPLScript() != null;
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add((InputVerificationStatusChangedListener)ArgCheck.checkNotNull((Object)listener, (String)"listener"));
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(boolean newStatus) {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(newStatus);
        }
    }

    public void clear() {
        this.opplBuilder.clear();
        this.opplTextEditor.clear();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent1) {
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent.equals(this.opplBuilder) && this.opplScript != null) {
            this.opplBuilder.setOPPLScript(this.opplScript);
        } else if (selectedComponent.equals(this.opplTextEditor) && this.opplScript != null) {
            this.opplTextEditor.setOPPLScript(this.opplScript);
        }
    }

    public void dispose() {
        this.opplBuilder.dispose();
        this.opplTextEditor.dispose();
        this.getOwlEditorKit().getOWLModelManager().removeListener(this.modelManagerListener);
        this.getOwlEditorKit().getOWLModelManager().getOWLOntologyManager().removeOntologyChangeListener(this.ontologyChangeListener);
    }
}

