/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.coode.parsers.ui.ExpressionEditor;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;

public class OPPLConstraintEditor
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private final ExpressionEditor<AbstractConstraint> constraintEditor;
    private AbstractConstraint constraint;
    private final OWLEditorKit owlEditorKit;
    private final ConstraintSystem constraintSystem;
    private final OPPLExpressionChecker<AbstractConstraint> constraintExpressionChecker;

    public AbstractConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(AbstractConstraint constraint) {
        this.constraintEditor.setText(constraint.toString());
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.check());
    }

    private boolean check() {
        boolean toReturn = false;
        this.constraint = (AbstractConstraint)this.constraintEditor.createObject();
        toReturn = this.constraint != null;
        return toReturn;
    }

    private void notifyListeners(boolean isValid) {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            listener.verifiedStatusChanged(isValid);
        }
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void handleChange() {
        boolean isValid = this.check();
        this.notifyListeners(isValid);
    }

    public OPPLConstraintEditor(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        KeyListener[] keyListeners;
        this.setLayout(new BorderLayout());
        this.owlEditorKit = owlEditorKit;
        this.constraintSystem = constraintSystem;
        this.constraintExpressionChecker = new OPPLExpressionChecker<AbstractConstraint>(this.getOWLEditorKit()){

            @Override
            protected AbstractConstraint parse(String text) {
                ProtegeParserFactory factory = ProtegeParserFactory.getInstance(this.getOWLEditorKit());
                OPPLParser parser = factory.build(this.getListener());
                OPPLSymbolTable symbolTable = (OPPLSymbolTable)parser.getSymbolTableFactory().createSymbolTable();
                symbolTable.importConstraintSystem(OPPLConstraintEditor.this.getConstraintSystem());
                AbstractConstraint toReturn = parser.parseConstraint(text, symbolTable, OPPLConstraintEditor.this.getConstraintSystem());
                return toReturn;
            }
        };
        this.constraintEditor = new ExpressionEditor(this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager(), this.constraintExpressionChecker);
        JPanel constraintEditorPanel = new JPanel(new BorderLayout());
        constraintEditorPanel.add(ComponentFactory.createScrollPane(this.constraintEditor));
        for (KeyListener keyListener : keyListeners = this.constraintEditor.getKeyListeners()) {
            this.constraintEditor.removeKeyListener(keyListener);
        }
        this.constraintEditor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OPPLConstraintEditor.this.handleChange();
            }
        });
        this.add((Component)constraintEditorPanel, "Center");
    }

    public void dispose() {
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }
}

