/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.coode.oppl.AbstractConstraint;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.ConstraintVisitorEx;
import org.coode.oppl.InCollectionConstraint;
import org.coode.oppl.InequalityConstraint;
import org.coode.oppl.NAFConstraint;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.RegExpConstraint;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.Aggregation;
import org.coode.oppl.function.Constant;
import org.coode.oppl.function.Create;
import org.coode.oppl.function.Expression;
import org.coode.oppl.function.GroupVariableAttribute;
import org.coode.oppl.function.IRIVariableAttribute;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.RenderingVariableAttribute;
import org.coode.oppl.function.ToLowerCaseStringManipulationOPPLFunction;
import org.coode.oppl.function.ToUpperCaseStringManipulationOPPLFunction;
import org.coode.oppl.function.ValuesVariableAtttribute;
import org.coode.oppl.function.inline.InlineSet;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.AbstractVariableEditor;
import org.coode.oppl.protege.ui.ActionList;
import org.coode.oppl.protege.ui.ActionListItem;
import org.coode.oppl.protege.ui.GeneratedVariableEditor;
import org.coode.oppl.protege.ui.GeneratedVariableSectionHeader;
import org.coode.oppl.protege.ui.InputVariableSectionHeader;
import org.coode.oppl.protege.ui.NoDefaultFocusVerifyingOptionPane;
import org.coode.oppl.protege.ui.OPPLConstraintEditor;
import org.coode.oppl.protege.ui.OPPLConstraintListItem;
import org.coode.oppl.protege.ui.OPPLMList;
import org.coode.oppl.protege.ui.OPPLSelectClauseEditor;
import org.coode.oppl.protege.ui.OPPLSelectClauseList;
import org.coode.oppl.protege.ui.OPPLSelectClauseListItem;
import org.coode.oppl.protege.ui.OWLAxiomChangeEditor;
import org.coode.oppl.protege.ui.RegExpVariableEditor;
import org.coode.oppl.protege.ui.VariableEditor;
import org.coode.oppl.protege.ui.VariableList;
import org.coode.oppl.protege.ui.VariableListItem;
import org.coode.oppl.protege.ui.message.Error;
import org.coode.oppl.protege.ui.message.MessageListCellRenderer;
import org.coode.oppl.protege.ui.rendering.VariableOWLCellRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.NamedVariableDetector;
import org.coode.oppl.validation.OPPLScriptValidator;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class OPPLBuilder
extends JSplitPane
implements VerifiedInputEditor,
OWLModelManagerListener {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    protected final OWLEditorKit owlEditorKit;
    private final OPPLVariableList variableList;
    private final OPPLSelectClauseList selectList;
    private final OPPLConstraintList constraintList;
    private final ActionList actionList;
    private OPPLScript opplScript;
    private final OPPLScriptValidator validator;
    private final DefaultListModel<Object> errorListModel = new DefaultListModel();
    private final JList<Object> errorList = new JList<Object>(this.errorListModel);
    private final JPanel errorPanel = new JPanel(new BorderLayout());
    private final OPPLBuilderModel opplBuilderModel;

    protected OPPLBuilder(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, null);
    }

    protected OPPLBuilder(OWLEditorKit owlEditorKit, OPPLScriptValidator validator) {
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.validator = validator;
        this.opplBuilderModel = new OPPLBuilderModel(this.getOWLEditorKit());
        this.setOrientation(0);
        this.setPreferredSize(new Dimension(800, 600));
        JSplitPane builderPane = new JSplitPane(1);
        builderPane.setDividerLocation(0.5);
        this.variableList = new OPPLVariableList(this.owlEditorKit, this.opplBuilderModel);
        builderPane.add((Component)ComponentFactory.createScrollPane((JComponent)((Object)this.variableList)), "left");
        JSplitPane queryActionSplitPane = new JSplitPane(0);
        JSplitPane queryConstraintSplitPane = new JSplitPane(1);
        JPanel queryPanel = new JPanel(new BorderLayout());
        this.selectList = new SpecializedOPPLSelectClauseList(this.owlEditorKit, this.opplBuilderModel.getConstraintSystem(), this.opplBuilderModel);
        queryPanel.add(ComponentFactory.createScrollPane((JComponent)((Object)this.selectList)));
        JPanel constraintPanel = new JPanel(new BorderLayout());
        this.constraintList = new OPPLConstraintList(this.owlEditorKit, this.opplBuilderModel.getConstraintSystem(), this.opplBuilderModel);
        constraintPanel.add(ComponentFactory.createScrollPane((JComponent)((Object)this.constraintList)));
        queryConstraintSplitPane.add((Component)queryPanel, "left");
        queryConstraintSplitPane.add((Component)constraintPanel, "right");
        JPanel actionPanel = new JPanel(new BorderLayout());
        this.actionList = new OPPLActionList(this.owlEditorKit, this.opplBuilderModel);
        actionPanel.add(ComponentFactory.createScrollPane((JComponent)((Object)this.actionList)));
        queryActionSplitPane.add((Component)queryConstraintSplitPane, "top");
        queryActionSplitPane.add((Component)actionPanel, "bottom");
        builderPane.add((Component)queryActionSplitPane, "right");
        queryConstraintSplitPane.setDividerLocation(0.5);
        queryConstraintSplitPane.setResizeWeight(0.3);
        queryActionSplitPane.setDividerLocation(0.5);
        queryActionSplitPane.setResizeWeight(0.3);
        this.setDividerLocation(0.5);
        this.setResizeWeight(0.3);
        this.errorList.setCellRenderer(new MessageListCellRenderer());
        this.errorPanel.add(ComponentFactory.createScrollPane(this.errorList));
        this.errorPanel.setBorder(ComponentFactory.createTitledBorder((String)"Errors:"));
        this.errorPanel.setPreferredSize(new Dimension(100, 500));
        this.add((Component)this.errorPanel, "bottom");
        this.add((Component)builderPane, "top");
        builderPane.setDividerLocation(0.5);
        builderPane.setResizeWeight(0.3);
        this.setDividerLocation(0.3);
        this.setResizeWeight(0.3);
        this.getOWLEditorKit().getModelManager().addListener((OWLModelManagerListener)this);
        this.opplBuilderModel.check();
    }

    protected boolean test(boolean enoughVariables, boolean areThereMinimalElements, OPPLScript builtOPPLScript) {
        boolean validated;
        if (!enoughVariables) {
            this.errorListModel.addElement(new Error("No variables "));
        }
        if (!areThereMinimalElements) {
            this.errorListModel.addElement(new Error("The must be at least either one action, or one query, or one constraint"));
        }
        boolean bl = validated = this.validator == null || this.validator.accept(builtOPPLScript);
        if (!validated) {
            this.errorListModel.addElement(new Error("Failed validation: " + this.validator.getValidationRuleDescription()));
        }
        return validated;
    }

    protected void handleChange() {
        this.opplScript = null;
        this.errorListModel.clear();
        boolean isValid = this.opplBuilderModel.check();
        if (isValid) {
            this.opplScript = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).getOPPLFactory().buildOPPLScript(this.opplBuilderModel.getConstraintSystem(), this.opplBuilderModel.getVariables(), this.opplBuilderModel.getOPPLQuery(), this.opplBuilderModel.getActions());
        }
        this.errorPanel.setVisible(!this.errorListModel.isEmpty());
        if (this.errorPanel.isVisible()) {
            this.setDividerLocation(0.3);
        }
        this.notifyListeners(isValid);
        this.updateGUI();
    }

    private void updateGUI() {
        List<Variable<?>> variables = this.opplBuilderModel.getVariables();
        this.variableList.clear();
        for (Variable<?> variable : variables) {
            this.variableList.placeListItem(new OPPLVariableListItem(variable, this.owlEditorKit, true, true, this.opplBuilderModel));
        }
        this.selectList.clear();
        for (OWLAxiom axiom : this.opplBuilderModel.getAssertedQueryAxioms()) {
            this.selectList.getDefaultModel().addElement(new OPPLSelectClauseListItem(true, axiom));
        }
        for (OWLAxiom axiom : this.opplBuilderModel.getPlainQueryAxioms()) {
            this.selectList.getDefaultModel().addElement(new OPPLSelectClauseListItem(false, axiom));
        }
        this.constraintList.clear();
        List<AbstractConstraint> constraints = this.opplBuilderModel.getConstraints();
        for (AbstractConstraint constraint : constraints) {
            this.constraintList.getDefaultModel().addElement(new OPPLConstraintListItem(this.owlEditorKit, constraint, this.opplBuilderModel.getConstraintSystem()));
        }
        this.actionList.clear();
        List<OWLAxiomChange> actions = this.opplBuilderModel.getActions();
        for (OWLAxiomChange axiomChange : actions) {
            this.actionList.getDefaultModel().addElement(new OPPLActionListItem(axiomChange, true, true, this.getOWLEditorKit(), this.opplBuilderModel));
        }
    }

    private void notifyListeners(boolean status) {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            listener.verifiedStatusChanged(status);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.opplScript != null);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public OPPLScript getOPPLScript() {
        return this.opplScript;
    }

    public void setOPPLScript(OPPLScript opplScript) {
        this.opplBuilderModel.importOPPLScript(opplScript);
    }

    protected void clear() {
        this.opplBuilderModel.reset();
    }

    @Override
    public String getName() {
        return "OPPL Builder";
    }

    public void handleChange(OWLModelManagerChangeEvent event) {
        EventType type = event.getType();
        if (type.equals((Object)EventType.REASONER_CHANGED)) {
            this.opplBuilderModel.getConstraintSystem().setReasoner(this.getOWLEditorKit().getModelManager().getReasoner());
            this.handleChange();
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public void dispose() {
        this.getOWLEditorKit().getModelManager().removeListener((OWLModelManagerListener)this);
    }

    private class OPPLVariableList
    extends VariableList {
        private static final long serialVersionUID = 20100L;
        protected final OPPLBuilderModel model;

        @Override
        protected void handleDelete() {
            Object selectedValue = this.getSelectedValue();
            if (OPPLVariableListItem.class.isAssignableFrom(selectedValue.getClass())) {
                OPPLVariableListItem item = (OPPLVariableListItem)selectedValue;
                this.model.removeVariable(item.getVariable());
            }
        }

        protected void handleAdd() {
            final AbstractVariableEditor variableEditor = this.getSelectedValue() instanceof InputVariableSectionHeader ? new VariableEditor(this.getOWLEditorKit(), this.model.getConstraintSystem()) : new GeneratedVariableEditor(this.getOWLEditorKit(), this.model.getConstraintSystem());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(variableEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            variableEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)this.getOWLEditorKit().getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle(variableEditor.getEditorName());
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo(OPPLBuilder.this);
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        Variable<?> variable = variableEditor.getVariable();
                        OPPLVariableList.this.model.addVariable(variable);
                    }
                    variableEditor.removeStatusChangedListener(verificationListener);
                    variableEditor.dispose();
                }
            });
            dlg.setVisible(true);
        }

        protected OPPLVariableList(OWLEditorKit owlEditorKit, OPPLBuilderModel model) {
            super(owlEditorKit, model.getConstraintSystem());
            this.getDefaultModel().addElement(new InputVariableSectionHeader());
            this.getDefaultModel().addElement(new GeneratedVariableSectionHeader());
            this.model = model;
        }

        protected void clear() {
            this.getDefaultModel().clear();
            this.getDefaultModel().addElement(new InputVariableSectionHeader());
            this.getDefaultModel().addElement(new GeneratedVariableSectionHeader());
        }

        protected void placeListItem(OPPLVariableListItem listItem) {
            int i = -1;
            if (listItem.getVariable() instanceof GeneratedVariable) {
                i = this.getModel().getSize();
            } else {
                Enumeration<Object> elements = this.getDefaultModel().elements();
                boolean found = false;
                while (!found && elements.hasMoreElements()) {
                    ++i;
                    Object element = elements.nextElement();
                    found = element instanceof GeneratedVariableSectionHeader;
                }
                if (!found) {
                    throw new RuntimeException("Section lost");
                }
            }
            this.getDefaultModel().add(i, listItem);
        }
    }

    public class OPPLVariableListItem
    extends VariableListItem {
        protected final OPPLBuilderModel model;

        protected OPPLVariableListItem(Variable<?> variable, OWLEditorKit owlEditorKit, boolean isEditable, boolean isDeleatable, OPPLBuilderModel m) {
            super(variable, m.constraintSystem, owlEditorKit, isEditable, isDeleatable);
            this.model = m;
        }

        @Override
        public String getTooltip() {
            return this.getVariable().toString();
        }

        @Override
        public void handleEdit() {
            final ConstraintSystem cs = this.model.getConstraintSystem();
            final AbstractVariableEditor variableEditor = (AbstractVariableEditor)this.getVariable().accept(new VariableVisitorEx<AbstractVariableEditor<?>>(){

                public <P extends OWLObject> AbstractVariableEditor<?> visit(InputVariable<P> v) {
                    VariableEditor ve = new VariableEditor(OPPLBuilder.this.owlEditorKit, cs);
                    ve.setVariable(v);
                    return ve;
                }

                public <P extends OWLObject> AbstractVariableEditor<?> visit(GeneratedVariable<P> v) {
                    GeneratedVariableEditor generatedVariableEditor = new GeneratedVariableEditor(OPPLBuilder.this.owlEditorKit, cs);
                    generatedVariableEditor.setVariable(v);
                    return generatedVariableEditor;
                }

                public <P extends OWLObject> AbstractVariableEditor<?> visit(RegexpGeneratedVariable<P> regExpGenerated) {
                    RegExpVariableEditor regExpVariableEditor = new RegExpVariableEditor(OPPLBuilder.this.owlEditorKit, cs);
                    regExpVariableEditor.setVariable(regExpGenerated);
                    return regExpVariableEditor;
                }
            });
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(variableEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            variableEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)this.getOwlEditorKit().getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle(variableEditor.getEditorName());
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)this.getOwlEditorKit().getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        Variable<?> newVariable = variableEditor.getVariable();
                        Variable<?> oldVariable = OPPLVariableListItem.this.getVariable();
                        OPPLVariableListItem.this.model.replaceVariable(oldVariable, newVariable);
                    }
                    variableEditor.removeStatusChangedListener(verificationListener);
                    variableEditor.dispose();
                    OPPLBuilder.this.handleChange();
                }
            });
            dlg.setVisible(true);
        }
    }

    private class OPPLActionListItem
    extends ActionListItem {
        final OPPLBuilderModel model;
        private final OWLEditorKit kit;

        protected OPPLActionListItem(OWLAxiomChange axiomChange, boolean isEditable, boolean isDeleteable, OWLEditorKit kit, OPPLBuilderModel m) {
            super(axiomChange, isEditable, isDeleteable);
            this.kit = kit;
            this.model = m;
        }

        @Override
        public void handleEdit() {
            final OWLAxiomChangeEditor actionEditor = new OWLAxiomChangeEditor(this.kit, this.model.getConstraintSystem());
            actionEditor.setOWLAxiomChange(this.getAxiomChange());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(actionEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            actionEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)this.kit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle("Action editor");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)this.kit.getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        OWLAxiomChange action = actionEditor.getOwlAxiomChange();
                        OPPLActionListItem.this.model.removeAction(OPPLActionListItem.this.getAxiomChange());
                        OPPLActionListItem.this.model.addAction(action);
                    }
                    actionEditor.removeStatusChangedListener(verificationListener);
                    actionEditor.dispose();
                }
            });
            dlg.setVisible(true);
        }
    }

    private class OPPLActionList
    extends ActionList {
        final OPPLBuilderModel model;
        private static final long serialVersionUID = 20100L;

        public OPPLActionList(OWLEditorKit kit, OPPLBuilderModel m) {
            super(kit, m.getConstraintSystem(), true);
            this.model = m;
        }

        protected void handleAdd() {
            final OWLAxiomChangeEditor actionEditor = new OWLAxiomChangeEditor(OPPLBuilder.this.getOWLEditorKit(), this.model.getConstraintSystem());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(actionEditor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            actionEditor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)OPPLBuilder.this.getOWLEditorKit().getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle("Action editor");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)OPPLBuilder.this.getOWLEditorKit().getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        OWLAxiomChange action = actionEditor.getOwlAxiomChange();
                        OPPLActionList.this.model.addAction(action);
                    }
                    actionEditor.removeStatusChangedListener(verificationListener);
                    actionEditor.dispose();
                }
            });
            dlg.setVisible(true);
        }

        @Override
        protected void handleDelete() {
            Object selectedValue = this.getSelectedValue();
            if (OPPLActionListItem.class.isAssignableFrom(selectedValue.getClass())) {
                OPPLActionListItem item = (OPPLActionListItem)selectedValue;
                OWLAxiomChange action = item.getAxiomChange();
                this.model.removeAction(action);
            }
        }

        @Override
        public void setConstraintSystem(ConstraintSystem constraintSystem) {
            this.setCellRenderer(new VariableOWLCellRenderer(OPPLBuilder.this.getOWLEditorKit(), constraintSystem, new OWLCellRenderer(OPPLBuilder.this.getOWLEditorKit())));
        }
    }

    private final class OPPLBuilderModel {
        private final List<OWLAxiomChange> actions = new ArrayList<OWLAxiomChange>();
        private final List<OWLAxiom> assertedQueryAxioms = new ArrayList<OWLAxiom>();
        private final List<OWLAxiom> plainQueryAxioms = new ArrayList<OWLAxiom>();
        private final List<AbstractConstraint> constraints = new ArrayList<AbstractConstraint>();
        protected final ConstraintSystem constraintSystem;
        private final List<Variable<?>> variables = new ArrayList();

        public OPPLBuilderModel(OWLEditorKit owlEditorKit) {
            assert (owlEditorKit != null);
            this.constraintSystem = ProtegeParserFactory.getInstance(OPPLBuilder.this.getOWLEditorKit()).getOPPLFactory().createConstraintSystem();
        }

        protected void removeConstraint(AbstractConstraint constraint) {
            boolean affected = this.constraints.remove(constraint);
            if (affected) {
                this.notifyBuilder();
            }
        }

        protected void addAction(OWLAxiomChange action) {
            boolean modified = this.actions.add(action);
            if (modified) {
                this.notifyBuilder();
            }
        }

        protected void addVariable(Variable<?> v) {
            boolean modified = this.variables.add(v);
            if (modified) {
                this.constraintSystem.importVariable(v);
                this.notifyBuilder();
            }
        }

        protected boolean check() {
            boolean enoughVariables = !this.variables.isEmpty();
            boolean enoughQueries = !this.assertedQueryAxioms.isEmpty() || !this.plainQueryAxioms.isEmpty() || !this.constraints.isEmpty();
            boolean enoughActions = !this.actions.isEmpty();
            boolean areThereMinimalElements = enoughVariables && (enoughQueries || enoughActions);
            OPPLScript builtOPPLScript = ProtegeParserFactory.getInstance(OPPLBuilder.this.getOWLEditorKit()).getOPPLFactory().buildOPPLScript(this.constraintSystem, this.getVariables(), this.getOPPLQuery(), this.getActions());
            boolean validated = OPPLBuilder.this.test(enoughVariables, areThereMinimalElements, builtOPPLScript);
            return areThereMinimalElements && validated;
        }

        protected OPPLQuery getOPPLQuery() {
            OPPLQuery query = ProtegeParserFactory.getInstance(OPPLBuilder.this.getOWLEditorKit()).getOPPLFactory().buildNewQuery(this.getConstraintSystem());
            for (OWLAxiom axiom : this.getAssertedQueryAxioms()) {
                query.addAssertedAxiom(axiom);
            }
            for (OWLAxiom axiom : this.getPlainQueryAxioms()) {
                query.addAxiom(axiom);
            }
            for (AbstractConstraint constraint : this.getConstraints()) {
                query.addConstraint(constraint);
            }
            return query;
        }

        public ConstraintSystem getConstraintSystem() {
            return this.constraintSystem;
        }

        public List<Variable<?>> getVariables() {
            return new ArrayList(this.variables);
        }

        protected void notifyBuilder() {
            OPPLBuilder.this.handleChange();
        }

        private void purgeQuery(Variable<?> v) {
            this.purgeAssertedAxioms(v);
            this.purgePlainAxioms(v);
            this.purgeConstraints(v);
        }

        private void purgeConstraints(Variable<?> v) {
            for (AbstractConstraint constraint : this.getConstraints()) {
                boolean affected = (Boolean)constraint.accept((ConstraintVisitorEx)new SpecializedConstraintVisitor(v));
                if (!affected) continue;
                this.constraints.remove(constraint);
            }
        }

        private void purgePlainAxioms(Variable<?> v) {
            HashSet<OWLAxiom> toRemove = new HashSet<OWLAxiom>();
            for (OWLAxiom axiom : this.plainQueryAxioms) {
                Set axiomVariables = this.getConstraintSystem().getAxiomVariables(axiom);
                if (!axiomVariables.contains(v)) continue;
                toRemove.add(axiom);
            }
            this.plainQueryAxioms.removeAll(toRemove);
        }

        private void purgeAssertedAxioms(Variable<?> v) {
            HashSet<OWLAxiom> toRemove = new HashSet<OWLAxiom>();
            for (OWLAxiom axiom : this.assertedQueryAxioms) {
                Set axiomVariables = this.getConstraintSystem().getAxiomVariables(axiom);
                if (!axiomVariables.contains(v)) continue;
                toRemove.add(axiom);
            }
            this.assertedQueryAxioms.removeAll(toRemove);
        }

        private void purgeActions(Variable<?> v) {
            HashSet<OWLAxiomChange> toRemove = new HashSet<OWLAxiomChange>();
            for (OWLAxiomChange action : this.actions) {
                OWLAxiom axiom = action.getAxiom();
                Set axiomVariables = this.getConstraintSystem().getAxiomVariables(axiom);
                if (!axiomVariables.contains(v)) continue;
                toRemove.add(action);
            }
            this.actions.removeAll(toRemove);
        }

        protected void removeAction(OWLAxiomChange action) {
            boolean modified = this.actions.remove(action);
            if (modified) {
                this.notifyBuilder();
            }
        }

        protected void removeVariable(Variable<?> v) {
            boolean modified = this.variables.remove(v);
            if (modified) {
                this.purgeQuery(v);
                this.purgeActions(v);
                this.constraintSystem.removeVariable(v);
                this.notifyBuilder();
            }
        }

        protected void replaceVariable(Variable<?> oldVariable, Variable<?> newVariable) {
            boolean modified = this.variables.remove(oldVariable);
            if (modified) {
                if (oldVariable.getType() != newVariable.getType()) {
                    this.purgeActions(oldVariable);
                    this.purgeQuery(oldVariable);
                }
                this.variables.add(newVariable);
                this.constraintSystem.removeVariable(oldVariable);
                this.constraintSystem.importVariable(newVariable);
                this.notifyBuilder();
            }
        }

        protected void reset() {
            this.variables.clear();
            this.assertedQueryAxioms.clear();
            this.plainQueryAxioms.clear();
            this.constraints.clear();
            this.actions.clear();
            this.notifyBuilder();
        }

        public List<OWLAxiom> getAssertedQueryAxioms() {
            return new ArrayList<OWLAxiom>(this.assertedQueryAxioms);
        }

        protected void addPlainQueryAxiom(OWLAxiom axiom) {
            boolean modified = this.plainQueryAxioms.add(axiom);
            if (modified) {
                this.notifyBuilder();
            }
        }

        public List<OWLAxiom> getPlainQueryAxioms() {
            return new ArrayList<OWLAxiom>(this.plainQueryAxioms);
        }

        protected void addAddAssertedQueryAxiom(OWLAxiom axiom) {
            boolean modified = this.assertedQueryAxioms.add(axiom);
            if (modified) {
                this.notifyBuilder();
            }
        }

        public List<AbstractConstraint> getConstraints() {
            return new ArrayList<AbstractConstraint>(this.constraints);
        }

        protected void addConstraint(AbstractConstraint constraint) {
            boolean modified = this.constraints.add(constraint);
            if (modified) {
                this.notifyBuilder();
            }
        }

        public List<OWLAxiomChange> getActions() {
            return this.actions;
        }

        protected void importOPPLScript(OPPLScript script) {
            this.reset();
            this.variables.addAll(script.getVariables());
            this.constraintSystem.clearVariables();
            Set variablesToImport = script.getConstraintSystem().getVariables();
            for (Variable variable : variablesToImport) {
                this.constraintSystem.importVariable(variable);
            }
            OPPLQuery query = script.getQuery();
            if (query != null) {
                this.plainQueryAxioms.addAll(query.getAxioms());
                this.assertedQueryAxioms.addAll(query.getAssertedAxioms());
                this.constraints.addAll(query.getConstraints());
            }
            this.actions.addAll(script.getActions());
            this.notifyBuilder();
        }

        protected void removeAssertedAxiom(OWLAxiom axiom) {
            boolean modified = this.assertedQueryAxioms.remove(axiom);
            if (modified) {
                this.notifyBuilder();
            }
        }

        protected void removePlainAxiom(OWLAxiom axiom) {
            boolean modified = this.plainQueryAxioms.remove(axiom);
            if (modified) {
                this.notifyBuilder();
            }
        }

        private final class SpecializedConstraintVisitor
        implements ConstraintVisitorEx<Boolean> {
            protected final Variable<?> v;
            protected final NamedVariableDetector variableDetector;

            SpecializedConstraintVisitor(Variable<?> v) {
                this.v = v;
                this.variableDetector = new NamedVariableDetector(this.v, OPPLBuilderModel.this.getConstraintSystem());
            }

            public Boolean visit(NAFConstraint nafConstraint) {
                return (Boolean)nafConstraint.getAxiom().accept((OWLObjectVisitorEx)this.variableDetector);
            }

            public Boolean visit(InCollectionConstraint<? extends OWLObject> c) {
                boolean toReturn = c.getVariable().equals(this.v);
                if (!toReturn) {
                    Set collection = c.getCollection();
                    Iterator it = collection.iterator();
                    boolean detected = false;
                    while (!detected && it.hasNext()) {
                        OWLObject object = (OWLObject)it.next();
                        detected = (Boolean)object.accept((OWLObjectVisitorEx)this.variableDetector);
                    }
                    toReturn = detected;
                }
                return toReturn;
            }

            public Boolean visit(RegExpConstraint c) {
                boolean toReturn = c.getVariable().equals(this.v);
                if (!toReturn) {
                    c.getExpression().accept((OPPLFunctionVisitorEx)new OPPLFunctionVisitorEx<Boolean>(){

                        public <O, I> Boolean visitAggregation(Aggregation<O, I> aggregation) {
                            Iterator iterator = aggregation.getToAggregate().iterator();
                            boolean found = false;
                            while (!found && iterator.hasNext()) {
                                Aggregandum aggregandum = (Aggregandum)iterator.next();
                                Iterator it = aggregandum.getOPPLFunctions().iterator();
                                while (!found && it.hasNext()) {
                                    OPPLFunction opplFunction = (OPPLFunction)it.next();
                                    found = (Boolean)opplFunction.accept((OPPLFunctionVisitorEx)this);
                                }
                            }
                            return found;
                        }

                        public Boolean visitToLowerCaseStringManipulationOPPLFunction(ToLowerCaseStringManipulationOPPLFunction toLowerCaseStringManipulationOPPLFunction) {
                            return (Boolean)toLowerCaseStringManipulationOPPLFunction.accept((OPPLFunctionVisitorEx)this);
                        }

                        public Boolean visitToUpperCaseStringManipulationOPPLFunction(ToUpperCaseStringManipulationOPPLFunction upperCaseStringManipulationOPPLFunction) {
                            return (Boolean)upperCaseStringManipulationOPPLFunction.accept((OPPLFunctionVisitorEx)this);
                        }

                        public <O extends OWLObject> Boolean visitInlineSet(InlineSet<O> inlineSet) {
                            Iterator iterator = inlineSet.getAggregandums().iterator();
                            boolean found = false;
                            while (!found && iterator.hasNext()) {
                                Aggregandum aggregandum = (Aggregandum)iterator.next();
                                Iterator it = aggregandum.getOPPLFunctions().iterator();
                                while (!found && it.hasNext()) {
                                    OPPLFunction opplFunction = (OPPLFunction)it.next();
                                    found = (Boolean)opplFunction.accept((OPPLFunctionVisitorEx)this);
                                }
                            }
                            return found;
                        }

                        public <O> Boolean visitConstant(Constant<O> constant) {
                            return constant.getValue().equals(SpecializedConstraintVisitor.this.v);
                        }

                        public <P extends OWLObject> Boolean visitGenericOPPLFunction(OPPLFunction<P> opplFunction) {
                            return false;
                        }

                        public <O, I extends OPPLFunction<?>> Boolean visitCreate(Create<I, O> create) {
                            return (Boolean)create.getInput().accept((OPPLFunctionVisitorEx)this);
                        }

                        public <O extends OWLObject> Boolean visitExpression(Expression<O> expression) {
                            return (Boolean)expression.getExpression().accept((OWLObjectVisitorEx)SpecializedConstraintVisitor.this.variableDetector);
                        }

                        public <O extends OWLObject> Boolean visitGroupVariableAttribute(GroupVariableAttribute<O> groupVariableAttribute) {
                            return groupVariableAttribute.getVariable().equals(SpecializedConstraintVisitor.this.v);
                        }

                        public Boolean visitIRIVariableAttribute(IRIVariableAttribute iriVariableAttribute) {
                            return iriVariableAttribute.getVariable().equals(SpecializedConstraintVisitor.this.v);
                        }

                        public Boolean visitRenderingVariableAttribute(RenderingVariableAttribute renderingVariableAttribute) {
                            return renderingVariableAttribute.getVariable().equals(SpecializedConstraintVisitor.this.v);
                        }

                        public <O extends OWLObject> Boolean visitValuesVariableAtttribute(ValuesVariableAtttribute<O> valuesVariableAtttribute) {
                            return valuesVariableAtttribute.getVariable().equals(SpecializedConstraintVisitor.this.v);
                        }
                    });
                }
                return toReturn;
            }

            public Boolean visit(InequalityConstraint c) {
                Boolean accept = (Boolean)c.getExpression().accept((OWLObjectVisitorEx)new NamedVariableDetector(this.v, OPPLBuilderModel.this.getConstraintSystem()));
                return c.getVariable().equals(this.v) || accept != false;
            }
        }
    }

    private final class SpecializedOPPLSelectClauseList
    extends OPPLSelectClauseList {
        private static final long serialVersionUID = 20100L;
        final OPPLBuilderModel model;

        SpecializedOPPLSelectClauseList(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem, OPPLBuilderModel model) {
            super(owlEditorKit, constraintSystem);
            this.model = model;
        }

        protected void handleEdit() {
            if (this.getSelectedValue() instanceof OPPLSelectClauseListItem) {
                final OPPLSelectClauseListItem item = (OPPLSelectClauseListItem)this.getSelectedValue();
                final OPPLSelectClauseEditor editor = new OPPLSelectClauseEditor(this.getOwlEditorKit(), this.getConstraintSystem());
                editor.setSelectListItem(item);
                final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(editor);
                final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                    public void verifiedStatusChanged(boolean verified) {
                        optionPane.setOKEnabled(verified);
                    }
                };
                editor.addStatusChangedListener(verificationListener);
                JDialog dlg = optionPane.createDialog((Component)this.getOwlEditorKit().getWorkspace(), null);
                dlg.setModal(true);
                dlg.setTitle("Clause editor");
                dlg.setResizable(true);
                dlg.pack();
                dlg.setLocationRelativeTo((Component)this.getOwlEditorKit().getWorkspace());
                dlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        Object retVal = optionPane.getValue();
                        if (retVal != null && retVal.equals(0)) {
                            OPPLSelectClauseListItem newItem = editor.getSelectListItem();
                            if (item.isAsserted()) {
                                SpecializedOPPLSelectClauseList.this.model.removeAssertedAxiom(item.getAxiom());
                            } else {
                                SpecializedOPPLSelectClauseList.this.model.removePlainAxiom(item.getAxiom());
                            }
                            if (newItem.isAsserted()) {
                                SpecializedOPPLSelectClauseList.this.model.addAddAssertedQueryAxiom(newItem.getAxiom());
                            } else {
                                SpecializedOPPLSelectClauseList.this.model.addPlainQueryAxiom(newItem.getAxiom());
                            }
                        }
                        editor.removeStatusChangedListener(verificationListener);
                        editor.dispose();
                    }
                });
                dlg.setVisible(true);
            }
        }

        protected void handleDelete() {
            if (this.getSelectedValue() instanceof OPPLSelectClauseListItem) {
                OPPLSelectClauseListItem item = (OPPLSelectClauseListItem)this.getSelectedValue();
                if (item.isAsserted()) {
                    this.model.removeAssertedAxiom(item.getAxiom());
                } else {
                    this.model.removePlainAxiom(item.getAxiom());
                }
            }
        }

        protected void handleAdd() {
            final OPPLSelectClauseEditor editor = new OPPLSelectClauseEditor(this.getOwlEditorKit(), this.getConstraintSystem());
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(editor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            editor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)this.getOwlEditorKit().getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle("Clause editor");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo(OPPLBuilder.this);
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        OPPLSelectClauseListItem selectListItem = editor.getSelectListItem();
                        if (selectListItem.isAsserted()) {
                            SpecializedOPPLSelectClauseList.this.model.addAddAssertedQueryAxiom(selectListItem.getAxiom());
                        } else {
                            SpecializedOPPLSelectClauseList.this.model.addPlainQueryAxiom(selectListItem.getAxiom());
                        }
                    }
                    editor.removeStatusChangedListener(verificationListener);
                    editor.dispose();
                }
            });
            dlg.setVisible(true);
        }
    }

    private class OPPLConstraintList
    extends OPPLMList {
        private static final long serialVersionUID = 20100L;
        private final OWLEditorKit owlKit;
        private final ConstraintSystem constraintSystem;
        final OPPLBuilderModel model;
        private final MListSectionHeader HEADER = new MListSectionHeader(){

            public String getName() {
                return "WHERE";
            }

            public boolean canAdd() {
                return true;
            }
        };

        public OPPLConstraintList(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem, OPPLBuilderModel model) {
            this.owlKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
            this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
            this.model = model;
            this.clear();
        }

        protected void handleEdit() {
            if (this.getSelectedValue() instanceof OPPLConstraintListItem) {
                OPPLConstraintListItem item = (OPPLConstraintListItem)this.getSelectedValue();
                final OPPLConstraintEditor editor = new OPPLConstraintEditor(this.owlKit, this.constraintSystem);
                final AbstractConstraint oldConstraint = item.getConstraint();
                editor.setConstraint(oldConstraint);
                final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(editor);
                final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                    public void verifiedStatusChanged(boolean verified) {
                        optionPane.setOKEnabled(verified);
                    }
                };
                editor.addStatusChangedListener(verificationListener);
                JDialog dlg = optionPane.createDialog((Component)this.owlKit.getWorkspace(), null);
                dlg.setModal(true);
                dlg.setTitle("Constraint editor");
                dlg.setResizable(true);
                dlg.pack();
                dlg.setLocationRelativeTo((Component)this.owlKit.getWorkspace());
                dlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        AbstractConstraint newConstraint;
                        Object retVal = optionPane.getValue();
                        if (retVal != null && retVal.equals(0) && (newConstraint = editor.getConstraint()) != oldConstraint) {
                            OPPLConstraintList.this.model.removeConstraint(oldConstraint);
                            OPPLConstraintList.this.model.addConstraint(newConstraint);
                        }
                        editor.removeStatusChangedListener(verificationListener);
                        editor.dispose();
                    }
                });
                dlg.setVisible(true);
            }
        }

        protected void handleDelete() {
            if (this.getSelectedValue() instanceof OPPLConstraintListItem) {
                OPPLConstraintListItem item = (OPPLConstraintListItem)this.getSelectedValue();
                this.model.removeConstraint(item.getConstraint());
            }
        }

        protected void handleAdd() {
            final OPPLConstraintEditor editor = new OPPLConstraintEditor(this.owlKit, this.constraintSystem);
            final NoDefaultFocusVerifyingOptionPane optionPane = new NoDefaultFocusVerifyingOptionPane(editor);
            final InputVerificationStatusChangedListener verificationListener = new InputVerificationStatusChangedListener(){

                public void verifiedStatusChanged(boolean verified) {
                    optionPane.setOKEnabled(verified);
                }
            };
            editor.addStatusChangedListener(verificationListener);
            JDialog dlg = optionPane.createDialog((Component)this.owlKit.getWorkspace(), null);
            dlg.setModal(true);
            dlg.setTitle("Constraint editor");
            dlg.setResizable(true);
            dlg.pack();
            dlg.setLocationRelativeTo((Component)this.owlKit.getWorkspace());
            dlg.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Object retVal = optionPane.getValue();
                    if (retVal != null && retVal.equals(0)) {
                        AbstractConstraint constraint = editor.getConstraint();
                        OPPLConstraintList.this.model.addConstraint(constraint);
                    }
                    editor.removeStatusChangedListener(verificationListener);
                    editor.dispose();
                }
            });
            dlg.setVisible(true);
        }

        public void clear() {
            this.setModel(new DefaultListModel());
            this.getDefaultModel().clear();
            this.getDefaultModel().addElement(this.HEADER);
        }
    }
}

