/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.protege.ui.ShowMessageRuntimeExceptionHandler;
import org.coode.oppl.utils.ArgCheck;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLObject;

public class InstantiationTableModel
implements TableModel {
    private static final NoOPPLScriptTableModel NO_OPPL_SCRIPT_TABLE_MODEL = new NoOPPLScriptTableModel();
    private final Set<TableModelListener> listeners = new HashSet<TableModelListener>();
    private final List<BindingNode> leaves = new ArrayList<BindingNode>();
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    protected final OPPLScript opplScript;
    private final OWLEditorKit owlEditorKit;

    public InstantiationTableModel(OPPLScript opplScript, OWLEditorKit owlEditorKit) {
        this.opplScript = (OPPLScript)ArgCheck.checkNotNull((Object)opplScript, (String)"opplScript");
        this.owlEditorKit = (OWLEditorKit)ArgCheck.checkNotNull((Object)owlEditorKit, (String)"owlEditorKit");
        this.runtimeExceptionHandler = new ShowMessageRuntimeExceptionHandler((Component)this.getOWLEditorKit().getOWLWorkspace());
        Set scriptLeaves = this.getOPPLScript().getConstraintSystem().getLeaves();
        if (scriptLeaves != null) {
            this.leaves.addAll(scriptLeaves);
            Collections.sort(this.leaves, new LeavesComparator());
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return OWLObject.class;
    }

    @Override
    public int getColumnCount() {
        return this.opplScript.getVariables().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        ArrayList sortedVariables = new ArrayList(this.getOPPLScript().getVariables());
        Collections.sort(sortedVariables, new Comparator<Variable<?>>(){

            @Override
            public int compare(Variable<?> variable, Variable<?> anotherVariable) {
                return variable.getName().compareTo(anotherVariable.getName());
            }
        });
        return ((Variable)sortedVariables.get(columnIndex)).getName();
    }

    @Override
    public int getRowCount() {
        return this.getLeaves().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OWLObject toReturn = null;
        BindingNode leaf = this.getLeaves().get(rowIndex);
        ArrayList sortedVariables = new ArrayList(this.getOPPLScript().getVariables());
        Collections.sort(sortedVariables, new Comparator<Variable<?>>(){

            @Override
            public int compare(Variable<?> variable, Variable<?> anotherVariable) {
                return variable.getName().compareTo(anotherVariable.getName());
            }
        });
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.opplScript.getConstraintSystem(), leaf, this.getRuntimeExceptionHandler());
        Variable variable = (Variable)sortedVariables.get(columnIndex);
        toReturn = leaf.getAssignmentValue(variable, (ValueComputationParameters)parameters);
        return toReturn;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public List<BindingNode> getLeaves() {
        return new ArrayList<BindingNode>(this.leaves);
    }

    public OPPLScript getOPPLScript() {
        return this.opplScript;
    }

    public static TableModel getNoOPPLScriptTableModel() {
        return NO_OPPL_SCRIPT_TABLE_MODEL;
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    private static final class NoOPPLScriptTableModel
    implements TableModel {
        NoOPPLScriptTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "Invalid Script";
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }

    private final class LeavesComparator
    implements Comparator<BindingNode> {
        @Override
        public int compare(BindingNode aBindingNode, BindingNode anotherBindingNode) {
            int toReturn = 0;
            Set assignedVariables = aBindingNode.getAssignedVariables();
            Iterator iterator = assignedVariables.iterator();
            SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(InstantiationTableModel.this.opplScript.getConstraintSystem(), BindingNode.getEmptyBindingNode(), InstantiationTableModel.this.getRuntimeExceptionHandler());
            while (toReturn == 0 && iterator.hasNext()) {
                Variable variable = (Variable)iterator.next();
                OWLObject aValue = aBindingNode.getAssignmentValue(variable, (ValueComputationParameters)parameters);
                OWLObject anotherValue = anotherBindingNode.getAssignmentValue(variable, (ValueComputationParameters)parameters);
                toReturn = InstantiationTableModel.this.getOWLEditorKit().getModelManager().getRendering(aValue).compareTo(InstantiationTableModel.this.getOWLEditorKit().getModelManager().getRendering(anotherValue));
            }
            return toReturn;
        }
    }
}

