/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitor;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.exceptions.InvalidVariableNameException;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.AbstractVariableEditor;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.coode.oppl.variabletypes.VariableTypeName;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.coode.parsers.ui.ExpressionEditor;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;

public class GeneratedVariableEditor
extends AbstractVariableEditor<GeneratedVariable<?>> {
    private static final long serialVersionUID = 20100L;
    private final OWLEditorKit owlEditorKit;
    private final ConstraintSystem constraintSystem;
    protected final Map<JRadioButton, VariableType<?>> jRadioButtonTypeMap = new HashMap();
    private final Map<VariableType<?>, JRadioButton> typeJRadioButonMap = new HashMap();
    private final ExpressionEditor<GeneratedVariable<?>> opplFunctionEditor;
    private final OPPLExpressionChecker<GeneratedVariable<?>> opplFunctionExpressionChecker;

    public GeneratedVariableEditor(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.setLayout(new BorderLayout());
        this.owlEditorKit = owlEditorKit;
        this.constraintSystem = constraintSystem;
        this.opplFunctionExpressionChecker = new OPPLExpressionChecker<GeneratedVariable<?>>(this.getOWLEditorKit()){

            @Override
            protected GeneratedVariable<?> parse(String text) {
                try {
                    String variableName = (String)GeneratedVariableEditor.this.variableNameExpressionEditor.createObject();
                    VariableType<?> selectedValue = GeneratedVariableEditor.this.jRadioButtonTypeMap.get(GeneratedVariableEditor.this.findSelectedButton());
                    if (selectedValue instanceof VariableType) {
                        Variable<?> tempVariable = GeneratedVariableEditor.this.createTempVariable(variableName, selectedValue);
                        OPPLParser parser = ProtegeParserFactory.getInstance(this.getOWLEditorKit()).build(this.getListener());
                        OPPLSymbolTable symbolTable = (OPPLSymbolTable)parser.getSymbolTableFactory().createSymbolTable();
                        symbolTable.importConstraintSystem(GeneratedVariableEditor.this.getConstraintSystem());
                        GeneratedVariable variableDefinition = (GeneratedVariable)parser.parseOPPLFunction(text, tempVariable, symbolTable, GeneratedVariableEditor.this.getConstraintSystem());
                        return variableDefinition;
                    }
                    this.getListener().reportThrowable((Throwable)new IllegalArgumentException("The variable type cannot be undefined"), 0, 0, 0);
                    return null;
                }
                catch (OWLException e) {
                    this.getListener().reportThrowable((Throwable)e, 0, 0, 0);
                    return null;
                }
            }
        };
        this.variableNameExpressionEditor = new org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor(this.getOWLEditorKit(), (OWLExpressionChecker)new OWLExpressionChecker<String>(){
            private String variableName;

            public void check(String text) throws OWLExpressionParserException {
                this.variableName = null;
                if (!text.matches("(\\?)?(\\w)+")) {
                    throw new OWLExpressionParserException((Throwable)new InvalidVariableNameException(text));
                }
                this.variableName = text.startsWith("?") ? text : "?" + text;
            }

            public String createObject(String text) throws OWLExpressionParserException {
                this.check(text);
                return this.variableName;
            }
        });
        JPanel variableNamePanel = new JPanel(new BorderLayout());
        variableNamePanel.setBorder(ComponentFactory.createTitledBorder((String)"Variable name:"));
        this.variableNameExpressionEditor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                if (newState) {
                    GeneratedVariableEditor.this.handleChange();
                }
            }
        });
        variableNamePanel.add((Component)this.variableNameExpressionEditor);
        this.add((Component)variableNamePanel, "North");
        this.variableTypeButtonGroup = new ButtonGroup();
        JPanel variableTypePanel = new JPanel(new GridLayout(0, VariableTypeName.values().length));
        for (VariableTypeName variableTypeName : VariableTypeName.values()) {
            JRadioButton typeRadioButton = new JRadioButton(variableTypeName.name());
            typeRadioButton.addActionListener(new ChangeTypeActionListener());
            this.variableTypeButtonGroup.add(typeRadioButton);
            variableTypePanel.add(typeRadioButton);
            VariableType variableType = VariableTypeFactory.getVariableType((VariableTypeName)variableTypeName);
            this.jRadioButtonTypeMap.put(typeRadioButton, variableType);
            this.typeJRadioButonMap.put(variableType, typeRadioButton);
        }
        this.typeJRadioButonMap.get(VariableTypeFactory.getVariableType((VariableTypeName)VariableTypeName.values()[0])).setSelected(true);
        JPanel scopeBorderPanel = new JPanel(new BorderLayout());
        scopeBorderPanel.setBorder(ComponentFactory.createTitledBorder((String)"Variable Scope"));
        JPanel variableTypeAndScopePanel = new JPanel(new BorderLayout());
        variableTypeAndScopePanel.add((Component)scopeBorderPanel, "North");
        variableTypeAndScopePanel.add((Component)variableTypePanel, "Center");
        variableTypeAndScopePanel.setBorder(ComponentFactory.createTitledBorder((String)"Variable Type"));
        this.add((Component)variableTypeAndScopePanel, "Center");
        this.opplFunctionEditor = new ExpressionEditor(this.getOWLEditorKit().getOWLModelManager().getOWLOntologyManager(), this.opplFunctionExpressionChecker);
        this.opplFunctionEditor.addStatusChangedListener(new org.coode.parsers.ui.InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                GeneratedVariableEditor.this.handleChange();
            }
        });
        JPanel opplFunctionEditorPanel = new JPanel(new BorderLayout());
        opplFunctionEditorPanel.setBorder(ComponentFactory.createTitledBorder((String)"OPPL Function: "));
        opplFunctionEditorPanel.add(ComponentFactory.createScrollPane(this.opplFunctionEditor));
        this.add((Component)opplFunctionEditorPanel, "South");
    }

    protected void handleChange() {
        if (this.check()) {
            try {
                this.variableNameExpressionEditor.createObject();
                if (this.getVariable() != null) {
                    this.constraintSystem.removeVariable(this.getVariable());
                }
                super.setVariable((Variable)this.opplFunctionEditor.createObject());
                if (this.getVariable() != null) {
                    this.constraintSystem.importVariable(this.getVariable());
                }
                this.notifyListeners();
            }
            catch (OWLExpressionParserException e) {
                this.notifyListeners();
                throw new RuntimeException(e);
            }
            catch (OWLException e) {
                this.notifyListeners();
                throw new RuntimeException(e);
            }
        } else {
            this.notifyListeners();
        }
    }

    @Override
    protected boolean check() {
        try {
            this.variableNameExpressionEditor.createObject();
            GeneratedVariable createObject = (GeneratedVariable)this.opplFunctionEditor.createObject();
            return createObject != null;
        }
        catch (OWLExpressionParserException e) {
            return false;
        }
        catch (OWLException e) {
            return false;
        }
    }

    @Override
    public void setVariable(GeneratedVariable<?> v) {
        this.clear();
        this.variableNameExpressionEditor.setText(v.getName());
        this.typeJRadioButonMap.get(v.getType()).setSelected(true);
        this.opplFunctionEditor.setText(v.getOPPLFunction().render(this.getConstraintSystem()));
    }

    @Override
    public void dispose() {
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    protected <O extends OWLObject> Variable<O> createTempVariable(final String name, final VariableType<O> type) {
        return new Variable<O>(){

            public IRI getIRI() {
                return IRI.create((String)("http://www.coode.org/oppl/variablemansyntax#" + this.getName()));
            }

            public VariableType<O> getType() {
                return type;
            }

            public String getName() {
                return name;
            }

            public void accept(VariableVisitor visitor) {
            }

            public <T> T accept(VariableVisitorEx<T> visitor) {
                return null;
            }

            public String render(ConstraintSystem cs) {
                return String.format("%s:%s", this.getName(), this.getType());
            }
        };
    }

    @Override
    public String getEditorName() {
        return "Generated Variable";
    }

    private class ChangeTypeActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            GeneratedVariableEditor.this.handleChange();
        }
    }
}

