/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLParser;
import org.coode.oppl.protege.ProtegeParserFactory;
import org.coode.oppl.protege.ui.OPPLExpressionChecker;
import org.coode.oppl.protege.ui.rendering.VariableOWLCellRenderer;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.coode.parsers.ui.ExpressionChecker;
import org.coode.parsers.ui.ExpressionEditor;
import org.coode.parsers.ui.InputVerificationStatusChangedListener;
import org.coode.parsers.ui.VerifiedInputEditor;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;

public class AxiomEditor
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = 20100L;
    private final Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private final ExpressionEditor<OWLAxiom> editor;
    private final OWLEditorKit owlEditorKit;
    private final ConstraintSystem constraintSystem;
    private OWLAxiom axiom = null;
    private final ExpressionChecker<OWLAxiom> expressionChecker;

    protected AxiomEditor(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem) {
        this.owlEditorKit = owlEditorKit;
        this.constraintSystem = constraintSystem;
        this.expressionChecker = new OPPLExpressionChecker<OWLAxiom>(this.owlEditorKit){

            @Override
            protected OWLAxiom parse(String text) {
                ProtegeParserFactory factory = ProtegeParserFactory.getInstance(this.getOWLEditorKit());
                OPPLParser parser = factory.build(this.getListener());
                OPPLSymbolTable symbolTable = (OPPLSymbolTable)parser.getSymbolTableFactory().createSymbolTable();
                symbolTable.importConstraintSystem(AxiomEditor.this.getConstraintSystem());
                OWLAxiom toReturn = parser.parseAxiom(text, symbolTable);
                return toReturn;
            }
        };
        this.setLayout(new BorderLayout());
        this.editor = new ExpressionEditor(this.owlEditorKit.getOWLModelManager().getOWLOntologyManager(), this.expressionChecker);
        for (KeyListener l : this.editor.getKeyListeners()) {
            this.editor.removeKeyListener(l);
        }
        this.editor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                AxiomEditor.this.check();
                AxiomEditor.this.notifyListeners(newState);
            }
        });
        JPanel editorPanel = new JPanel(new BorderLayout());
        editorPanel.setBorder(ComponentFactory.createTitledBorder((String)"Axiom body:"));
        this.editor.setPreferredSize(new Dimension(50, 100));
        editorPanel.add(ComponentFactory.createScrollPane(this.editor));
        this.add((Component)editorPanel, "Center");
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        listener.verifiedStatusChanged(this.check());
        this.listeners.add(listener);
    }

    protected boolean check() {
        this.axiom = (OWLAxiom)this.editor.createObject();
        return this.axiom != null;
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(boolean newStatus) {
        for (InputVerificationStatusChangedListener listener : this.listeners) {
            listener.verifiedStatusChanged(newStatus);
        }
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    protected void clear() {
        this.editor.setText("");
    }

    public void setOWLAxiom(OWLAxiom anOWLAxiom) {
        VariableOWLCellRenderer renderer = new VariableOWLCellRenderer(this.owlEditorKit, this.constraintSystem, new OWLCellRenderer(this.owlEditorKit));
        this.editor.setText(renderer.getRendering(anOWLAxiom));
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }
}

