/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.protege.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.border.Border;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.protege.ui.ActionListItem;
import org.coode.oppl.protege.ui.ActionListModel;
import org.coode.oppl.protege.ui.OPPLMList;
import org.coode.oppl.protege.ui.rendering.VariableOWLCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.semanticweb.owlapi.model.OWLAxiomChange;

public class ActionList
extends OPPLMList {
    private static final long serialVersionUID = 20100L;
    private final OWLEditorKit owlEditorKit;
    private final boolean canAdd;

    public ActionList(OWLEditorKit owlEditorKit, ConstraintSystem constraintSystem, boolean canAdd) {
        this.owlEditorKit = owlEditorKit;
        this.setModel(new ActionListModel(canAdd));
        this.canAdd = canAdd;
        VariableOWLCellRenderer variableAxiomRenderer = new VariableOWLCellRenderer(owlEditorKit, constraintSystem, new OWLCellRenderer(owlEditorKit));
        this.setCellRenderer(variableAxiomRenderer);
    }

    protected void handleDelete() {
        super.handleDelete();
        Object selectedValue = this.getSelectedValue();
        ((ActionListModel)this.getModel()).removeElement(selectedValue);
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Border border = super.createListItemBorder(list, value, index, isSelected, cellHasFocus);
        return BorderFactory.createCompoundBorder(border, new ActionBorder(((ActionListItem)value).getAxiomChange()));
    }

    public void setConstraintSystem(ConstraintSystem constraintSystem) {
        this.setCellRenderer(new VariableOWLCellRenderer(this.owlEditorKit, constraintSystem, new OWLCellRenderer(this.owlEditorKit)));
    }

    public void clear() {
        this.setModel(new ActionListModel(this.canAdd));
    }

    private static class ActionBorder
    implements Border {
        private static final String REMOVE = "Remove";
        private static final String ADD = "Add";
        private final OWLAxiomChange axiomChange;

        ActionBorder(OWLAxiomChange axiomChange) {
            this.axiomChange = axiomChange;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, c.getFontMetrics((Font)c.getFont()).getStringBounds((String)REMOVE, (Graphics)c.getGraphics()).getBounds().width + 8, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        protected String getString() {
            return this.axiomChange.isAddAxiom() ? ADD : REMOVE;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(Color.DARK_GRAY);
            g.drawString(this.getString(), x + 4, y + 2 + g.getFontMetrics().getAscent() + g.getFontMetrics().getLeading());
            g.setColor(oldColor);
        }
    }
}

