/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.locality;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.bindingtree.BindingVisitor;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.locality.LocalityCheckerLeafBrusher;
import org.coode.patterns.locality.LocalityEvaluator;
import org.coode.patterns.locality.SemanticLocalityEvaluator;
import org.coode.patterns.locality.SigmaPlusSigmaMinus;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class LocalityChecker {
    private InstantiatedPatternModel instantiatedPatternModel;
    private final Set<OWLEntity> entities = new HashSet<OWLEntity>();
    private LocalityEvaluator evaluator;
    private final OWLOntologyManager myManager;
    protected final OWLOntology scratchpad;
    private LocalityCheckerLeafBrusher leafBrusher;
    private final VariableTypeVisitorEx<OWLEntity> plusBuilder;
    private final VariableTypeVisitorEx<OWLEntity> minusBuilder;
    private Map<Variable<?>, SigmaPlusSigmaMinus> sigmaValues;
    private OWLOntologyManager externalManager;
    private final RuntimeExceptionHandler handler;

    public LocalityChecker(OWLOntologyManager manager, OWLReasoner r, Collection<? extends OWLEntity> entities, RuntimeExceptionHandler handler) {
        this.externalManager = manager;
        this.handler = handler;
        this.myManager = OWLManager.createOWLOntologyManager();
        this.myManager.addIRIMapper(new OWLOntologyIRIMapper(){

            public IRI getDocumentIRI(IRI ontologyIRI) {
                return ontologyIRI;
            }
        });
        try {
            this.scratchpad = this.myManager.createOntology(Collections.emptySet());
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException("Unexpected exception type", e);
        }
        catch (OWLOntologyChangeException e) {
            throw new RuntimeException("Unexpected exception type", e);
        }
        this.evaluator = new SemanticLocalityEvaluator(this.externalManager, r);
        this.entities.addAll(entities);
        this.plusBuilder = new SigmaBuilder(this.myManager);
        this.minusBuilder = new SigmaBuilder(this.myManager){

            @Override
            IRI create() {
                return IRI.create((String)("urn:sigmaminus:a" + UUID.randomUUID().toString()));
            }
        };
    }

    public void setSignature(Collection<? extends OWLEntity> owlentities) {
        this.entities.clear();
        this.entities.addAll(owlentities);
    }

    public void setInstantiatedPatternModel(InstantiatedPatternModel m) {
        this.instantiatedPatternModel = m;
    }

    public boolean isLocal() {
        this.sigmaValues = this.buildMinimalBindingNodes();
        BindingNode rootBindingNode = new BindingNode(this.sigmaValues.keySet());
        this.leafBrusher = new LocalityCheckerLeafBrusher(this.getEvaluator(), this.getInstantiatedPatternModel().getConstraintSystem(), this.getInstantiatedPatternModel().getInstantiatedPattern(), this.sigmaValues, this.entities, this.getHandler());
        rootBindingNode.accept((BindingVisitor)this.leafBrusher);
        boolean local = this.leafBrusher.isLocal();
        return local;
    }

    public Map<Variable<?>, Collection<OWLObject>> extractAllPossibleBindingNodes(OWLOntology o, Set<OWLEntity> signature) {
        HashMap toReturn = new HashMap();
        List<InputVariable<?>> inputVariables = this.instantiatedPatternModel.getInputVariables();
        for (InputVariable<?> v : inputVariables) {
            HashSet<OWLObject> values = new HashSet<OWLObject>();
            toReturn.put((Variable<?>)v, (Collection<OWLObject>)values);
            if (this.instantiatedPatternModel.getInstantiations((Variable<?>)v).size() != 0) continue;
            Set referencedValues = v.getType().getReferencedOWLObjects(Arrays.asList(o));
            for (OWLObject bind : referencedValues) {
                if (!signature.contains(bind)) continue;
                values.add(bind);
            }
            toReturn.put((Variable<?>)v, (Collection<OWLObject>)values);
        }
        return toReturn;
    }

    public Map<Variable<?>, SigmaPlusSigmaMinus> buildMinimalBindingNodes() {
        HashMap toReturn = new HashMap();
        List<InputVariable<?>> inputVariables = this.instantiatedPatternModel.getInputVariables();
        for (Variable variable : inputVariables) {
            SigmaPlusSigmaMinus values;
            if (this.instantiatedPatternModel.getInstantiations(variable).size() != 0 || (values = new SigmaPlusSigmaMinus((OWLEntity)variable.getType().accept(this.plusBuilder), (OWLEntity)variable.getType().accept(this.minusBuilder))).getPlus() == null || values.getMinus() == null) continue;
            toReturn.put(variable, values);
        }
        return toReturn;
    }

    public List<OWLAxiom> getNonLocalAxioms() {
        return this.leafBrusher.getNonLocalAxioms();
    }

    public List<BindingNode> getExploredNodes() {
        return this.leafBrusher.getExploredBindings();
    }

    public List<Boolean> getExploredNodesLocality() {
        return this.leafBrusher.getExploredBindingsLocality();
    }

    public static Set<OWLEntity> collectEntities(Set<OWLOntology> ontologies) {
        HashSet<OWLEntity> toReturn = new HashSet<OWLEntity>();
        for (OWLOntology o : ontologies) {
            toReturn.addAll(o.getSignature());
        }
        return toReturn;
    }

    public InstantiatedPatternModel getInstantiatedPatternModel() {
        return this.instantiatedPatternModel;
    }

    public LocalityEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(LocalityEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public Set<OWLEntity> getEntities() {
        return new HashSet<OWLEntity>(this.entities);
    }

    public Map<Variable<?>, SigmaPlusSigmaMinus> getSigmaValues() {
        return Collections.unmodifiableMap(this.sigmaValues);
    }

    public Set<OWLEntity> getSigmaMinus() {
        HashSet<OWLEntity> externalSigmaValues = new HashSet<OWLEntity>();
        for (SigmaPlusSigmaMinus s : this.sigmaValues.values()) {
            externalSigmaValues.add(s.getMinus());
        }
        return externalSigmaValues;
    }

    public Set<OWLEntity> getSigmaPlus() {
        HashSet<OWLEntity> externalSigmaValues = new HashSet<OWLEntity>();
        for (SigmaPlusSigmaMinus s : this.sigmaValues.values()) {
            externalSigmaValues.add(s.getPlus());
        }
        return externalSigmaValues;
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }

    private class SigmaBuilder
    implements VariableTypeVisitorEx<OWLEntity> {
        private final OWLOntologyManager manager;
        private final OWLDataFactory factory;

        SigmaBuilder(OWLOntologyManager manager) {
            this.manager = manager;
            this.factory = manager.getOWLDataFactory();
        }

        IRI create() {
            return IRI.create((String)("urn:sigmaplus:a" + UUID.randomUUID().toString()));
        }

        public OWLAnnotationProperty visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
            OWLAnnotationProperty property = this.factory.getOWLAnnotationProperty(this.create());
            try {
                this.manager.addAxiom(LocalityChecker.this.scratchpad, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)property));
            }
            catch (OWLOntologyChangeException e) {
                throw new RuntimeException("Unexpected condition", e);
            }
            return property;
        }

        public OWLEntity visitINDIVIDUALVariableType(INDIVIDUALVariableType v) {
            OWLNamedIndividual owlIndividual = this.factory.getOWLNamedIndividual(this.create());
            try {
                this.manager.addAxiom(LocalityChecker.this.scratchpad, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)owlIndividual));
            }
            catch (OWLOntologyChangeException e) {
                throw new RuntimeException("Unexpected condition", e);
            }
            return owlIndividual;
        }

        public OWLEntity visitDATAPROPERTYVariableType(DATAPROPERTYVariableType v) {
            OWLDataProperty owlDataProperty = this.factory.getOWLDataProperty(this.create());
            try {
                this.manager.addAxiom(LocalityChecker.this.scratchpad, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)owlDataProperty));
            }
            catch (OWLOntologyChangeException e) {
                throw new RuntimeException("Unexpected condition", e);
            }
            return owlDataProperty;
        }

        public OWLEntity visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType v) {
            OWLObjectProperty owlObjectProperty = this.factory.getOWLObjectProperty(this.create());
            try {
                this.manager.addAxiom(LocalityChecker.this.scratchpad, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)owlObjectProperty));
            }
            catch (OWLOntologyChangeException e) {
                throw new RuntimeException("Unexpected condition", e);
            }
            return owlObjectProperty;
        }

        public OWLEntity visitCONSTANTVariableType(CONSTANTVariableType v) {
            return null;
        }

        public OWLEntity visitCLASSVariableType(CLASSVariableType v) {
            OWLClass owlClass = this.factory.getOWLClass(this.create());
            try {
                this.manager.addAxiom(LocalityChecker.this.scratchpad, (OWLAxiom)this.factory.getOWLDeclarationAxiom((OWLEntity)owlClass));
            }
            catch (OWLOntologyChangeException e) {
                throw new RuntimeException("Unexpected condition", e);
            }
            return owlClass;
        }
    }
}

