/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.List;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.ParserFactory;
import org.coode.oppl.Variable;
import org.coode.oppl.entity.OWLEntityRenderer;
import org.coode.oppl.entity.OWLEntityRendererImpl;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.rendering.VariableOWLEntityRenderer;
import org.coode.parsers.ErrorListener;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.EmptyActionListException;
import org.coode.patterns.EmptyVariableListException;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternModel;
import org.coode.patterns.UnsuitableOPPLScriptException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class PatternModelFactory
implements AbstractPatternModelFactory {
    private final OWLOntologyManager ontologyManager;
    private final OWLOntology ontology;
    private final OWLReasoner reasoner;

    public PatternModelFactory(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner) {
        this.ontologyManager = ontologyManager;
        this.ontology = ontology;
        this.reasoner = reasoner;
    }

    public PatternModelFactory(OWLOntology ontology, OWLOntologyManager ontologyManager) {
        this(ontology, ontologyManager, null);
    }

    @Override
    public PatternModel createPatternModel(OPPLScript opplScript) throws UnsuitableOPPLScriptException {
        if (opplScript.getActions().isEmpty()) {
            throw new UnsuitableOPPLScriptException(opplScript);
        }
        return new PatternModel(opplScript, this.ontologyManager, this);
    }

    @Override
    public InstantiatedPatternModel createInstantiatedPatternModel(PatternModel patternModel, RuntimeExceptionHandler handler) {
        return new InstantiatedPatternModel(patternModel, handler);
    }

    @Override
    public PatternExtractor getPatternExtractor(ErrorListener errorListener) {
        return new PatternExtractor(this.ontology, this.ontologyManager, errorListener);
    }

    @Override
    public PatternExtractor getPatternExtractor(Set<OWLAnnotation> visitedAnnotations, ErrorListener errorListener) {
        return new PatternExtractor(this.ontology, this.ontologyManager, errorListener, visitedAnnotations);
    }

    @Override
    public PatternConstraintSystem createConstraintSystem() {
        ConstraintSystem delegate = new ConstraintSystem(this.ontology, this.ontologyManager, this.getOPPLFactory());
        delegate.setReasoner(this.getReasoner());
        return new PatternConstraintSystem(delegate, this.ontologyManager, this);
    }

    @Override
    public PatternModel createPatternModel(String name, List<Variable<?>> variables, List<OWLAxiomChange> actions, Variable<?> returnClause, String rendering, ConstraintSystem constraintSystem) throws EmptyVariableListException, EmptyActionListException {
        if (variables.isEmpty()) {
            throw new EmptyVariableListException();
        }
        if (actions.isEmpty()) {
            throw new EmptyActionListException();
        }
        OPPLScript opplScript = this.getOPPLFactory().buildOPPLScript(constraintSystem, variables, null, actions);
        try {
            PatternModel patternModel = this.createPatternModel(opplScript);
            patternModel.setRendering(rendering);
            patternModel.setIRI(IRI.create((String)("http://www.co-ode.org/patterns#" + name)));
            return patternModel;
        }
        catch (UnsuitableOPPLScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public ManchesterSyntaxRenderer getRenderer(final PatternConstraintSystem patternConstraintSystem) {
        return new ManchesterSyntaxRenderer(new ShortFormProvider(){

            public String getShortForm(OWLEntity entity) {
                return PatternModelFactory.this.getOWLEntityRenderer(patternConstraintSystem).render(entity);
            }

            public void dispose() {
            }
        });
    }

    public OWLEntityRenderer getOWLEntityRenderer(ConstraintSystem cs) {
        OWLEntityRendererImpl defaultRenderer = new OWLEntityRendererImpl();
        return new VariableOWLEntityRenderer(cs, (OWLEntityRenderer)defaultRenderer);
    }

    @Override
    public OPPLAbstractFactory getOPPLFactory() {
        ParserFactory parserFactory = new ParserFactory(this.ontologyManager, this.ontology, this.getReasoner());
        return parserFactory.getOPPLFactory();
    }

    public OWLReasoner getReasoner() {
        return this.reasoner;
    }
}

