/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.exceptions.QuickFailRuntimeExceptionHandler;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.common.SystemErrorEcho;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.ClassPatternExecutor;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternOPPLScript;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class PatternManager
implements OWLOntologyChangeListener {
    public static final RuntimeExceptionHandler HANDLER = new QuickFailRuntimeExceptionHandler();
    private static Map<OWLOntologyManager, PatternManager> instances = new HashMap<OWLOntologyManager, PatternManager>();
    private final OWLOntologyManager ontologyManager;
    private final AbstractPatternModelFactory factory;

    PatternManager(OWLOntologyManager ontologyManager, AbstractPatternModelFactory f) {
        this.ontologyManager = ontologyManager;
        this.factory = f;
    }

    public AbstractPatternModelFactory getFactory() {
        return this.factory;
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            OWLAxiomVisitorAdapter visitor;
            if (!oWLOntologyChange.isAxiomChange()) continue;
            OWLOntology ontology = oWLOntologyChange.getOntology();
            OWLAxiomChange axiomChange = (OWLAxiomChange)oWLOntologyChange;
            OWLAxiom axiom = axiomChange.getAxiom();
            if (axiomChange.isAddAxiom()) {
                visitor = new AdditionManager(ontology, this.ontologyManager, this.factory);
                axiom.accept((OWLAxiomVisitor)visitor);
                continue;
            }
            visitor = new DeletionManager(this.ontologyManager, this.factory);
            axiom.accept((OWLAxiomVisitor)visitor);
        }
    }

    public static synchronized PatternManager getInstance(OWLOntologyManager ontologyManager, AbstractPatternModelFactory f) {
        PatternManager patternManager = instances.get(ontologyManager);
        if (patternManager == null) {
            patternManager = new PatternManager(ontologyManager, f);
            instances.put(ontologyManager, patternManager);
        }
        return patternManager;
    }

    public static ErrorListener getDefaultErrorListener() {
        return new SystemErrorEcho();
    }

    static class DeletionManager
    extends OWLAxiomVisitorAdapter
    implements OWLAxiomVisitor {
        private final OWLOntologyManager ontologyManager;
        private final AbstractPatternModelFactory factory;

        public DeletionManager(OWLOntologyManager ontologyManager, AbstractPatternModelFactory f) {
            this.ontologyManager = ontologyManager;
            this.factory = f;
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            PatternExtractor patternExtractor = this.factory.getPatternExtractor(PatternManager.getDefaultErrorListener());
            OWLAnnotation annotation = axiom.getAnnotation();
            PatternOPPLScript patternModel = (PatternOPPLScript)annotation.accept((OWLObjectVisitorEx)patternExtractor);
            OWLAnnotationSubject subject = axiom.getSubject();
            ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
            if (patternModel != null && subject instanceof OWLClass && patternModel instanceof InstantiatedPatternModel) {
                Set ontologies = this.ontologyManager.getOntologies();
                for (OWLOntology ontology : ontologies) {
                    Set axioms = ontology.getAxioms();
                    for (OWLAxiom anOntologyAxiom : axioms) {
                        for (OWLAnnotation axiomAnnotationAxiom : anOntologyAxiom.getAnnotations()) {
                            String value = (String)axiomAnnotationAxiom.getValue().accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<String>(){

                                public String visit(OWLLiteral literal) {
                                    return literal.getLiteral();
                                }
                            });
                            if (value == null) continue;
                            IRI annotationIRI = axiomAnnotationAxiom.getProperty().getIRI();
                            if (!value.equals(patternModel.getIRI().toString()) || !annotationIRI.equals((Object)IRI.create((String)"http://www.co-ode.org/patterns#", (String)"createdBy"))) continue;
                            changes.add(new RemoveAxiom(ontology, anOntologyAxiom));
                        }
                    }
                }
                try {
                    this.ontologyManager.applyChanges(changes);
                }
                catch (OWLOntologyChangeException e) {
                    throw new RuntimeException("Could not store the pattern inside the ontology", e);
                }
            }
        }
    }

    static class AdditionManager
    extends OWLAxiomVisitorAdapter
    implements OWLAxiomVisitor {
        protected final OWLOntologyManager ontologyManager;
        protected final OWLOntology ontology;
        private final AbstractPatternModelFactory factory;

        public AdditionManager(OWLOntology ontology, OWLOntologyManager ontologyManager, AbstractPatternModelFactory f) {
            this.ontologyManager = ontologyManager;
            this.ontology = ontology;
            this.factory = f;
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            PatternExtractor patternExtractor = this.factory.getPatternExtractor(PatternManager.getDefaultErrorListener());
            final OWLAnnotation annotation = axiom.getAnnotation();
            final OPPLScript patternModel = (OPPLScript)annotation.accept((OWLObjectVisitorEx)patternExtractor);
            OWLAnnotationSubject subject = axiom.getSubject();
            if (patternModel != null && subject instanceof OWLClass && patternModel instanceof InstantiatedPatternModel) {
                final PatternModel opplStatement = ((InstantiatedPatternModel)patternModel).getInstantiatedPattern();
                subject.accept((OWLObjectVisitor)new OWLObjectVisitorAdapter(){

                    public void visit(OWLClass desc) {
                        ClassPatternExecutor patternExecutor = new ClassPatternExecutor(desc, (InstantiatedPatternModel)patternModel, AdditionManager.this.ontology, AdditionManager.this.ontologyManager, annotation.getProperty().getIRI(), HANDLER);
                        List<OWLAxiomChange> changes = patternExecutor.visit(opplStatement);
                        try {
                            AdditionManager.this.ontologyManager.applyChanges(changes);
                        }
                        catch (OWLOntologyChangeException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
    }
}

