/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.Set;
import org.coode.oppl.Variable;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.ArgumentIndexOutOfBoundsException;
import org.coode.patterns.PatternException;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternReferenceNotFoundException;
import org.coode.patterns.utils.Utils;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class PatternSignature {
    private final String name;
    private final PatternModel pattern;

    public PatternSignature(String name, OWLOntologyManager ontologyManger, AbstractPatternModelFactory factory) throws PatternException {
        this.name = name;
        Set<String> existingPatternNames = Utils.getExistingPatternNames(ontologyManger);
        if (!existingPatternNames.contains(name)) {
            throw new PatternReferenceNotFoundException(name);
        }
        this.pattern = Utils.find(name, ontologyManger, factory);
    }

    public VariableType<?> getIthVariableType(int i) throws PatternException {
        try {
            return this.pattern.getInputVariables().get(i).getType();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArgumentIndexOutOfBoundsException(this.name, i);
        }
    }

    public Variable<?> getIthVariable(int i) throws PatternException {
        try {
            return (Variable)this.pattern.getInputVariables().get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArgumentIndexOutOfBoundsException(this.name, i);
        }
    }

    public int size() {
        return this.pattern.getInputVariables().size();
    }

    public PatternModel getPattern() {
        return this.pattern;
    }
}

