/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.bindingtree.BindingVisitor;
import org.coode.oppl.bindingtree.LeafBrusher;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.Aggregation;
import org.coode.oppl.function.Constant;
import org.coode.oppl.function.Create;
import org.coode.oppl.function.Expression;
import org.coode.oppl.function.GroupVariableAttribute;
import org.coode.oppl.function.IRIVariableAttribute;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitor;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.RenderingVariableAttribute;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ToLowerCaseStringManipulationOPPLFunction;
import org.coode.oppl.function.ToUpperCaseStringManipulationOPPLFunction;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.function.ValuesVariableAtttribute;
import org.coode.oppl.function.inline.InlineSet;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.coode.parsers.ErrorListener;
import org.coode.patterns.IncompatibleArgumentException;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.InvalidNumebrOfArgumentException;
import org.coode.patterns.NonResovableArgumentsException;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternException;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternReferenceNotFoundException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class PatternReference<O extends OWLObject>
implements OPPLFunction<O> {
    private String patternName;
    private final PatternConstraintSystem patternConstraintSystem;
    private boolean resolvable;
    private final Set<String> visited = new HashSet<String>();
    private List<Object>[] arguments;
    private PatternModel extractedPattern;
    protected final ErrorListener errorListener;
    protected final RuntimeExceptionHandler runtimeExceptionHandler = new RuntimeExceptionHandler(){

        public void handlePatternSyntaxExcpetion(PatternSyntaxException e) {
            PatternReference.this.errorListener.reportThrowable((Throwable)e, 0, 0, 0);
        }

        public void handleOWLRuntimeException(OWLRuntimeException e) {
            PatternReference.this.errorListener.reportThrowable((Throwable)e, 0, 0, 0);
        }

        public void handleException(RuntimeException e) {
            PatternReference.this.errorListener.reportThrowable((Throwable)e, 0, 0, 0);
        }
    };

    public PatternReference(String patternName, PatternConstraintSystem constraintSystem, ErrorListener errorListener, List<Object> ... args) throws PatternException {
        this(patternName, constraintSystem, Collections.emptySet(), errorListener, args);
    }

    public PatternReference(String patternName, PatternConstraintSystem constraintSystem, Collection<? extends String> visitedPatterns, ErrorListener errorListener, List<Object> ... args) throws PatternException {
        this.patternName = (String)ArgCheck.checkNotNull((Object)patternName, (String)"patternName");
        this.errorListener = (ErrorListener)ArgCheck.checkNotNull((Object)errorListener, (String)"errorListener");
        this.patternName = patternName;
        this.patternConstraintSystem = (PatternConstraintSystem)((Object)ArgCheck.checkNotNull((Object)((Object)constraintSystem), (String)"constraintSystem"));
        this.visited.addAll((Collection)ArgCheck.checkNotNull(visitedPatterns, (String)"visitedPatterns"));
        this.init(args);
    }

    protected void init(List<Object> ... args) throws PatternException {
        Set ontologies = this.getConstraintSystem().getOntologyManager().getOntologies();
        Iterator ontologyIterator = ontologies.iterator();
        boolean found = false;
        this.extractedPattern = null;
        while (!found && ontologyIterator.hasNext()) {
            OWLOntology anOntology = (OWLOntology)ontologyIterator.next();
            Set ontologyAnnotationAxioms = anOntology.getAnnotations();
            Iterator it = ontologyAnnotationAxioms.iterator();
            while (!found && it.hasNext()) {
                OWLAnnotation annotation = (OWLAnnotation)it.next();
                OWLAnnotationProperty p = annotation.getProperty();
                if (this.hasBeenVisited((OWLEntity)p) || !this.patternName.equals(p.getIRI().getFragment())) continue;
                PatternExtractor patternExtractor = this.patternConstraintSystem.getPatternModelFactory().getPatternExtractor(this.getVisitedAnnotations(), this.getErrorListener());
                this.extractedPattern = (PatternModel)annotation.accept((OWLObjectVisitorEx)patternExtractor);
                found = this.extractedPattern != null;
            }
        }
        if (!found) {
            throw new PatternReferenceNotFoundException(this.patternName);
        }
        this.checkCompatibility(args);
        this.resolvable = this.isResolvable(args);
        this.arguments = args;
    }

    protected List<List<Object>> computeReplacements(List<Object> ... args) {
        ArrayList<List<Object>> replacements = new ArrayList<List<Object>>();
        for (List<Object> iThAssignments : args) {
            ArrayList<Object> iThReplacement = new ArrayList<Object>();
            for (Object iThAssignment : iThAssignments) {
                iThReplacement.add(iThAssignment);
            }
            replacements.add(iThReplacement);
        }
        return replacements;
    }

    protected boolean isResolvable(List<Object> ... args) {
        boolean isResolvable = true;
        for (int i = 0; i < args.length && isResolvable; ++i) {
            List<Object> iThArgumentAssignments = args[i];
            Iterator<Object> it = iThArgumentAssignments.iterator();
            while (it.hasNext() && isResolvable) {
                Object anIthAssignment = it.next();
                isResolvable = anIthAssignment instanceof OWLObject;
            }
        }
        return isResolvable;
    }

    protected void checkCompatibility(List<Object> ... args) throws PatternException, IncompatibleArgumentException, InvalidNumebrOfArgumentException {
        boolean compatible = true;
        List<InputVariable<?>> variables = this.extractedPattern.getInputVariables();
        if (variables.size() == args.length) {
            for (int i = 0; i < args.length; ++i) {
                List<Object> iThArgAssignements = args[i];
                for (Object anIthAssignment : iThArgAssignements) {
                    InputVariable<?> variable = this.getExtractedPattern().getInputVariables().get(i);
                    if (anIthAssignment instanceof Variable) {
                        compatible = ((Variable)anIthAssignment).getType().equals(variable.getType());
                    } else {
                        boolean bl = compatible = anIthAssignment instanceof OWLObject && variable.getType().isCompatibleWith((OWLObject)anIthAssignment) || anIthAssignment instanceof Aggregandum && ((Aggregandum)anIthAssignment).isCompatible(variable.getType());
                    }
                    if (compatible) continue;
                    throw new IncompatibleArgumentException(anIthAssignment, (Variable<?>)variable);
                }
            }
        } else {
            throw new InvalidNumebrOfArgumentException(this.patternName, args.length, variables.size());
        }
    }

    public boolean isResolvable() {
        return this.resolvable;
    }

    public List<OWLObject> getResolution() throws PatternException {
        Map<Variable<?>, Set<OWLObject>> bindings = this.getBindingsMap();
        LeafBrusher leafBrusher = new LeafBrusher(bindings);
        BindingNode root = new BindingNode(bindings.keySet());
        root.accept((BindingVisitor)leafBrusher);
        Set leaves = leafBrusher.getLeaves();
        ArrayList<OWLObject> toReturn = new ArrayList<OWLObject>(leaves.size());
        for (BindingNode bindingNode : leaves) {
            toReturn.add(this.getExtractedPattern().getDefinitorialPortion(Collections.singleton(bindingNode), this.runtimeExceptionHandler));
        }
        return toReturn;
    }

    private Map<Variable<?>, Set<OWLObject>> getBindingsMap() {
        HashMap bindings = new HashMap();
        List<List<Object>> replacements = this.computeReplacements(this.getArguments());
        for (int i = 0; i < replacements.size(); ++i) {
            List<Object> values = replacements.get(i);
            final InputVariable<?> variable = this.getExtractedPattern().getInputVariables().get(i);
            HashSet<Object> set = new HashSet<Object>(values.size());
            bindings.put((Variable<?>)variable, (Set<OWLObject>)set);
            for (Object object : values) {
                if (object instanceof OWLObject) {
                    set.add((OWLObject)object);
                    continue;
                }
                if (object instanceof Variable) {
                    final OWLDataFactory dataFactory = this.getConstraintSystem().getOntologyManager().getOWLDataFactory();
                    final Variable v = (Variable)object;
                    set.add(v.getType().accept((VariableTypeVisitorEx)new VariableTypeVisitorEx<OWLObject>(){

                        public OWLObject visitCLASSVariableType(CLASSVariableType classVariableType) {
                            return dataFactory.getOWLClass(v.getIRI());
                        }

                        public OWLObject visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
                            return dataFactory.getOWLObjectProperty(v.getIRI());
                        }

                        public OWLObject visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
                            return dataFactory.getOWLDataProperty(v.getIRI());
                        }

                        public OWLObject visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
                            return dataFactory.getOWLNamedIndividual(v.getIRI());
                        }

                        public OWLObject visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
                            return dataFactory.getOWLLiteral(v.getIRI().toString());
                        }

                        public OWLObject visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
                            return dataFactory.getOWLAnnotationProperty(v.getIRI());
                        }
                    }));
                    continue;
                }
                if (!(object instanceof Aggregandum)) continue;
                Set opplFunctions = ((Aggregandum)object).getOPPLFunctions();
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters((ConstraintSystem)this.getConstraintSystem(), BindingNode.createNewEmptyBindingNode(), this.runtimeExceptionHandler);
                for (Object o : opplFunctions) {
                    ((OPPLFunction)o).accept(new OPPLFunctionVisitor((ValueComputationParameters)parameters, set){
                        final /* synthetic */ ValueComputationParameters val$parameters;
                        final /* synthetic */ Set val$set;
                        {
                            this.val$parameters = valueComputationParameters;
                            this.val$set = set;
                        }

                        public <P extends OWLObject> void visitValuesVariableAtttribute(ValuesVariableAtttribute<P> valuesVariableAtttribute) {
                            if (variable.getType() == valuesVariableAtttribute.getVariable().getType()) {
                                Collection computedValues = (Collection)valuesVariableAtttribute.compute(this.val$parameters);
                                this.val$set.addAll(computedValues);
                            } else {
                                PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)valuesVariableAtttribute.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                            }
                        }

                        public void visitRenderingVariableAttribute(RenderingVariableAttribute renderingVariableAttribute) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)renderingVariableAttribute.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public void visitIRIVariableAttribute(IRIVariableAttribute iriVariableAttribute) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)iriVariableAttribute.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <P extends OWLObject> void visitGroupVariableAttribute(GroupVariableAttribute<P> groupVariableAttribute) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)groupVariableAttribute.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <P extends OWLObject> void visitGenericOPPLFunction(OPPLFunction<P> opplFunction) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)opplFunction.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <P extends OWLObject> void visitExpression(Expression<P> expression) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)expression.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <P, I extends OPPLFunction<?>> void visitCreate(Create<I, P> create) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)create.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public void visitToLowerCaseStringManipulationOPPLFunction(ToLowerCaseStringManipulationOPPLFunction toLowerCaseStringManipulationOPPLFunction) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)toLowerCaseStringManipulationOPPLFunction.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public void visitToUpperCaseStringManipulationOPPLFunction(ToUpperCaseStringManipulationOPPLFunction upperCaseStringManipulationOPPLFunction) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)upperCaseStringManipulationOPPLFunction.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <P> void visitConstant(Constant<P> constant) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)constant.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <P, I> void visitAggregation(Aggregation<P, I> aggregation) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)aggregation.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }

                        public <K extends OWLObject> void visitInlineSet(InlineSet<K> inlineSet) {
                            PatternReference.this.runtimeExceptionHandler.handleException((RuntimeException)new IncompatibleArgumentException((Object)inlineSet.render((ConstraintSystem)PatternReference.this.getConstraintSystem()), (Variable<?>)variable));
                        }
                    });
                }
            }
        }
        return bindings;
    }

    protected boolean hasBeenVisited(OWLEntity e) {
        boolean found = false;
        if ("http://www.co-ode.org/patterns#".equals(e.getIRI().getNamespace())) {
            found = this.visited.contains(e.getIRI().getFragment());
        }
        return found;
    }

    protected Set<OWLAnnotation> getVisitedAnnotations() {
        HashSet<OWLAnnotation> toReturn = new HashSet<OWLAnnotation>();
        for (String visitedPatternName : this.visited) {
            Iterator it = this.getConstraintSystem().getOntologyManager().getOntologies().iterator();
            boolean found = false;
            while (!found && it.hasNext()) {
                OWLOntology ontology = (OWLOntology)it.next();
                Iterator annotationIterator = ontology.getAnnotations().iterator();
                OWLAnnotation anOntologyAnnotation = null;
                while (!found && annotationIterator.hasNext()) {
                    anOntologyAnnotation = (OWLAnnotation)annotationIterator.next();
                    found = anOntologyAnnotation.getProperty().getIRI().equals((Object)IRI.create((String)("http://www.co-ode.org/patterns#" + visitedPatternName)));
                    if (!found) continue;
                    toReturn.add(anOntologyAnnotation);
                }
            }
        }
        return toReturn;
    }

    public InstantiatedPatternModel getInstantiation(RuntimeExceptionHandler handler) throws PatternException {
        if (this.isResolvable()) {
            InstantiatedPatternModel toReturn = null;
            toReturn = this.getExtractedPattern().getPatternModelFactory().createInstantiatedPatternModel(this.getExtractedPattern(), handler);
            List<List<Object>> replacements = this.computeReplacements(this.arguments);
            int i = 0;
            for (Variable variable : toReturn.getInputVariables()) {
                List<Object> variableReplacements = replacements.get(i);
                for (Object object : variableReplacements) {
                    if (!(object instanceof OWLObject)) continue;
                    toReturn.instantiate(variable, (OWLObject)object);
                }
                ++i;
            }
            return toReturn;
        }
        throw new NonResovableArgumentsException(this.patternName, this.arguments);
    }

    public PatternModel getExtractedPattern() {
        return this.extractedPattern;
    }

    public String toString() {
        return this.render(this.getConstraintSystem());
    }

    public String getPatternName() {
        return this.patternName;
    }

    public List<Object>[] getArguments() {
        return this.arguments;
    }

    public PatternConstraintSystem getConstraintSystem() {
        return this.patternConstraintSystem;
    }

    public PatternConstraintSystem getPatternConstraintSystem() {
        return this.patternConstraintSystem;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public String render(ConstraintSystem constraintSystem) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("$%s(", this.getPatternName()));
        for (List<Object> args : this.getArguments()) {
            String openingBrace = args.size() > 1 ? "{" : "";
            String closingBrace = args.size() > 1 ? "}" : "";
            builder.append(openingBrace);
            Iterator<Object> iterator = args.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof OWLObject) {
                    OWLObject owlObject = (OWLObject)object;
                    ManchesterSyntaxRenderer renderer = this.getConstraintSystem().getOPPLFactory().getManchesterSyntaxRenderer((ConstraintSystem)this.getConstraintSystem());
                    owlObject.accept((OWLObjectVisitor)renderer);
                    builder.append(renderer.toString());
                } else if (object instanceof Variable) {
                    builder.append(((Variable)object).getName());
                } else {
                    builder.append(((Aggregandum)object).render(constraintSystem));
                }
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(closingBrace);
        }
        builder.append(")");
        return builder.toString();
    }

    public String render(ShortFormProvider shortFormProvider) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("$%s(", this.getPatternName()));
        for (List<Object> args : this.getArguments()) {
            String openingBrace = args.size() > 1 ? "{" : "";
            String closingBrace = args.size() > 1 ? "}" : "";
            builder.append(openingBrace);
            Iterator<Object> iterator = args.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof OWLObject) {
                    OWLObject owlObject = (OWLObject)object;
                    ManchesterSyntaxRenderer renderer = new ManchesterSyntaxRenderer(shortFormProvider);
                    owlObject.accept((OWLObjectVisitor)renderer);
                    builder.append(renderer.toString());
                } else if (object instanceof Variable) {
                    builder.append(((Variable)object).getName());
                } else {
                    builder.append(((Aggregandum)object).render(shortFormProvider));
                }
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(closingBrace);
        }
        builder.append(")");
        return builder.toString();
    }

    public O compute(ValueComputationParameters params) {
        try {
            Map<Variable<?>, Set<OWLObject>> bindingsMap = this.getBindingsMap();
            LeafBrusher leafBrusher = new LeafBrusher(bindingsMap);
            BindingNode root = new BindingNode(params.getBindingNode().getAssignments(), bindingsMap.keySet());
            root.accept((BindingVisitor)leafBrusher);
            Set leaves = leafBrusher.getLeaves();
            return (O)this.getExtractedPattern().getDefinitorialPortion(leaves, this.runtimeExceptionHandler);
        }
        catch (PatternException e) {
            params.getRuntimeExceptionHandler().handleException((RuntimeException)e);
            return null;
        }
    }

    public void accept(OPPLFunctionVisitor visitor) {
        visitor.visitGenericOPPLFunction((OPPLFunction)this);
    }

    public <P> P accept(OPPLFunctionVisitorEx<P> visitor) {
        return (P)visitor.visitGenericOPPLFunction((OPPLFunction)this);
    }
}

