/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLAbstractFactory;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableScope;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.OPPLException;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.VariableFactory;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.parsers.ErrorListener;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternException;
import org.coode.patterns.PatternOPPLScript;
import org.coode.patterns.PatternReference;
import org.coode.patterns.PatternReferenceGeneratedVariable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class PatternConstraintSystem
extends ConstraintSystem {
    public static final String THIS_CLASS_VARIABLE_CONSTANT_SYMBOL = "$thisClass";
    private final Map<String, GeneratedVariable<?>> specialVariables = new HashMap();
    private final ConstraintSystem constraintSystem;
    private final Map<String, String> specialVariableRenderings = new HashMap<String, String>();
    private final AbstractPatternModelFactory factory;

    public PatternConstraintSystem(ConstraintSystem cs, OWLOntologyManager ontologyManager, AbstractPatternModelFactory f) {
        super(cs.getOntology(), ontologyManager, f.getOPPLFactory());
        this.setReasoner(cs.getReasoner());
        this.constraintSystem = cs;
        this.factory = f;
    }

    public PatternConstraintSystem(OWLOntology ontology, OWLOntologyManager ontologyManager, OWLReasoner reasoner, AbstractPatternModelFactory f) {
        this(new ConstraintSystem(ontology, ontologyManager, reasoner, f.getOPPLFactory()), ontologyManager, f);
    }

    public <O extends OWLObject> InputVariable<O> createVariable(String name, VariableType<O> type, VariableScope<?> variableScope) throws OPPLException {
        return this.constraintSystem.createVariable(name, type, variableScope);
    }

    public Variable<?> getThisClassVariable() {
        Variable toReturn = VariableFactory.getCLASSVariable((String)THIS_CLASS_VARIABLE_CONSTANT_SYMBOL, null);
        this.importVariable(toReturn);
        return toReturn;
    }

    public Variable<?> getVariable(String name) {
        Variable variable = this.constraintSystem.getVariable(name);
        if (variable == null) {
            Iterator<String> it = this.specialVariables.keySet().iterator();
            boolean found = false;
            GeneratedVariable<?> specialVariable = null;
            while (!found && it.hasNext()) {
                String referenceName = it.next();
                specialVariable = this.specialVariables.get(referenceName);
                found = referenceName.equals(name) || this.specialVariableRenderings.get(specialVariable.getName()) != null && this.specialVariableRenderings.get(specialVariable.getName()).equals(name);
            }
            if (found) {
                variable = specialVariable;
            }
        }
        return variable;
    }

    public Variable<?> getVariable(IRI iri) {
        Variable<?> variable = this.constraintSystem.getVariable(iri);
        if (variable == null) {
            variable = this.getSpecialVariable(iri);
        }
        return variable;
    }

    private Variable<?> getSpecialVariable(IRI iri) {
        boolean found = false;
        Iterator<GeneratedVariable<?>> it = this.specialVariables.values().iterator();
        Variable variable = null;
        while (!found && it.hasNext()) {
            variable = (Variable)it.next();
            found = iri.equals((Object)variable.getIRI());
        }
        return found ? variable : null;
    }

    public boolean isVariableIRI(IRI uri) {
        boolean found = this.constraintSystem.isVariableIRI(uri);
        if (!found) {
            Iterator<GeneratedVariable<?>> it = this.specialVariables.values().iterator();
            while (!found && it.hasNext()) {
                Variable variable = (Variable)it.next();
                found = uri.equals((Object)variable.getIRI());
            }
        }
        return found;
    }

    public String resolvePatternConstants(String s) {
        String toReturn = s;
        for (String specialVariableName : this.specialVariables.keySet()) {
            GeneratedVariable<?> variable = this.specialVariables.get(specialVariableName);
            if (variable == null) continue;
            toReturn = toReturn.replaceAll("\\" + specialVariableName, variable.getName());
        }
        return toReturn;
    }

    public boolean isThisClassVariable(Variable<?> variable) {
        return variable.equals(this.specialVariables.get(THIS_CLASS_VARIABLE_CONSTANT_SYMBOL));
    }

    public Set<Variable<?>> getVariables() {
        Set toReturn = this.constraintSystem.getVariables();
        toReturn.addAll(this.specialVariables.values());
        return toReturn;
    }

    public String resolvePattern(String patternName, Set<String> visitedPatterns, List<PatternOPPLScript> dependencies, ErrorListener errorListener, List<Object> ... args) throws PatternException {
        HashSet<String> visited = new HashSet<String>(visitedPatterns);
        PatternReference patternReference = new PatternReference(patternName, this, visited, errorListener, args);
        dependencies.add(patternReference.getExtractedPattern());
        VariableType variableType = patternReference.getExtractedPattern().getReturnVariable().getType();
        PatternReferenceGeneratedVariable patternReferenceGeneratedVariable = PatternReferenceGeneratedVariable.getPatternReferenceGeneratedVariable(patternReference.toString(), variableType, patternReference);
        this.importVariable((Variable<?>)patternReferenceGeneratedVariable);
        return patternReferenceGeneratedVariable.getName();
    }

    public InstantiatedPatternModel resolvePatternInstantiation(String patternName, Set<String> visitedPatterns, List<PatternOPPLScript> dependencies, final ErrorListener errorListener, List<String> ... args) throws PatternException {
        RuntimeExceptionHandler handler = new RuntimeExceptionHandler(){

            public void handlePatternSyntaxExcpetion(PatternSyntaxException e) {
                errorListener.reportThrowable((Throwable)e, 0, 0, 0);
            }

            public void handleOWLRuntimeException(OWLRuntimeException e) {
                errorListener.reportThrowable((Throwable)e, 0, 0, 0);
            }

            public void handleException(RuntimeException e) {
                errorListener.reportThrowable((Throwable)e, 0, 0, 0);
            }
        };
        PatternReference patternReference = new PatternReference(patternName, this, visitedPatterns, errorListener, args);
        dependencies.add(patternReference.getExtractedPattern());
        return patternReference.getInstantiation(handler);
    }

    public <O extends OWLObject> GeneratedVariable<O> createStringGeneratedVariable(String name, VariableType<O> type, OPPLFunction<String> value) {
        return this.constraintSystem.createStringGeneratedVariable(name, type, value);
    }

    public void removeVariable(Variable<?> variable) {
        this.constraintSystem.removeVariable(variable);
    }

    public GeneratedVariable<OWLClassExpression> createIntersectionGeneratedVariable(String name, VariableType<?> type, Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> operands) {
        return this.constraintSystem.createIntersectionGeneratedVariable(name, type, operands);
    }

    public GeneratedVariable<OWLClassExpression> createUnionGeneratedVariable(String name, VariableType<?> type, Collection<? extends Aggregandum<Collection<? extends OWLClassExpression>>> operands) {
        return this.constraintSystem.createUnionGeneratedVariable(name, type, operands);
    }

    public Set<InputVariable<?>> getInputVariables() {
        return this.constraintSystem.getInputVariables();
    }

    public String render(Variable<?> variable) {
        GeneratedVariable<?> specialVariable = this.specialVariables.get(variable.getName());
        String rendering = null;
        if (specialVariable != null) {
            rendering = this.specialVariableRenderings.get(specialVariable.getName());
        }
        if (rendering == null) {
            rendering = this.constraintSystem.render(variable);
        }
        return rendering;
    }

    public <O extends OWLObject> RegexpGeneratedVariable<? extends O> createRegexpGeneratedVariable(String name, VariableType<O> type, OPPLFunction<Pattern> patternGeneratingOPPLFunction) {
        return this.constraintSystem.createRegexpGeneratedVariable(name, type, patternGeneratingOPPLFunction);
    }

    public void importVariable(Variable<?> v) {
        this.constraintSystem.importVariable(v);
    }

    public void clearVariables() {
        this.constraintSystem.clearVariables();
    }

    public AbstractPatternModelFactory getPatternModelFactory() {
        return this.factory;
    }

    public Set<Variable<?>> getAxiomVariables(OWLAxiom axiom) {
        return this.constraintSystem.getAxiomVariables(axiom);
    }

    public boolean isVariable(OWLObject desc) {
        return this.constraintSystem.isVariable(desc);
    }

    public void addLeaf(BindingNode bindingNode) {
        this.constraintSystem.addLeaf(bindingNode);
    }

    public Set<OWLObject> getVariableBindings(Variable<?> v, RuntimeExceptionHandler runtimeExceptionHandler) {
        return this.constraintSystem.getVariableBindings(v, runtimeExceptionHandler);
    }

    public boolean addLeaf(Variable<?> variable, OWLObject object) {
        return this.constraintSystem.addLeaf(variable, object);
    }

    public Set<BindingNode> getLeaves() {
        return this.constraintSystem.getLeaves();
    }

    public OPPLAbstractFactory getOPPLFactory() {
        return this.constraintSystem.getOPPLFactory();
    }

    public void removeBinding(BindingNode binding) {
        this.constraintSystem.removeBinding(binding);
    }

    public boolean isVariable(OWLLiteral node) {
        return this.constraintSystem.isVariable(node);
    }

    public void setLeaves(Collection<? extends BindingNode> newLeaves) {
        this.constraintSystem.setLeaves(newLeaves);
    }

    public Set<GeneratedVariable<?>> getGeneratedVariables() {
        return this.constraintSystem.getGeneratedVariables();
    }

    public boolean isGenerated(Variable<?> v) {
        return this.constraintSystem.isGenerated(v);
    }

    public void reset() {
        this.constraintSystem.reset();
    }

    public <O extends OWLObject> GeneratedVariable<O> createExpressionGeneratedVariable(String name, O expression) {
        return this.constraintSystem.createExpressionGeneratedVariable(name, expression);
    }
}

