/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.patterns;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.coode.oppl.Variable;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.parsers.Scope;
import org.coode.parsers.oppl.OPPLSymbolTable;
import org.coode.parsers.oppl.OPPLSyntaxTree;
import org.coode.parsers.oppl.VariableTypes;
import org.coode.parsers.oppl.patterns.OPPLPatternScope;
import org.coode.patterns.PatternConstraintSystem;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OPPLPatternsSymbolTable
extends OPPLSymbolTable {
    private final OWLOntologyManager ontologyManager;

    public OPPLPatternsSymbolTable(Scope globalScope, OWLOntologyManager ontologyManager) {
        super(globalScope, ontologyManager.getOWLDataFactory());
        this.ontologyManager = ontologyManager;
    }

    public void resolvePattern(OPPLSyntaxTree reference, String patternName, PatternConstraintSystem constraintSystem, List<Object> ... args) {
        List<List<Object>> arguments = Arrays.asList(args);
        Variable<?> resolvedPatternReference = this.getGlobalScope().resolvePatternReference(reference, patternName, constraintSystem, this.getErrorListener(), arguments.toArray(new List[arguments.size()]));
        if (resolvedPatternReference == null) {
            this.reportIllegalToken((CommonTree)reference, "The pattern reference is invalid");
        } else {
            VariableTypes type = VariableTypes.getVariableType((VariableType)resolvedPatternReference.getType());
            this.define(reference.token, type.getSymbol((OWLDataFactory)this.getDataFactory(), reference.token.getText()));
        }
    }

    public void resolvePattern(OPPLSyntaxTree reference, String patternName, PatternConstraintSystem constraintSystem, Collection<? extends String> visited, List<Object> ... args) {
        List<List<Object>> arguments = Arrays.asList(args);
        Variable<?> resolvedPatternReference = this.getGlobalScope().resolvePatternReference(reference, patternName, constraintSystem, visited, this.getErrorListener(), arguments.toArray(new List[arguments.size()]));
        if (resolvedPatternReference == null) {
            this.reportIllegalToken((CommonTree)reference, "The pattern reference is invalid");
        } else {
            VariableTypes type = VariableTypes.getVariableType((VariableType)resolvedPatternReference.getType());
            this.define(reference.token, type.getSymbol((OWLDataFactory)this.getDataFactory(), reference.token.getText()));
        }
    }

    public OPPLPatternScope getGlobalScope() {
        return new OPPLPatternScope(super.getGlobalScope(), this.getOntologyManager());
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public void resolveThisClass(OPPLSyntaxTree thisClass, PatternConstraintSystem constraintSystem) {
        Variable<?> thisClassVariable = constraintSystem.getThisClassVariable();
        VariableTypes type = VariableTypes.getVariableType((VariableType)thisClassVariable.getType());
        this.define(thisClass.token, type.getSymbol((OWLDataFactory)this.getDataFactory(), thisClass.token.getText()));
    }
}

