/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternManager;
import org.coode.patterns.PatternModel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class Utils {
    public static Set<PatternModel> getExistingPatterns(OWLOntology ontology, AbstractPatternModelFactory factory) {
        HashSet<PatternModel> toReturn = new HashSet<PatternModel>();
        PatternExtractor patternExtractor = factory.getPatternExtractor(PatternManager.getDefaultErrorListener());
        for (OWLAnnotation anOntologyAnnotation : ontology.getAnnotations()) {
            PatternModel statementModel = (PatternModel)anOntologyAnnotation.accept((OWLObjectVisitorEx)patternExtractor);
            if (statementModel == null) continue;
            toReturn.add(statementModel);
        }
        return toReturn;
    }

    public static PatternModel find(String patternName, OWLOntology ontology, AbstractPatternModelFactory factory) {
        Iterator it = ontology.getAnnotations().iterator();
        boolean found = false;
        PatternModel extractedPattern = null;
        while (!found && it.hasNext()) {
            OWLAnnotation annotation = (OWLAnnotation)it.next();
            IRI annotationIRI = annotation.getProperty().getIRI();
            if (!annotationIRI.toString().equals("http://www.co-ode.org/patterns#" + patternName)) continue;
            PatternExtractor patternExtractor = factory.getPatternExtractor(PatternManager.getDefaultErrorListener());
            extractedPattern = (PatternModel)annotation.accept((OWLObjectVisitorEx)patternExtractor);
            found = extractedPattern != null && extractedPattern.getPatternLocalName().equals(patternName);
        }
        return extractedPattern;
    }

    public static PatternModel find(String patternName, OWLOntologyManager ontologyManager, AbstractPatternModelFactory factory) {
        Iterator it = ontologyManager.getOntologies().iterator();
        boolean found = false;
        PatternModel toReturn = null;
        while (!found && it.hasNext()) {
            toReturn = Utils.find(patternName, (OWLOntology)it.next(), factory);
            found = toReturn != null;
        }
        return toReturn;
    }

    public static Set<String> getExistingPatternNames(OWLOntology ontology) {
        HashSet<String> toReturn = new HashSet<String>();
        for (OWLAnnotation annotation : ontology.getAnnotations()) {
            IRI iri = annotation.getProperty().getIRI();
            if (!"http://www.co-ode.org/patterns#".equals(iri.getNamespace())) continue;
            toReturn.add(iri.getFragment());
        }
        return toReturn;
    }

    public static Set<String> getExistingPatternNames(OWLOntologyManager ontologyManager) {
        HashSet<String> toReturn = new HashSet<String>();
        Set ontologies = ontologyManager.getOntologies();
        for (OWLOntology ontology : ontologies) {
            toReturn.addAll(Utils.getExistingPatternNames(ontology));
        }
        return toReturn;
    }

    public static Set<String> getExistingPatternNames(OWLOntologyManager ontologyManager, String prefix) {
        Set<String> toReturn = Utils.getExistingPatternNames(ontologyManager);
        Iterator<String> it = toReturn.iterator();
        while (it.hasNext()) {
            if (it.next().startsWith(prefix)) continue;
            it.remove();
        }
        return toReturn;
    }

    public static boolean isPatternGenerated(Collection<? extends OWLAnnotation> annotationAxioms) {
        boolean isPatternGenerated = false;
        Iterator<? extends OWLAnnotation> it = annotationAxioms.iterator();
        while (!isPatternGenerated && it.hasNext()) {
            OWLAnnotation axiomAnnotationAxiom = it.next();
            IRI iri = axiomAnnotationAxiom.getProperty().getIRI();
            isPatternGenerated = iri.getNamespace().startsWith("http://www.co-ode.org/patterns#");
        }
        return isPatternGenerated;
    }

    public static PatternModel getGeneratingPatternModel(Collection<? extends OWLAnnotation> annotations, OWLOntologyManager manager, AbstractPatternModelFactory factory) {
        PatternModel toReturn = null;
        boolean isPatternGenerated = false;
        String name = null;
        Iterator<? extends OWLAnnotation> it = annotations.iterator();
        while (!isPatternGenerated && it.hasNext()) {
            String fragment;
            OWLAnnotationValue value;
            IRI patternIRI;
            OWLAnnotation annotation = it.next();
            IRI annotationURI = annotation.getProperty().getIRI();
            String uriString = annotationURI.toString();
            isPatternGenerated = uriString.startsWith("http://www.co-ode.org/patterns#");
            if (!isPatternGenerated || (patternIRI = (IRI)(value = annotation.getValue()).accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<IRI>(null){

                public IRI visit(OWLLiteral literal) {
                    return IRI.create((String)literal.getLiteral());
                }
            })) == null || (fragment = patternIRI.getFragment()) == null) continue;
            name = fragment;
        }
        if (name != null) {
            toReturn = Utils.find(name, manager, factory);
        }
        return toReturn;
    }

    public static boolean isPatternGenerated(final String patternName, Collection<? extends OWLAnnotation> annotations) {
        boolean isPatternGenerated = false;
        Iterator<? extends OWLAnnotation> it = annotations.iterator();
        while (!isPatternGenerated && it.hasNext()) {
            OWLAnnotation annotation = it.next();
            isPatternGenerated = annotation.getProperty().getIRI().toString().startsWith("http://www.co-ode.org/patterns#") && (Boolean)annotation.getValue().accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<Boolean>(Boolean.valueOf(false)){

                public Boolean visit(OWLLiteral literal) {
                    return literal.getLiteral().endsWith(patternName + "PatternInstantiation");
                }
            }) != false;
        }
        return isPatternGenerated;
    }

    public static String getGeneratedPatternName(Collection<? extends OWLAnnotation> annotations) {
        boolean isPatternGenerated = false;
        String toReturn = null;
        Iterator<? extends OWLAnnotation> it = annotations.iterator();
        OWLAnnotation annotation = null;
        while (!isPatternGenerated && it.hasNext()) {
            annotation = it.next();
            isPatternGenerated = annotation.getProperty().getIRI().toString().startsWith("http://www.co-ode.org/patterns#");
            if (!isPatternGenerated) continue;
            OWLAnnotationValue value = annotation.getValue();
            IRI patternIRI = (IRI)value.accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<IRI>(null){

                public IRI visit(OWLLiteral literal) {
                    return IRI.create((String)literal.getLiteral());
                }
            });
            toReturn = patternIRI.getFragment();
        }
        return toReturn;
    }
}

