/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.OPPLScriptVisitor;
import org.coode.oppl.OPPLScriptVisitorEx;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.VariableExtractor;
import org.coode.oppl.validation.OPPLScriptValidator;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeFactory;
import org.coode.oppl.variabletypes.VariableTypeVisitorEx;
import org.coode.parsers.ErrorListener;
import org.coode.patterns.AbstractPatternModelFactory;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternException;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternModelChangeListener;
import org.coode.patterns.PatternOPPLScript;
import org.coode.patterns.UnsuitableOPPLScriptException;
import org.coode.patterns.utils.Utils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class PatternModel
implements OPPLScript,
PatternOPPLScript {
    private final List<PatternOPPLScript> dependencies = new ArrayList<PatternOPPLScript>();
    private String rendering = null;
    private IRI iri = null;
    private final OPPLScript opplStatement;
    protected final OWLOntologyManager ontologyManager;
    private boolean valid = true;
    private final Set<PatternModelChangeListener> listeners = new HashSet<PatternModelChangeListener>();
    private Variable<?> returnVariable = null;
    public static final String NAMESPACE = "http://www.co-ode.org/patterns#";
    private final AbstractPatternModelFactory factory;
    private static final OPPLScriptValidator SCRIPT_VALIDATOR = new PatternOPPLScriptValidator();

    public AbstractPatternModelFactory getPatternModelFactory() {
        return this.factory;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.ontologyManager;
    }

    public PatternModel(OPPLScript opplScript, OWLOntologyManager ontologyManager, AbstractPatternModelFactory f) throws UnsuitableOPPLScriptException {
        ArgCheck.checkNotNull((Object)opplScript, (String)"OPPL script");
        if (!PatternModel.getScriptValidator().accept(opplScript)) {
            throw new UnsuitableOPPLScriptException(opplScript, PatternModel.getScriptValidator().getValidationRuleDescription());
        }
        this.opplStatement = opplScript;
        this.ontologyManager = (OWLOntologyManager)ArgCheck.checkNotNull((Object)ontologyManager, (String)"ontologyManager");
        this.factory = f;
    }

    public List<Variable<?>> getVariables() {
        List<Object> toReturn = new ArrayList();
        if (this.opplStatement != null) {
            toReturn = this.opplStatement.getVariables();
        }
        return toReturn;
    }

    public String toString() {
        String r = this.rendering == null ? "" : this.rendering;
        return String.format("%s %s", this.opplStatement, r).trim();
    }

    public String render() {
        Variable<?> v;
        StringBuffer buffer = new StringBuffer(this.getOpplStatement().render());
        buffer.append('\n');
        if (this.getRendering() != null) {
            buffer.append(this.getRendering());
        }
        if ((v = this.getReturnVariable()) != null) {
            buffer.append(";\n RETURN ");
            buffer.append(this.getConstraintSystem().render(v));
        }
        return buffer.toString();
    }

    public String render(ConstraintSystem constraintSystem) {
        return this.render();
    }

    public String render(ShortFormProvider shortFormProvider) {
        String r = this.rendering == null ? "" : this.rendering;
        return String.format("%s %s", this.opplStatement.render(shortFormProvider), r).trim();
    }

    @Override
    public String getRendering() {
        return this.rendering;
    }

    public void setRendering(String rendering) {
        this.rendering = rendering;
        StringTokenizer tokenizer = new StringTokenizer(rendering, " \n\t\r\f");
        boolean foundUndefinedVariable = false;
        while (!foundUndefinedVariable && tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (!nextToken.startsWith("?")) continue;
            boolean found = false;
            Iterator<Variable<?>> it = this.getVariables().iterator();
            while (!found && it.hasNext()) {
                Variable<?> variable = it.next();
                found = variable.getName().equals(nextToken.trim());
            }
            foundUndefinedVariable = !found;
        }
        this.valid = !foundUndefinedVariable;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addChangeListener(PatternModelChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(PatternModelChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public void setIRI(IRI iri) {
        this.iri = iri;
    }

    public OPPLScript getOpplStatement() {
        return this.opplStatement;
    }

    public String getPatternLocalName() {
        String toReturn = null;
        if (this.iri != null) {
            toReturn = this.iri.getFragment();
        }
        return toReturn;
    }

    public PatternConstraintSystem getConstraintSystem() {
        return this.opplStatement == null ? this.factory.createConstraintSystem() : (PatternConstraintSystem)this.opplStatement.getConstraintSystem();
    }

    private boolean hasValuesFor(Collection<? extends Variable<?>> variables, BindingNode bindingNode, ValueComputationParameters parameters) {
        boolean found = false;
        Iterator<Variable<?>> iterator = variables.iterator();
        while (!found && iterator.hasNext()) {
            Variable<?> variable = iterator.next();
            found = bindingNode.getAssignmentValue(variable, parameters) != null;
        }
        return found;
    }

    @Override
    public OWLObject getDefinitorialPortion(Collection<? extends BindingNode> bindingNodes, RuntimeExceptionHandler runtimeExceptionHandler) throws PatternException {
        DefinitorialExtractor extractor = this.createDefinitorialExtractor(this.getReturnVariable());
        this.getConstraintSystem().setLeaves(new HashSet<BindingNode>(bindingNodes));
        for (BindingNode bindingNode : bindingNodes) {
            SimpleValueComputationParameters parameters = new SimpleValueComputationParameters((ConstraintSystem)this.getConstraintSystem(), bindingNode, runtimeExceptionHandler);
            PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)parameters);
            ConstraintSystem newConstraintSystem = this.getConstraintSystem().getOPPLFactory().createConstraintSystem();
            for (Variable v : bindingNode.getAssignedVariables()) {
                newConstraintSystem.importVariable(v);
            }
            VariableExtractor variableExtractor = new VariableExtractor(newConstraintSystem, false);
            for (OWLAxiomChange owlAxiomChange : this.getActions()) {
                OWLObject instantiatedAxiom = (OWLObject)owlAxiomChange.getAxiom().accept((OWLObjectVisitorEx)instantiator);
                Set remainingVariables = variableExtractor.extractVariables(instantiatedAxiom);
                boolean instantiate = !remainingVariables.isEmpty() && this.hasValuesFor(remainingVariables, bindingNode, (ValueComputationParameters)parameters);
                instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)new SimpleValueComputationParameters(newConstraintSystem, bindingNode, runtimeExceptionHandler));
                while (instantiate) {
                    remainingVariables = variableExtractor.extractVariables(instantiatedAxiom = (OWLObject)instantiatedAxiom.accept((OWLObjectVisitorEx)instantiator));
                    instantiate = !remainingVariables.isEmpty() && this.hasValuesFor(remainingVariables, bindingNode, (ValueComputationParameters)parameters);
                }
                instantiatedAxiom.accept((OWLObjectVisitorEx)extractor);
            }
        }
        this.getConstraintSystem().setLeaves(null);
        OWLObject extractedObject = extractor.getExtractedObject();
        return extractedObject;
    }

    private DefinitorialExtractor createDefinitorialExtractor(final Variable<?> variable) {
        final OWLDataFactory dataFactory = this.ontologyManager.getOWLDataFactory();
        OWLObject owlObject = null;
        VariableTypeVisitorEx<OWLObject> visitor = new VariableTypeVisitorEx<OWLObject>(){

            public OWLObject visitINDIVIDUALVariableType(INDIVIDUALVariableType t) {
                throw new RuntimeException("Unsupported variable type: " + variable.getType() + " for pattern used in functional mode");
            }

            public OWLObject visitDATAPROPERTYVariableType(DATAPROPERTYVariableType t) {
                return dataFactory.getOWLDataProperty(variable.getIRI());
            }

            public OWLObject visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType t) {
                return dataFactory.getOWLObjectProperty(variable.getIRI());
            }

            public OWLObject visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
                return dataFactory.getOWLAnnotationProperty(variable.getIRI());
            }

            public OWLObject visitCONSTANTVariableType(CONSTANTVariableType t) {
                throw new RuntimeException("Unsupported variable type: " + variable.getType() + " for pattern used in functional mode");
            }

            public OWLObject visitCLASSVariableType(CLASSVariableType v) {
                return dataFactory.getOWLClass(variable.getIRI());
            }
        };
        owlObject = (OWLObject)variable.getType().accept((VariableTypeVisitorEx)visitor);
        return new DefinitorialExtractor(owlObject, variable.getType(), dataFactory);
    }

    @Override
    public boolean dependsOn(PatternOPPLScript patternModel) {
        boolean toReturn = this.isDependent();
        if (toReturn) {
            toReturn = false;
            Iterator<PatternOPPLScript> it = this.dependencies.iterator();
            while (!toReturn && it.hasNext()) {
                PatternOPPLScript aPatternModel = it.next();
                toReturn = aPatternModel.getName().equals(patternModel.getName()) || aPatternModel.dependsOn(patternModel);
            }
        }
        return toReturn;
    }

    public boolean isDependent() {
        return !this.dependencies.isEmpty();
    }

    public Set<PatternOPPLScript> getDependingPatterns(Set<OWLOntology> ontologies, ErrorListener errorListener) {
        HashSet<PatternOPPLScript> toReturn = new HashSet<PatternOPPLScript>();
        for (OWLOntology ontology : ontologies) {
            Set<PatternModel> existingPatterns = Utils.getExistingPatterns(ontology, this.factory);
            for (PatternModel patternModel : existingPatterns) {
                if (!patternModel.dependsOn(this)) continue;
                toReturn.add(patternModel);
                toReturn.addAll(patternModel.getInstantiations(errorListener));
            }
        }
        toReturn.addAll(this.getInstantiations(errorListener));
        return toReturn;
    }

    public Set<InstantiatedPatternModel> getInstantiations(ErrorListener errorListener) {
        HashSet<InstantiatedPatternModel> toReturn = new HashSet<InstantiatedPatternModel>();
        Set ontologies = this.ontologyManager.getOntologies();
        PatternExtractor patternExtractor = this.factory.getPatternExtractor(errorListener);
        for (OWLOntology ontology : ontologies) {
            Set referencedClasses = ontology.getClassesInSignature();
            for (OWLClass owlClass : referencedClasses) {
                Set annotationAxioms = owlClass.getAnnotationAssertionAxioms(ontology);
                for (OWLAnnotationAssertionAxiom annotationAxiom : annotationAxioms) {
                    OPPLScript extractedPatternModel = (OPPLScript)annotationAxiom.getAnnotation().accept((OWLObjectVisitorEx)patternExtractor);
                    if (extractedPatternModel == null || !(extractedPatternModel instanceof InstantiatedPatternModel) || !((InstantiatedPatternModel)extractedPatternModel).getInstantiatedPatternLocalName().equals(this.getPatternLocalName())) continue;
                    toReturn.add((InstantiatedPatternModel)extractedPatternModel);
                }
            }
        }
        return toReturn;
    }

    @Override
    public Set<OWLObject> getOWLObjects(OWLOntology ontology, ErrorListener errorListener) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        boolean found = false;
        OWLAnnotation ontologyAnnotation = null;
        Iterator annotationIterator = ontology.getAnnotations().iterator();
        while (!found && annotationIterator.hasNext()) {
            ontologyAnnotation = (OWLAnnotation)annotationIterator.next();
            found = this.iri.equals((Object)ontologyAnnotation.getProperty().getIRI());
        }
        if (found) {
            toReturn.add((OWLObject)ontologyAnnotation);
        }
        return toReturn;
    }

    public OWLOntology getOriginatingOntology() {
        OWLOntology toReturn = null;
        Set ontologies = this.ontologyManager.getOntologies();
        boolean found = false;
        Iterator it = ontologies.iterator();
        OWLOntology ontology = null;
        OWLAnnotation ontologyAnnotation = null;
        while (!found && it.hasNext()) {
            ontology = (OWLOntology)it.next();
            Iterator annotationIterator = ontology.getAnnotations().iterator();
            while (!found && annotationIterator.hasNext()) {
                ontologyAnnotation = (OWLAnnotation)annotationIterator.next();
                found = this.iri.equals((Object)ontologyAnnotation.getProperty().getIRI());
            }
        }
        if (found) {
            toReturn = ontology;
        }
        return toReturn;
    }

    public void setReturnVariable(Variable<?> returnVariable) {
        this.returnVariable = returnVariable;
    }

    public Variable<?> getReturnVariable() {
        return this.returnVariable;
    }

    public boolean isFunctional() {
        return this.returnVariable != null;
    }

    @Override
    public boolean isClassPattern() {
        ClassPatternDetector classPatternDetector = new ClassPatternDetector();
        return this.accept(classPatternDetector);
    }

    @Override
    public String getName() {
        return this.getPatternLocalName();
    }

    @Override
    public void addDependency(PatternOPPLScript dependency) {
        this.dependencies.add(dependency);
    }

    public List<InputVariable<?>> getInputVariables() {
        return this.getOpplStatement().getInputVariables();
    }

    @Override
    public boolean hasScopedVariables() {
        List<Variable<?>> variables = this.getVariables();
        Iterator<Variable<?>> it = variables.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            Variable<?> v = it.next();
            found = (Boolean)v.accept((VariableVisitorEx)new VariableVisitorEx<Boolean>(){

                public <P extends OWLObject> Boolean visit(GeneratedVariable<P> gv) {
                    return Boolean.FALSE;
                }

                public <P extends OWLObject> Boolean visit(InputVariable<P> iv) {
                    return iv.getVariableScope() != null;
                }

                public <P extends OWLObject> Boolean visit(RegexpGeneratedVariable<P> regExpGenerated) {
                    return Boolean.FALSE;
                }
            });
        }
        return found;
    }

    public void accept(OPPLScriptVisitor visitor) {
        this.getOpplStatement().accept(visitor);
    }

    public <P> P accept(OPPLScriptVisitorEx<P> visitor) {
        return (P)this.getOpplStatement().accept(visitor);
    }

    public List<OWLAxiomChange> getActions() {
        return this.getOpplStatement().getActions();
    }

    public OPPLQuery getQuery() {
        return this.getOpplStatement().getQuery();
    }

    @Deprecated
    public void addVariable(Variable<?> variable) {
        if (this.opplStatement != null) {
            this.opplStatement.addVariable(variable);
        }
    }

    public static final OPPLScriptValidator getScriptValidator() {
        return SCRIPT_VALIDATOR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.opplStatement == null ? 0 : this.opplStatement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternModel other = (PatternModel)obj;
        return !(this.opplStatement == null ? other.opplStatement != null : !this.opplStatement.equals(other.opplStatement));
    }

    static class ReplacementExtractor {
        ReplacementExtractor() {
        }

        public static List<List<Object>> permutations(List<List<Object>> elements) {
            return ReplacementExtractor.permutations(new ArrayList<Object>(), elements);
        }

        private static List<List<Object>> permutations(List<Object> path, List<List<Object>> elements) {
            ArrayList<List<Object>> toReturn = new ArrayList<List<Object>>();
            if (!elements.isEmpty()) {
                List<Object> elem = elements.iterator().next();
                elements.remove(elem);
                for (Object string : elem) {
                    ArrayList<Object> newPath = new ArrayList<Object>(path);
                    newPath.add(string);
                    toReturn.addAll(ReplacementExtractor.permutations(newPath, elements));
                }
            } else {
                return new ArrayList<List<Object>>(Collections.singleton(new ArrayList<Object>(path)));
            }
            return toReturn;
        }
    }

    static class DefinitorialExtractor
    extends OWLObjectVisitorExAdapter<OWLObject>
    implements OWLAxiomVisitorEx<OWLObject>,
    OPPLScriptVisitorEx<OWLClassExpression> {
        protected final Set<OWLClassExpression> extractedDescriptions = new HashSet<OWLClassExpression>();
        protected OWLPropertyExpression<?, ?> extractedProperty = null;
        protected OWLObject owlObject;
        protected OWLDataFactory dataFactory;
        private final VariableType<?> variableType;

        public OWLObject getExtractedObject() {
            OWLObject toReturn = null;
            toReturn = (OWLObject)this.variableType.accept((VariableTypeVisitorEx)new VariableTypeVisitorEx<OWLObject>(){

                public OWLObject visitCLASSVariableType(CLASSVariableType classVariableType) {
                    return DefinitorialExtractor.this.dataFactory.getOWLObjectIntersectionOf(DefinitorialExtractor.this.extractedDescriptions);
                }

                public OWLObject visitOBJECTPROPERTYVariableType(OBJECTPROPERTYVariableType objectpropertyVariableType) {
                    return DefinitorialExtractor.this.extractedProperty;
                }

                public OWLObject visitDATAPROPERTYVariableType(DATAPROPERTYVariableType datapropertyVariableType) {
                    return DefinitorialExtractor.this.extractedProperty;
                }

                public OWLObject visitINDIVIDUALVariableType(INDIVIDUALVariableType individualVariableType) {
                    throw new RuntimeException("Unsupported variable type: " + individualVariableType + " for pattern used in functional mode");
                }

                public OWLObject visitCONSTANTVariableType(CONSTANTVariableType constantVariableType) {
                    throw new RuntimeException("Unsupported variable type: " + constantVariableType + " for pattern used in functional mode");
                }

                public OWLObject visitANNOTATIONPROPERTYVariableType(ANNOTATIONPROPERTYVariableType annotationpropertyVariableType) {
                    throw new RuntimeException("Unsupported variable type: " + annotationpropertyVariableType + " for pattern used in functional mode");
                }
            });
            return toReturn;
        }

        public DefinitorialExtractor(OWLObject owlObject, VariableType<?> variableType, OWLDataFactory dataFactory) {
            this.owlObject = owlObject;
            this.dataFactory = dataFactory;
            this.variableType = variableType;
        }

        public OWLClassExpression visit(OWLEquivalentClassesAxiom axiom) {
            OWLClassExpression toReturn = null;
            if (this.variableType == VariableTypeFactory.getCLASSVariableType()) {
                HashSet descriptions = new HashSet(axiom.getClassExpressions());
                descriptions.remove(this.owlObject);
                this.extractedDescriptions.addAll(descriptions);
                toReturn = !descriptions.isEmpty() ? (OWLClassExpression)descriptions.iterator().next() : null;
            }
            return toReturn;
        }

        public OWLObjectPropertyExpression visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            OWLObjectPropertyExpression toReturn = null;
            if (this.variableType == VariableTypeFactory.getOBJECTPROPERTYTypeVariableType()) {
                HashSet properties = new HashSet(axiom.getProperties());
                properties.remove(this.owlObject);
                this.extractedProperty = toReturn = !properties.isEmpty() ? (OWLObjectPropertyExpression)properties.iterator().next() : null;
            }
            return toReturn;
        }

        public OWLDataPropertyExpression visit(OWLEquivalentDataPropertiesAxiom axiom) {
            OWLDataPropertyExpression toReturn = null;
            if (this.variableType == VariableTypeFactory.getDATAPROPERTYVariableType()) {
                HashSet properties = new HashSet(axiom.getProperties());
                properties.remove(this.owlObject);
                this.extractedProperty = toReturn = !properties.isEmpty() ? (OWLDataPropertyExpression)properties.iterator().next() : null;
            }
            return toReturn;
        }

        public OWLClassExpression visitActions(List<OWLAxiomChange> changes) {
            OWLClassExpression toReturn = null;
            for (OWLAxiomChange axiomChange : changes) {
                OWLAxiom axiom = axiomChange.getAxiom();
                OWLObject description = (OWLObject)axiom.accept((OWLObjectVisitorEx)this);
                toReturn = toReturn == null ? (OWLClassExpression)description : this.dataFactory.getOWLObjectIntersectionOf(new OWLClassExpression[]{toReturn, (OWLClassExpression)description});
            }
            return toReturn;
        }

        public OWLClassExpression visit(OPPLQuery q, OWLClassExpression p) {
            return null;
        }

        public OWLClassExpression visit(Variable<?> v, OWLClassExpression p) {
            return null;
        }

        public OWLClassExpression visitActions(List<OWLAxiomChange> changes, OWLClassExpression p) {
            return this.visitActions(changes);
        }
    }

    class ClassPatternDetector
    extends OWLObjectVisitorExAdapter<Boolean>
    implements OWLAxiomVisitorEx<Boolean>,
    OPPLScriptVisitorEx<Boolean> {
        private final OWLClass thisClass;

        ClassPatternDetector() {
            this.thisClass = PatternModel.this.ontologyManager.getOWLDataFactory().getOWLClass(PatternModel.this.getConstraintSystem().getThisClassVariable().getIRI());
        }

        protected Boolean getDefaultReturnValue(OWLObject object) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLSubClassOfAxiom axiom) {
            return axiom.getSubClass().equals(this.thisClass);
        }

        public Boolean visit(OWLDisjointClassesAxiom axiom) {
            return axiom.getClassExpressions().contains(this.thisClass);
        }

        public Boolean visit(OWLEquivalentClassesAxiom axiom) {
            return axiom.getClassExpressions().contains(this.thisClass);
        }

        public Boolean visit(OPPLQuery q) {
            return Boolean.FALSE;
        }

        public Boolean visit(Variable<?> v) {
            return Boolean.FALSE;
        }

        public Boolean visitActions(List<OWLAxiomChange> changes) {
            boolean found = false;
            Iterator<OWLAxiomChange> it = changes.iterator();
            while (!found && it.hasNext()) {
                found = (Boolean)it.next().getAxiom().accept((OWLObjectVisitorEx)this);
            }
            return found;
        }

        public Boolean visit(OPPLQuery q, Boolean p) {
            return Boolean.FALSE;
        }

        public Boolean visit(Variable<?> v, Boolean p) {
            return Boolean.FALSE;
        }

        public Boolean visitActions(List<OWLAxiomChange> changes, Boolean p) {
            boolean found = false;
            Iterator<OWLAxiomChange> it = changes.iterator();
            while (!found && it.hasNext()) {
                found = (Boolean)it.next().getAxiom().accept((OWLObjectVisitorEx)this);
            }
            return found;
        }
    }

    private static final class PatternOPPLScriptValidator
    implements OPPLScriptValidator {
        public boolean accept(OPPLScript script) {
            boolean toReturn;
            boolean bl = toReturn = script.getQuery() == null;
            if (toReturn) {
                List actions = script.getActions();
                Iterator it = actions.iterator();
                while (toReturn && it.hasNext()) {
                    toReturn = ((OWLAxiomChange)it.next()).isAddAxiom();
                }
            }
            return toReturn;
        }

        public String getValidationRuleDescription() {
            return "The Script can only have ADD as its actions and cannot have any query";
        }
    }
}

