/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.oppl.OPPLSyntaxTree;
import org.coode.parsers.oppl.patterns.OPPLPatternsSymbolTable;
import org.coode.patterns.OPPLPatternParser;
import org.coode.patterns.ParserFactory;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternOPPLScript;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class PatternExtractor
extends OWLObjectVisitorExAdapter<PatternOPPLScript>
implements OWLAnnotationObjectVisitorEx<PatternOPPLScript> {
    private final OWLOntologyManager ontologyManager;
    private final OWLOntology ontology;
    private final ErrorListener errorListener;
    private final Set<OWLAnnotation> visited = new HashSet<OWLAnnotation>();

    public PatternExtractor(OWLOntology ontology, OWLOntologyManager owlOntologyManager, ErrorListener errorListener, Set<OWLAnnotation> visited) {
        this.ontology = (OWLOntology)ArgCheck.checkNotNull((Object)ontology, (String)"ontology");
        this.ontologyManager = (OWLOntologyManager)ArgCheck.checkNotNull((Object)owlOntologyManager, (String)"owlOntologyManager");
        this.errorListener = (ErrorListener)ArgCheck.checkNotNull((Object)errorListener, (String)"errorListener");
        this.visited.addAll(visited);
    }

    public PatternExtractor(OWLOntology ontology, OWLOntologyManager owlOntologyManager, ErrorListener listener) {
        this(ontology, owlOntologyManager, listener, Collections.emptySet());
    }

    public PatternOPPLScript visit(OWLAnnotation annotation) {
        PatternModel toReturn = null;
        if (this.visited.isEmpty() || !this.visited.contains(annotation)) {
            String value;
            if ("http://www.co-ode.org/patterns#".equals(annotation.getProperty().getIRI().getNamespace()) && (value = (String)annotation.getValue().accept((OWLObjectVisitorEx)new OWLObjectVisitorExAdapter<String>(){

                public String visit(OWLLiteral literal) {
                    return literal.getLiteral();
                }
            })) != null) {
                String patternName = annotation.getProperty().getIRI().getFragment();
                ParserFactory parserFactory = new ParserFactory(this.getOntology(), this.getOntologyManager());
                OPPLPatternParser parser = parserFactory.build(this.getErrorListener());
                Set<String> visitedPatternNames = this.getVisitedPatternNames();
                visitedPatternNames.add(patternName);
                this.getPatternReferenceResolver(visitedPatternNames);
                ParserFactory factory = new ParserFactory(this.ontology, this.ontologyManager);
                factory.build(visitedPatternNames, this.errorListener);
                toReturn = parser.parse(value);
                if (toReturn != null) {
                    toReturn.setIRI(annotation.getProperty().getIRI());
                }
            }
        } else {
            this.getErrorListener().reportThrowable((Throwable)new RuntimeException("Cyclic reference detected "), 0, 0, 0);
        }
        return toReturn;
    }

    protected Set<String> getVisitedPatternNames() {
        HashSet<String> toReturn = new HashSet<String>();
        for (OWLAnnotation patternAnnotation : this.visited) {
            IRI iri = patternAnnotation.getProperty().getIRI();
            if (iri == null || !"http://www.co-ode.org/patterns#".equals(iri.getNamespace())) continue;
            toReturn.add(iri.getFragment());
        }
        return toReturn;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    private OPPLPatternParser.PatternReferenceResolver getPatternReferenceResolver(final Collection<? extends String> done) {
        return new OPPLPatternParser.PatternReferenceResolver(){

            @Override
            public void resolvePattern(OPPLSyntaxTree reference, String patternName, PatternConstraintSystem constraintSystem, OPPLPatternsSymbolTable symbolTable, List<Object> ... args) {
                symbolTable.resolvePattern(reference, patternName, constraintSystem, new HashSet(done), args);
            }
        };
    }
}

