/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.InstantiatedOPPLScript;
import org.coode.oppl.OPPLQuery;
import org.coode.oppl.OPPLScriptVisitor;
import org.coode.oppl.OPPLScriptVisitorEx;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.bindingtree.BindingVisitor;
import org.coode.oppl.bindingtree.LeafBrusher;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.rendering.ManchesterSyntaxRenderer;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.parsers.ErrorListener;
import org.coode.patterns.HasPatternModel;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternException;
import org.coode.patterns.PatternExtractor;
import org.coode.patterns.PatternModel;
import org.coode.patterns.PatternOPPLScript;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class InstantiatedPatternModel
implements InstantiatedOPPLScript,
PatternOPPLScript,
HasPatternModel {
    private IRI uri = null;
    private final PatternModel patternModel;
    private final RuntimeExceptionHandler runtimeExceptionHandler;
    private final Map<Variable<?>, Set<OWLObject>> instantiations = new HashMap();
    private String unresolvedOPPLStatementString;

    public InstantiatedPatternModel(PatternModel patternModel, RuntimeExceptionHandler handler) {
        this.patternModel = (PatternModel)ArgCheck.checkNotNull((Object)patternModel, (String)"patternModel");
        this.runtimeExceptionHandler = (RuntimeExceptionHandler)ArgCheck.checkNotNull((Object)handler, (String)"handler");
    }

    public Set<OWLObject> getInstantiations(Variable<?> variable) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        if (this.instantiations.containsKey(variable)) {
            toReturn.addAll((Collection<OWLObject>)this.instantiations.get(variable));
        }
        return toReturn;
    }

    public boolean removeInstantiation(Variable<?> variable, OWLObject owlObject) {
        Set<OWLObject> variableInstantiations = this.instantiations.get(variable);
        boolean toReturn = false;
        if (variableInstantiations != null) {
            toReturn = variableInstantiations.remove(owlObject);
        }
        return toReturn;
    }

    public void instantiate(Variable<?> variable, OWLObject value) {
        if (this.getPatternModel().getVariables().contains(variable) || this.getPatternModel().getConstraintSystem().getThisClassVariable().equals(variable) && this.getPatternModel().getConstraintSystem().getVariable(variable.getName()) != null) {
            Set<OWLObject> instantiation = this.getInstantiations(variable);
            if (instantiation == null) {
                instantiation = new HashSet<OWLObject>();
            }
            instantiation.add(value);
            this.instantiations.put(variable, instantiation);
        }
    }

    public boolean isValid() {
        boolean unassignedVariables = false;
        Iterator<InputVariable<?>> it = this.getInputVariables().iterator();
        while (!unassignedVariables && it.hasNext()) {
            Variable variable = (Variable)it.next();
            unassignedVariables = this.instantiations.get(variable) == null || this.instantiations.get(variable).isEmpty();
        }
        return this.patternModel.isValid() && !unassignedVariables;
    }

    @Override
    public String getRendering() {
        String toReturn = this.patternModel.getRendering();
        for (Variable<?> variable : this.instantiations.keySet()) {
            Set<OWLObject> instantiation = this.instantiations.get(variable);
            if (instantiation != null) {
                if (instantiation.size() == 1) {
                    OWLObject singleInstantiation = instantiation.iterator().next();
                    toReturn = toReturn.replaceAll("\\" + variable.getName(), this.render(singleInstantiation));
                    continue;
                }
                String instantiationReplacement = "{";
                boolean firstInstantiationValue = true;
                for (OWLObject object : instantiation) {
                    instantiationReplacement = instantiationReplacement + (firstInstantiationValue ? this.render(object) : ", " + this.render(object));
                    firstInstantiationValue = firstInstantiationValue ? false : firstInstantiationValue;
                }
                instantiationReplacement = instantiationReplacement + "}";
                toReturn = toReturn.replaceAll("\\" + variable.getName(), instantiationReplacement);
                continue;
            }
            toReturn = toReturn + variable.getName();
        }
        return toReturn;
    }

    public String toString() {
        String toReturn = "$" + this.patternModel.getPatternLocalName();
        boolean first = true;
        toReturn = toReturn + "(";
        for (Variable variable : this.getInputVariables()) {
            if (!first) {
                toReturn = toReturn + ", ";
            } else {
                first = false;
            }
            ManchesterSyntaxRenderer renderer = this.patternModel.getPatternModelFactory().getRenderer(this.getConstraintSystem());
            Set<OWLObject> instantiation = this.instantiations.get(variable);
            if (instantiation != null) {
                if (instantiation.size() == 1) {
                    OWLObject singleInstantiation = instantiation.iterator().next();
                    singleInstantiation.accept((OWLObjectVisitor)renderer);
                    toReturn = toReturn + renderer.toString();
                    continue;
                }
                toReturn = toReturn + "{";
                boolean firstInstantiationValue = true;
                for (OWLObject object : instantiation) {
                    object.accept((OWLObjectVisitor)renderer);
                    toReturn = toReturn + (firstInstantiationValue ? renderer.toString() : ", " + renderer.toString());
                    firstInstantiationValue = firstInstantiationValue ? false : firstInstantiationValue;
                    renderer = this.patternModel.getPatternModelFactory().getRenderer(this.getConstraintSystem());
                }
                toReturn = toReturn + "}";
                continue;
            }
            toReturn = toReturn + variable.getName();
        }
        toReturn = toReturn + ")";
        return toReturn;
    }

    public String render(ShortFormProvider shortFormProvider) {
        String toReturn = "$" + this.patternModel.getPatternLocalName();
        boolean first = true;
        toReturn = toReturn + "(";
        for (Variable variable : this.getInputVariables()) {
            if (!first) {
                toReturn = toReturn + ", ";
            } else {
                first = false;
            }
            ManchesterSyntaxRenderer renderer = new ManchesterSyntaxRenderer(shortFormProvider);
            Set<OWLObject> instantiation = this.instantiations.get(variable);
            if (instantiation != null) {
                if (instantiation.size() == 1) {
                    OWLObject singleInstantiation = instantiation.iterator().next();
                    singleInstantiation.accept((OWLObjectVisitor)renderer);
                    toReturn = toReturn + renderer.toString();
                    continue;
                }
                toReturn = toReturn + "{";
                boolean firstInstantiationValue = true;
                for (OWLObject object : instantiation) {
                    object.accept((OWLObjectVisitor)renderer);
                    toReturn = toReturn + (firstInstantiationValue ? renderer.toString() : ", " + renderer.toString());
                    firstInstantiationValue = firstInstantiationValue ? false : firstInstantiationValue;
                    renderer = new ManchesterSyntaxRenderer(shortFormProvider);
                }
                toReturn = toReturn + "}";
                continue;
            }
            toReturn = toReturn + variable.getName();
        }
        toReturn = toReturn + ")";
        return toReturn;
    }

    protected String render(OWLObject owlObject) {
        ManchesterSyntaxRenderer renderer = this.patternModel.getPatternModelFactory().getRenderer(this.getConstraintSystem());
        owlObject.accept((OWLObjectVisitor)renderer);
        return renderer.toString();
    }

    public String getInstantiatedPatternLocalName() {
        return this.patternModel.getPatternLocalName();
    }

    public Set<BindingNode> extractBindingNodes() {
        List<InputVariable<?>> inputVariables = this.getInputVariables();
        HashMap bindings = new HashMap();
        for (InputVariable<?> v : inputVariables) {
            if (!this.instantiations.containsKey(v)) continue;
            bindings.put(v, new HashSet(this.instantiations.get(v)));
        }
        HashSet toAssign = new HashSet(inputVariables);
        if (this.isClassPattern()) {
            Variable<?> thisClassVariable = this.getConstraintSystem().getThisClassVariable();
            toAssign.add((InputVariable<?>)thisClassVariable);
            if (this.instantiations.containsKey(thisClassVariable)) {
                bindings.put(thisClassVariable, new HashSet(this.instantiations.get(thisClassVariable)));
            }
        }
        BindingNode rootBindingNode = new BindingNode(toAssign);
        LeafBrusher leafBrusher = new LeafBrusher(bindings);
        rootBindingNode.accept((BindingVisitor)leafBrusher);
        Set leaves = leafBrusher.getLeaves();
        return leaves;
    }

    @Override
    public Set<OWLObject> getOWLObjects(OWLOntology ontology, ErrorListener errorListener) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        boolean found = false;
        OWLAnnotationAssertionAxiom annotationAxiom2 = null;
        for (OWLClass owlClass : ontology.getClassesInSignature()) {
            for (OWLAnnotationAssertionAxiom annotationAxiom2 : owlClass.getAnnotationAssertionAxioms(ontology)) {
                PatternExtractor patternExtractor = this.patternModel.getPatternModelFactory().getPatternExtractor(errorListener);
                OWLAnnotation annotation = annotationAxiom2.getAnnotation();
                PatternOPPLScript script = (PatternOPPLScript)annotation.accept((OWLObjectVisitorEx)patternExtractor);
                found = script != null && this.getName().equals(script.getName());
                if (!found) continue;
                toReturn.add((OWLObject)annotationAxiom2);
            }
        }
        return toReturn;
    }

    public OWLOntology getOriginatingOntology() {
        OWLOntology toReturn = this.patternModel.getOriginatingOntology();
        return toReturn;
    }

    public void addVariable(Variable<?> v) {
        this.instantiations.put(v, null);
    }

    @Override
    public String getName() {
        return this.patternModel.getPatternLocalName();
    }

    public List<Variable<?>> getVariables() {
        return this.patternModel.getVariables();
    }

    public PatternConstraintSystem getConstraintSystem() {
        return this.patternModel.getConstraintSystem();
    }

    public PatternModel getInstantiatedPattern() {
        return this.patternModel;
    }

    @Override
    public void addDependency(PatternOPPLScript script) {
    }

    @Override
    public boolean dependsOn(PatternOPPLScript patternOPPLScript) {
        return patternOPPLScript.getName().equals(this.patternModel.getName()) || this.patternModel.dependsOn(patternOPPLScript);
    }

    public void setUnresolvedOPPLStatement(String unresolvedString) {
        this.unresolvedOPPLStatementString = unresolvedString;
    }

    public String gettUnresolvedOPPLStatement() {
        return this.unresolvedOPPLStatementString;
    }

    @Override
    public IRI getIRI() {
        return this.uri;
    }

    @Override
    public void setIRI(IRI uri) {
        this.uri = uri;
    }

    public String render(ConstraintSystem constraintSystem) {
        return this.render();
    }

    public String render() {
        String toReturn = "$" + this.getInstantiatedPatternLocalName();
        boolean first = true;
        toReturn = toReturn + "(";
        for (Variable variable : this.getInputVariables()) {
            if (!first) {
                toReturn = toReturn + ", ";
            } else {
                first = false;
            }
            Set<OWLObject> instantiationsValues = this.getInstantiations(variable);
            if (instantiationsValues != null && !instantiationsValues.isEmpty()) {
                if (instantiationsValues.size() == 1) {
                    OWLObject instantiation = instantiationsValues.iterator().next();
                    toReturn = toReturn + this.render(instantiation);
                    continue;
                }
                boolean firstInstantiation = true;
                toReturn = toReturn + "{";
                for (OWLObject instantiation : instantiationsValues) {
                    String instantiationRendering = this.render(instantiation);
                    toReturn = toReturn + (firstInstantiation ? instantiationRendering : ", " + instantiationRendering);
                    firstInstantiation = firstInstantiation ? false : firstInstantiation;
                }
                toReturn = toReturn + "}";
                continue;
            }
            toReturn = toReturn + variable.getName();
        }
        toReturn = toReturn + ")";
        return toReturn;
    }

    @Override
    public PatternModel getPatternModel() {
        return this.patternModel;
    }

    @Override
    public boolean isClassPattern() {
        return this.patternModel.isClassPattern();
    }

    public List<InputVariable<?>> getInputVariables() {
        return this.patternModel.getOpplStatement().getInputVariables();
    }

    @Override
    public boolean hasScopedVariables() {
        return this.getPatternModel().hasScopedVariables();
    }

    public void accept(OPPLScriptVisitor visitor) {
        this.patternModel.accept(visitor);
    }

    public <P> P accept(OPPLScriptVisitorEx<P> visitor) {
        return this.patternModel.accept(visitor);
    }

    public List<OWLAxiomChange> getActions() {
        List<OWLAxiomChange> actions = this.patternModel.getActions();
        Set<BindingNode> bindingNodes = this.extractBindingNodes();
        ArrayList<OWLAxiomChange> toReturn = new ArrayList<OWLAxiomChange>();
        for (BindingNode bindingNode : bindingNodes) {
            for (OWLAxiomChange axiomChange : actions) {
                SimpleValueComputationParameters parameters = new SimpleValueComputationParameters((ConstraintSystem)this.getConstraintSystem(), bindingNode, this.getRuntimeExceptionHandler());
                PartialOWLObjectInstantiator partialObjectInstantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)parameters);
                OWLAxiom axiom = axiomChange.getAxiom();
                OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)partialObjectInstantiator);
                AddAxiom instantiatedChange = axiomChange.isAddAxiom() ? new AddAxiom(axiomChange.getOntology(), instantiatedAxiom) : new RemoveAxiom(axiomChange.getOntology(), instantiatedAxiom);
                toReturn.add((OWLAxiomChange)instantiatedChange);
            }
        }
        return toReturn;
    }

    public OPPLQuery getQuery() {
        return null;
    }

    @Override
    public OWLObject getDefinitorialPortion(Collection<? extends BindingNode> bindingNodes, RuntimeExceptionHandler reh) throws PatternException {
        return this.getPatternModel().getDefinitorialPortion(bindingNodes, reh);
    }

    public RuntimeExceptionHandler getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }
}

