/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.coode.oppl.ActionType;
import org.coode.oppl.ChangeExtractor;
import org.coode.oppl.OPPLScript;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.patterns.InstantiatedPatternModel;
import org.coode.patterns.PatternActionFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class ClassPatternExecutor
extends ChangeExtractor {
    private final InstantiatedPatternModel instantiatedPatternModel;
    private final OWLClass owlClass;
    private final IRI annotationIRI;
    private final OWLOntology ontology;
    private final OWLOntologyManager ontologyManager;

    public ClassPatternExecutor(OWLClass thisClass, InstantiatedPatternModel instantiatedPatternModel, OWLOntology ontology, OWLOntologyManager ontologyManager, IRI annotationIRI, RuntimeExceptionHandler runtimeExceptionHandler) {
        super(runtimeExceptionHandler, true);
        this.owlClass = thisClass;
        this.instantiatedPatternModel = instantiatedPatternModel;
        this.annotationIRI = annotationIRI;
        this.ontology = ontology;
        this.ontologyManager = ontologyManager;
    }

    public List<OWLAxiomChange> visit(OPPLScript script) {
        List changes = script.getActions();
        HashSet<? extends OWLAxiomChange> p = new HashSet<OWLAxiomChange>(changes.size());
        for (OWLAxiomChange axiomChange : changes) {
            ActionType actionType = axiomChange.isAddAxiom() ? ActionType.ADD : ActionType.REMOVE;
            OWLAxiom axiom = axiomChange.getAxiom();
            Collection<? extends OWLAxiomChange> createdChanges = PatternActionFactory.createChange(this.owlClass, actionType, axiom, this.instantiatedPatternModel, this.ontologyManager.getOWLDataFactory(), this.annotationIRI, this.ontology, this.getRuntimeExceptionHandler());
            p.addAll(createdChanges);
        }
        return new ArrayList<OWLAxiomChange>(p);
    }
}

