/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers.oppl.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.coode.oppl.Variable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.Scope;
import org.coode.parsers.Symbol;
import org.coode.parsers.Type;
import org.coode.parsers.oppl.OPPLSyntaxTree;
import org.coode.patterns.PatternConstraintSystem;
import org.coode.patterns.PatternException;
import org.coode.patterns.PatternOPPLScript;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OPPLPatternScope
implements Scope {
    private final Scope delegate;
    private final OWLOntologyManager ontologyManager;

    public OPPLPatternScope(Scope scope, OWLOntologyManager ontologyManager) {
        this.delegate = (Scope)ArgCheck.checkNotNull((Object)scope, (String)"scope");
        this.ontologyManager = (OWLOntologyManager)ArgCheck.checkNotNull((Object)ontologyManager, (String)"ontologyManager");
    }

    public void define(Symbol symbol) {
        this.delegate.define(symbol);
    }

    public Set<Symbol> getAllSymbols() {
        return this.delegate.getAllSymbols();
    }

    public Set<Symbol> getAllSymbols(Type type) {
        return this.delegate.getAllSymbols(type);
    }

    public Scope getEnclosingScope() {
        return this.delegate.getEnclosingScope();
    }

    public String getScopeName() {
        return this.delegate.getScopeName();
    }

    public Set<Symbol> match(String prefix) {
        return this.delegate.match(prefix);
    }

    public Symbol resolve(String name) {
        Symbol toReturn = this.delegate.resolve(name);
        return toReturn;
    }

    protected Scope getDelegate() {
        return this.delegate;
    }

    public Variable<?> resolvePatternReference(OPPLSyntaxTree reference, String patternName, PatternConstraintSystem constraintSystem, ErrorListener listener, List<Object> ... args) {
        return this.resolvePatternReference(reference, patternName, constraintSystem, Collections.emptySet(), listener, args);
    }

    public Variable<?> resolvePatternReference(OPPLSyntaxTree reference, String patternName, PatternConstraintSystem constraintSystem, Collection<? extends String> visited, ErrorListener listener, List<Object> ... args) {
        Variable<?> toReturn;
        block2: {
            toReturn = null;
            try {
                String resolvedPattern = constraintSystem.resolvePattern(patternName, new HashSet<String>(visited), new ArrayList<PatternOPPLScript>(), listener, args);
                toReturn = constraintSystem.getVariable(resolvedPattern);
            }
            catch (PatternException e) {
                if (listener == null) break block2;
                listener.illegalToken((CommonTree)reference, "Could not resolve the reference: " + e.getMessage());
            }
        }
        return toReturn;
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public void dispose() {
        this.delegate.dispose();
    }
}

