/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.locality;

import java.util.Set;
import org.coode.patterns.locality.AxiomLocality;
import org.coode.patterns.locality.BottomReplacer;
import org.coode.patterns.locality.LocalityEvaluator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public final class SemanticLocalityEvaluator
implements LocalityEvaluator {
    protected OWLDataFactory df;
    private final AxiomLocality axiomVisitor;
    private final BottomReplacer bottomReplacer;
    protected OWLReasoner reasoner;

    public SemanticLocalityEvaluator(OWLOntologyManager man, OWLReasoner reasoner) {
        this.df = man.getOWLDataFactory();
        this.reasoner = reasoner;
        this.axiomVisitor = new AxiomLocality(reasoner);
        this.bottomReplacer = new BottomReplacer(this.df);
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Set<? extends OWLEntity> signature) {
        OWLAxiom newAxiom = this.bottomReplacer.replaceBottom(axiom, signature);
        boolean toReturn = newAxiom == null || this.axiomVisitor.isLocal(newAxiom);
        return toReturn;
    }
}

