/*
 * Decompiled with CFR 0.152.
 */
package org.coode.patterns.locality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.PartialOWLObjectInstantiator;
import org.coode.oppl.Variable;
import org.coode.oppl.bindingtree.Assignment;
import org.coode.oppl.bindingtree.BindingNode;
import org.coode.oppl.bindingtree.BindingVisitor;
import org.coode.oppl.exceptions.RuntimeExceptionHandler;
import org.coode.oppl.function.SimpleValueComputationParameters;
import org.coode.oppl.function.ValueComputationParameters;
import org.coode.oppl.utils.ArgCheck;
import org.coode.patterns.PatternModel;
import org.coode.patterns.locality.LocalityEvaluator;
import org.coode.patterns.locality.SigmaPlusSigmaMinus;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class LocalityCheckerLeafBrusher
implements BindingVisitor {
    private final LocalityEvaluator evaluator;
    private final ConstraintSystem constraintSystem;
    private final PatternModel patternModel;
    private final RuntimeExceptionHandler handler;
    private final Set<OWLEntity> signature = new HashSet<OWLEntity>();
    private final Map<Variable<?>, SigmaPlusSigmaMinus> variableBindings = new HashMap();
    private final List<BindingNode> exploredBindings = new ArrayList<BindingNode>();
    private final List<Boolean> exploredBindingsLocality = new ArrayList<Boolean>();
    private final List<OWLAxiom> foundNonLocals = new ArrayList<OWLAxiom>();

    public List<BindingNode> getExploredBindings() {
        return this.exploredBindings;
    }

    public List<Boolean> getExploredBindingsLocality() {
        return this.exploredBindingsLocality;
    }

    public LocalityCheckerLeafBrusher(LocalityEvaluator evaluator, ConstraintSystem constraintSystem, PatternModel patternModel, Map<Variable<?>, SigmaPlusSigmaMinus> variableBindings, Set<OWLEntity> signature, RuntimeExceptionHandler runtimeExceptionHandler) {
        this.evaluator = (LocalityEvaluator)ArgCheck.checkNotNull((Object)evaluator, (String)"evaluator");
        this.constraintSystem = (ConstraintSystem)ArgCheck.checkNotNull((Object)constraintSystem, (String)"constraintSystem");
        this.patternModel = (PatternModel)ArgCheck.checkNotNull((Object)patternModel, (String)"patternModel");
        this.handler = (RuntimeExceptionHandler)ArgCheck.checkNotNull((Object)runtimeExceptionHandler, (String)"runtimeExceptionHandler");
        this.signature.addAll((Collection)ArgCheck.checkNotNull(signature, (String)"signature"));
        this.variableBindings.putAll((Map)ArgCheck.checkNotNull(variableBindings, (String)"variableBindings"));
    }

    public void visit(BindingNode bindingNode) {
        if (!bindingNode.isEmpty()) {
            HashSet<BindingNode> allLeaves = new HashSet<BindingNode>();
            ArrayList<BindingNode> nodes = new ArrayList<BindingNode>();
            nodes.add(bindingNode);
            while (nodes.size() > 0) {
                BindingNode node = (BindingNode)nodes.remove(0);
                if (!node.isLeaf()) {
                    nodes.addAll(this.generateChildren(node));
                    continue;
                }
                allLeaves.add(node);
            }
            for (BindingNode node : allLeaves) {
                this.checkLocal(node);
            }
        }
    }

    private void checkLocal(BindingNode bindingNode) {
        SimpleValueComputationParameters parameters = new SimpleValueComputationParameters(this.getConstraintSystem(), bindingNode, this.getHandler());
        PartialOWLObjectInstantiator instantiator = new PartialOWLObjectInstantiator((ValueComputationParameters)parameters);
        this.exploredBindings.add(bindingNode);
        List<OWLAxiomChange> changes = this.patternModel.getActions();
        boolean safe = true;
        for (int i = 0; i < changes.size(); ++i) {
            OWLAxiom axiom = changes.get(i).getAxiom();
            OWLAxiom instantiatedAxiom = (OWLAxiom)axiom.accept((OWLObjectVisitorEx)instantiator);
            try {
                HashSet<OWLEntity> actualSignature = new HashSet<OWLEntity>(this.signature);
                for (SigmaPlusSigmaMinus s : this.variableBindings.values()) {
                    actualSignature.add(s.getPlus());
                }
                if (this.evaluator.isLocal(instantiatedAxiom, actualSignature)) continue;
                this.foundNonLocals.add(instantiatedAxiom);
                safe = false;
                continue;
            }
            catch (OWLRuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.exploredBindingsLocality.add(safe);
    }

    public boolean isLocal() {
        return this.foundNonLocals.size() == 0;
    }

    public List<OWLAxiom> getNonLocalAxioms() {
        return this.foundNonLocals;
    }

    private Set<BindingNode> generateChildren(BindingNode node) {
        HashSet<BindingNode> toReturn = new HashSet<BindingNode>();
        Set unassignedVariables = node.getUnassignedVariables();
        for (Variable variable : unassignedVariables) {
            for (OWLObject owlObject : this.variableBindings.get(variable)) {
                HashSet childUnassignedVariables = new HashSet(unassignedVariables);
                childUnassignedVariables.remove(variable);
                HashSet<Assignment> childAssignements = new HashSet<Assignment>(node.getAssignments());
                childAssignements.add(new Assignment(variable, owlObject));
                BindingNode newNode = new BindingNode(childAssignements, childUnassignedVariables);
                toReturn.add(newNode);
            }
        }
        return toReturn;
    }

    public Set<OWLEntity> getSignature() {
        return new HashSet<OWLEntity>(this.signature);
    }

    public void setSignature(Collection<? extends OWLEntity> signature) {
        this.signature.clear();
        this.signature.addAll(signature);
    }

    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public RuntimeExceptionHandler getHandler() {
        return this.handler;
    }
}

