/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.coode.oppl.semanticweb.owlapi.model.OWLPropertyChain;
import org.coode.oppl.semanticweb.owlapi.model.OWLPropertyChainImpl;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.ErrorListener;
import org.coode.parsers.IRISymbol;
import org.coode.parsers.ManchesterOWLSyntaxTree;
import org.coode.parsers.OWLAxiomType;
import org.coode.parsers.OWLEntitySymbol;
import org.coode.parsers.OWLLiteralSymbol;
import org.coode.parsers.OWLType;
import org.coode.parsers.Scope;
import org.coode.parsers.Symbol;
import org.coode.parsers.SymbolVisitorEx;
import org.coode.parsers.Type;
import org.coode.parsers.TypeVisitorEx;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class SymbolTable {
    private final Scope globalScope;
    protected final OWLDataFactory df;
    private final Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    private ErrorListener errorListener;
    private final OWLTypeOnlyVisitor classDetector = new OWLTypeOnlyVisitor(){

        @Override
        public Boolean visitOWLType(OWLType owlType) {
            return OWLType.isClassExpression(owlType);
        }
    };
    private final OWLTypeOnlyVisitor dtDetector = new OWLTypeOnlyVisitor(){

        @Override
        public Boolean visitOWLType(OWLType owlType) {
            return OWLType.isDataTypeExpression(owlType);
        }
    };
    private final OWLTypeOnlyVisitor opDetector = new OWLTypeOnlyVisitor(){

        @Override
        public Boolean visitOWLType(OWLType owlType) {
            return OWLType.isObjectPropertyExpression(owlType);
        }
    };
    private final OWLTypeOnlyVisitor pDetector = new OWLTypeOnlyVisitor(){

        @Override
        public Boolean visitOWLType(OWLType owlType) {
            return OWLType.isObjectPropertyExpression(owlType) || owlType == OWLType.OWL_DATA_PROPERTY;
        }
    };
    private final OWLAxiomTypeOnlyVisitor simpleAssertionDetector = new OWLAxiomTypeOnlyVisitor(){

        @Override
        public Boolean visitOWLAxiomType(OWLAxiomType owlAxiomType) {
            return OWLAxiomType.isAssertion(owlAxiomType) && (owlAxiomType == OWLAxiomType.OBJECT_PROPERTY_ASSERTION || owlAxiomType == OWLAxiomType.DATA_PROPERTY_ASSERTION);
        }
    };
    private final OWLTypeOnlyVisitor annDetector = new OWLTypeOnlyVisitor(){

        @Override
        public Boolean visitOWLType(OWLType owlType) {
            return owlType == OWLType.OWL_CONSTANT || owlType == OWLType.IRI;
        }
    };

    public SymbolTable(Scope globalScope, OWLDataFactory dataFactory) {
        this.globalScope = ArgCheck.checkNotNull(globalScope, "globalScope");
        this.df = ArgCheck.checkNotNull(dataFactory, "dataFactory");
    }

    public Scope getGlobalScope() {
        return this.globalScope;
    }

    public Symbol resolve(ManchesterOWLSyntaxTree node) {
        String name = node.getToken().getText();
        Symbol toReturn = this.retrieveSymbol(name);
        if (toReturn == null) {
            toReturn = this.getGlobalScope().resolve(name);
            if (toReturn == null && this.getErrorListener() != null) {
                this.reportUnrecognisedSymbol(node);
            } else if (toReturn != null) {
                this.symbols.put(name, toReturn);
            }
        }
        if (toReturn != null) {
            node.setEvalType(toReturn.getType());
            node.setOWLObject(toReturn.accept(new SymbolVisitorEx<OWLObject>(){

                @Override
                public OWLObject visitOWLEntity(OWLEntitySymbol owlEntitySymbol) {
                    return owlEntitySymbol.getEntity();
                }

                @Override
                public OWLObject visitOWLLiteral(OWLLiteralSymbol owlConstantSymbol) {
                    return owlConstantSymbol.getOWLLiteral();
                }

                @Override
                public OWLObject visitIRI(IRISymbol iriSymbol) {
                    return null;
                }

                @Override
                public OWLObject visitSymbol(Symbol symbol) {
                    return null;
                }
            }));
        }
        return toReturn;
    }

    protected Symbol retrieveSymbol(String name) {
        return this.symbols.get(name);
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public Type getSubClassAxiomType(CommonTree expression, ManchesterOWLSyntaxTree subClass, ManchesterOWLSyntaxTree superClass) {
        OWLAxiomType toReturn = null;
        if (subClass.getEvalType() == null || !subClass.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(subClass, expression);
        } else if (superClass.getEvalType() == null || !superClass.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(superClass, expression);
        } else {
            toReturn = OWLAxiomType.SUBCLASS;
        }
        return toReturn;
    }

    public void reportIncompatibleSymbolType(ManchesterOWLSyntaxTree tree, CommonTree parentExpression) {
        this.reportIncompatibleSymbolType(tree, tree.getEvalType(), parentExpression);
    }

    public void reportIncompatibleSymbolType(CommonTree tree, Type t, CommonTree parentExpression) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().incompatibleSymbolType(tree, t, parentExpression);
        }
    }

    public void reportIncompatibleSymbols(CommonTree parentExpression, CommonTree ... expressions) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().incompatibleSymbols(parentExpression, expressions);
        }
    }

    public void reportIllegalToken(CommonTree expression, String message) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().illegalToken(expression, message);
        }
    }

    public Type getDisjunctionType(CommonTree expression, ManchesterOWLSyntaxTree ... disjuncts) {
        boolean allFine = true;
        OWLType toReturn = null;
        Type rest = null;
        for (ManchesterOWLSyntaxTree disjunct : disjuncts) {
            if (disjunct.getEvalType() == null || !this.isNAryDescriptionCompatible(rest, disjunct.getEvalType())) {
                allFine = false;
                this.reportIncompatibleSymbolType(disjunct, expression);
                continue;
            }
            if (rest != null) continue;
            rest = disjunct.getEvalType();
        }
        if (allFine && rest != null) {
            toReturn = rest.accept(this.classDetector) != false ? OWLType.OWL_OBJECT_INTERSECTION_OF : OWLType.OWL_DATA_UNION_OF;
        }
        return toReturn;
    }

    public Type getConjunctionType(CommonTree expression, ManchesterOWLSyntaxTree ... conjuncts) {
        boolean allFine = true;
        OWLType toReturn = null;
        Type rest = null;
        for (ManchesterOWLSyntaxTree conjunct : conjuncts) {
            if (conjunct.getEvalType() == null || !this.isNAryDescriptionCompatible(rest, conjunct.getEvalType())) {
                allFine = false;
                this.reportIncompatibleSymbolType(conjunct, expression);
                continue;
            }
            rest = rest == null ? conjunct.getEvalType() : rest;
        }
        if (allFine && rest != null) {
            toReturn = rest.accept(this.classDetector) != false ? OWLType.OWL_OBJECT_INTERSECTION_OF : OWLType.OWL_DATA_INTERSECTION_OF;
        }
        return toReturn;
    }

    private boolean isNAryDescriptionCompatible(Type rest, Type operandType) {
        return rest == null ? operandType.accept(this.classDetector).booleanValue() || operandType.accept(this.dtDetector).booleanValue() : rest.accept(this.classDetector) != false && operandType.accept(this.classDetector) != false || rest.accept(this.dtDetector) != false && operandType.accept(this.dtDetector) != false;
    }

    public Type getNegatedClassExpressionType(CommonTree expression, ManchesterOWLSyntaxTree node) {
        OWLType toReturn = null;
        if (node.getEvalType() == null || !node.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(node, expression);
        } else {
            toReturn = OWLType.OWL_OBJECT_COMPLEMENT_OF;
        }
        return toReturn;
    }

    public Type getInversePropertyType(CommonTree expression, ManchesterOWLSyntaxTree property) {
        OWLType toReturn = null;
        if (property.getEvalType() == null || !property.getEvalType().accept(this.opDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(property, expression);
        } else {
            toReturn = OWLType.OWL_OBJECT_INVERSE_PROPERTY;
        }
        return toReturn;
    }

    public Type getSubPropertyAxiomType(CommonTree expression, ManchesterOWLSyntaxTree subProperty, ManchesterOWLSyntaxTree superProperty) {
        boolean areChildrenCompatible;
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (subProperty.getEvalType() == null || !subProperty.getEvalType().accept(this.pDetector).booleanValue() && subProperty.getEvalType() != OWLType.OWL_PROPERTY_CHAIN) {
            this.reportIncompatibleSymbolType(subProperty, expression);
            rightKinds = false;
        }
        if (superProperty.getEvalType() == null || !superProperty.getEvalType().accept(this.pDetector).booleanValue()) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(superProperty, expression);
        }
        boolean bl = areChildrenCompatible = subProperty.getEvalType() == superProperty.getEvalType() || subProperty.getEvalType() == OWLType.OWL_PROPERTY_CHAIN && superProperty.getEvalType() == OWLType.OWL_OBJECT_PROPERTY;
        if (rightKinds && areChildrenCompatible) {
            if (areChildrenCompatible) {
                toReturn = subProperty.getEvalType().accept(this.opDetector) != false ? OWLAxiomType.SUB_OBJECT_PROPERTY : OWLAxiomType.SUB_DATA_PROPERTY;
                toReturn = subProperty.getEvalType() == OWLType.OWL_PROPERTY_CHAIN ? OWLAxiomType.PROPERTY_CHAIN_SUB_PROPERTY : toReturn;
            } else {
                this.reportIncompatibleSymbols(expression, subProperty, superProperty);
            }
        } else {
            this.reportIncompatibleSymbols(expression, subProperty, superProperty);
        }
        return toReturn;
    }

    public Type getSomeValueRestrictionType(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLType toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (filler.getEvalType() == null || !filler.getEvalType().accept(this.classDetector).booleanValue() && !filler.getEvalType().accept(this.dtDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(filler, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (!filler.getEvalType().accept(this.dtDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_DATA_SOME_RESTRICTION;
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_OBJECT_SOME_RESTRICTION;
                }
            }
        }
        return toReturn;
    }

    public Type getAllValueRestrictionType(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLType toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (filler.getEvalType() == null || !filler.getEvalType().accept(this.classDetector).booleanValue() && !filler.getEvalType().accept(this.dtDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(filler, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (!filler.getEvalType().accept(this.dtDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_DATA_ALL_RESTRICTION;
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_OBJECT_ALL_RESTRICTION;
                }
            }
        }
        return toReturn;
    }

    public Type getMinCardinalityRestrictionType(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLType toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (filler != null && filler.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_DATA_MIN_CARDINALITY_RESTRICTION;
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!(filler == null || filler.getEvalType() != null && filler.getEvalType().accept(this.classDetector).booleanValue())) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_OBJECT_MIN_CARDINALITY_RESTRICTION;
                }
            }
        }
        return toReturn;
    }

    public Type getMaxCardinalityRestrictionType(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLType toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (filler != null && filler.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_DATA_MAX_CARDINALITY_RESTRICTION;
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!(filler == null || filler.getEvalType() != null && filler.getEvalType().accept(this.classDetector).booleanValue())) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_OBJECT_MAX_CARDINALITY_RESTRICTION;
                }
            }
        }
        return toReturn;
    }

    public Type getExactCardinalityRestrictionType(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLType toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (filler != null && filler.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_DATA_EXACT_CARDINALITY_RESTRICTION;
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!(filler == null || filler.getEvalType() != null && filler.getEvalType().accept(this.classDetector).booleanValue())) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = OWLType.OWL_OBJECT_EXACT_CARDINALITY_RESTRICTION;
                }
            }
        }
        return toReturn;
    }

    public Type getOneOfType(CommonTree expression, ManchesterOWLSyntaxTree ... individuals) {
        boolean allFine = true;
        OWLType toReturn = null;
        for (ManchesterOWLSyntaxTree individual : individuals) {
            if (individual.getEvalType() != null && individual.getEvalType() == OWLType.OWL_INDIVIDUAL) continue;
            allFine = false;
            this.reportIncompatibleSymbolType(individual, expression);
        }
        if (allFine) {
            toReturn = OWLType.OWL_OBJECT_ONE_OF;
        }
        return toReturn;
    }

    public Type getValueRestrictionType(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree value) {
        OWLType toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (value.getEvalType() == null) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (value.getEvalType() != OWLType.OWL_CONSTANT) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, value);
                } else {
                    toReturn = OWLType.OWL_DATA_VALUE_RESTRICTION;
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (value.getEvalType() != OWLType.OWL_INDIVIDUAL) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, value);
                } else {
                    toReturn = OWLType.OWL_OBJECT_VALUE_RESTRICTION;
                }
            }
        }
        return toReturn;
    }

    public OWLClassExpression getValueRestriction(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree value) {
        OWLDataHasValue toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (value.getEvalType() != OWLType.OWL_CONSTANT) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, value);
                } else {
                    toReturn = this.df.getOWLDataHasValue((OWLDataPropertyExpression)propertyExpression.getOWLObject(), (OWLLiteral)value.getOWLObject());
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (value.getEvalType() != OWLType.OWL_INDIVIDUAL) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, value);
                } else {
                    toReturn = this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)propertyExpression.getOWLObject(), (OWLIndividual)value.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public Type getRoleAssertionAxiomType(CommonTree expression, ManchesterOWLSyntaxTree subject, ManchesterOWLSyntaxTree property, ManchesterOWLSyntaxTree object) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (subject.getEvalType() == null || subject.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            this.reportIncompatibleSymbolType(subject, expression);
            rightKinds = false;
        }
        if (property.getEvalType() == null || !property.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(property, expression);
            rightKinds = false;
        }
        if (object.getEvalType() == null || object.getEvalType() != OWLType.OWL_INDIVIDUAL && object.getEvalType() != OWLType.OWL_CONSTANT) {
            this.reportIncompatibleSymbolType(object, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (property.getEvalType().accept(this.opDetector).booleanValue()) {
                if (object.getEvalType() != OWLType.OWL_INDIVIDUAL) {
                    this.reportIncompatibleSymbols(expression, property, object);
                } else {
                    toReturn = OWLAxiomType.OBJECT_PROPERTY_ASSERTION;
                }
            } else if (property.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (object.getEvalType() != OWLType.OWL_CONSTANT) {
                    this.reportIncompatibleSymbols(expression, property, object);
                } else {
                    toReturn = OWLAxiomType.DATA_PROPERTY_ASSERTION;
                }
            }
        }
        return toReturn;
    }

    public void clear() {
        this.symbols.clear();
    }

    public Type getEquivalentAxiomType(CommonTree expression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (lhs.getEvalType() == null || !lhs.getEvalType().accept(this.classDetector).booleanValue() && !lhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(lhs, expression);
            rightKinds = false;
        }
        if (rhs.getEvalType() == null || !rhs.getEvalType().accept(this.classDetector).booleanValue() && !rhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(rhs, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (lhs.getEvalType().accept(this.classDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = OWLAxiomType.EQUIVALENT_CLASSES;
                }
            } else if (lhs.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.opDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = OWLAxiomType.EQUIVALENT_OBJECT_PROPERTIES;
                }
            } else if (lhs.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (rhs.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = OWLAxiomType.EQUIVALENT_DATA_PROPERTIES;
                }
            }
        }
        return toReturn;
    }

    public Type getDomainAxiomType(CommonTree expression, ManchesterOWLSyntaxTree p, ManchesterOWLSyntaxTree domain) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (p.getEvalType() == null || p.getEvalType() != OWLType.OWL_OBJECT_PROPERTY && p.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
            this.reportIncompatibleSymbolType(p, expression);
            rightKinds = false;
        }
        if (domain.getEvalType() == null || !domain.getEvalType().accept(this.classDetector).booleanValue() && domain.getEvalType() != OWLType.OWL_DATA_TYPE) {
            this.reportIncompatibleSymbolType(domain, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (p.getEvalType() == OWLType.OWL_OBJECT_PROPERTY) {
                if (!domain.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, p, domain);
                } else {
                    toReturn = OWLAxiomType.OBJECT_PROPERTY_DOMAIN;
                }
            } else if (p.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (!domain.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, p, domain);
                } else {
                    toReturn = OWLAxiomType.DATA_PROPERTY_DOMAIN;
                }
            }
        }
        return toReturn;
    }

    public Type getRangeAxiomType(CommonTree expression, ManchesterOWLSyntaxTree p, ManchesterOWLSyntaxTree range) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (p.getEvalType() == null || p.getEvalType() != OWLType.OWL_OBJECT_PROPERTY && p.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
            this.reportIncompatibleSymbolType(p, expression);
            rightKinds = false;
        }
        if (range.getEvalType() == null || !range.getEvalType().accept(this.classDetector).booleanValue() && range.getEvalType() != OWLType.OWL_DATA_TYPE) {
            this.reportIncompatibleSymbolType(range, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (p.getEvalType() == OWLType.OWL_OBJECT_PROPERTY) {
                if (!range.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, p, range);
                } else {
                    toReturn = OWLAxiomType.OBJECT_PROPERTY_RANGE;
                }
            } else if (p.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (range.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, p, range);
                } else {
                    toReturn = OWLAxiomType.DATA_PROPERTY_RANGE;
                }
            }
        }
        return toReturn;
    }

    public Type getPropertyChainType(CommonTree expression, ManchesterOWLSyntaxTree ... chainItems) {
        boolean allFine = true;
        OWLType toReturn = null;
        for (ManchesterOWLSyntaxTree item : chainItems) {
            if (item.getEvalType() != null && item.getEvalType().accept(this.opDetector).booleanValue()) continue;
            allFine = false;
            this.reportIncompatibleSymbolType(item, expression);
        }
        if (allFine) {
            toReturn = OWLType.OWL_PROPERTY_CHAIN;
        }
        return toReturn;
    }

    public Type getDisjointAxiomType(CommonTree expression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (lhs.getEvalType() == null || !lhs.getEvalType().accept(this.classDetector).booleanValue() && !lhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(lhs, expression);
            rightKinds = false;
        }
        if (rhs.getEvalType() == null || !rhs.getEvalType().accept(this.classDetector).booleanValue() && !rhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(rhs, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (lhs.getEvalType().accept(this.classDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = OWLAxiomType.DISJOINT_CLASSES;
                }
            } else if (lhs.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.opDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = OWLAxiomType.DISJOINT_OBJECT_PROPERTIES;
                }
            } else if (lhs.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (rhs.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = OWLAxiomType.DISJOINT_DATA_PROPERTIES;
                }
            }
        }
        return toReturn;
    }

    public Type getSameIndividualsAxiomType(CommonTree expression, ManchesterOWLSyntaxTree anIndividual, ManchesterOWLSyntaxTree anotherIndividual) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (anIndividual.getEvalType() == null || anIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anIndividual, expression);
        }
        if (anotherIndividual.getEvalType() == null || anotherIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anotherIndividual, expression);
        }
        if (rightKinds) {
            toReturn = OWLAxiomType.SAME_INDIVIDUAL;
        }
        return toReturn;
    }

    public Type getDifferentIndividualsAxiomType(CommonTree expression, ManchesterOWLSyntaxTree anIndividual, ManchesterOWLSyntaxTree anotherIndividual) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (anIndividual.getEvalType() == null || anIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anIndividual, expression);
        }
        if (anotherIndividual.getEvalType() == null || anotherIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anotherIndividual, expression);
        }
        if (rightKinds) {
            toReturn = OWLAxiomType.DIFFERENT_INDIVIDUALS;
        }
        return toReturn;
    }

    public Type getFunctionalPropertyType(CommonTree expression, ManchesterOWLSyntaxTree p) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (p.getEvalType() == null || p.getEvalType() != OWLType.OWL_OBJECT_PROPERTY && p.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(p, expression);
        }
        if (rightKinds) {
            toReturn = p.getEvalType() == OWLType.OWL_OBJECT_PROPERTY ? OWLAxiomType.FUNCTIONAL_OBJECT_PROPERTY : OWLAxiomType.FUNCTIONAL_DATA_PROPERTY;
        }
        return toReturn;
    }

    public Type getInverseFunctionalPropertyType(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return OWLAxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY;
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public Type getIrreflexivePropertyType(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return OWLAxiomType.IRREFLEXIVE_OBJECT_PROPERTY;
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public Type getReflexivePropertyType(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return OWLAxiomType.REFLEXIVE_OBJECT_PROPERTY;
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public Type getSymmetricPropertyType(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return OWLAxiomType.SYMMETRIC_OBJECT_PROPERTY;
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public Type getTransitivePropertyType(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return OWLAxiomType.TRANSITIVE_OBJECT_PROPERTY;
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public Type getInverseOfAxiomType(CommonTree expression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (lhs.getEvalType() == null || !lhs.getEvalType().accept(this.opDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(lhs, expression);
            rightKinds = false;
        }
        if (rhs.getEvalType() == null || !rhs.getEvalType().accept(this.opDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(rhs, expression);
            rightKinds = false;
        }
        if (rightKinds && lhs.getEvalType().accept(this.opDetector).booleanValue()) {
            if (!rhs.getEvalType().accept(this.opDetector).booleanValue()) {
                this.reportIncompatibleSymbols(expression, lhs, rhs);
            } else {
                toReturn = OWLAxiomType.INVERSE_OBJECT_PROPERTIES;
            }
        }
        return toReturn;
    }

    public Type getNegatedAssertionType(CommonTree expression, ManchesterOWLSyntaxTree assertion) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (assertion.getEvalType() == null || !assertion.getEvalType().accept(this.simpleAssertionDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(assertion, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (assertion.getEvalType() == OWLAxiomType.OBJECT_PROPERTY_ASSERTION) {
                toReturn = OWLAxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION;
            } else if (assertion.getEvalType() == OWLAxiomType.DATA_PROPERTY_ASSERTION) {
                toReturn = OWLAxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION;
            }
        }
        return toReturn;
    }

    public Type getClassAssertionAxiomType(CommonTree expression, ManchesterOWLSyntaxTree description, ManchesterOWLSyntaxTree subject) {
        OWLAxiomType toReturn = null;
        boolean rightKinds = true;
        if (description.getEvalType() == null || !description.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(description, expression);
            rightKinds = false;
        }
        if (subject.getEvalType() == null || subject.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            this.reportIncompatibleSymbolType(subject, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            toReturn = OWLAxiomType.CLASS_ASSERTION;
        }
        return toReturn;
    }

    public OWLDataFactory getDataFactory() {
        return this.df;
    }

    public OWLObject getOneOf(CommonTree expression, ManchesterOWLSyntaxTree[] individuals) {
        boolean allFine = true;
        OWLObjectOneOf toReturn = null;
        ArrayList<OWLIndividual> individualList = new ArrayList<OWLIndividual>(individuals.length);
        for (ManchesterOWLSyntaxTree individual : individuals) {
            if (individual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
                allFine = false;
                this.reportIncompatibleSymbolType(individual, expression);
                continue;
            }
            individualList.add((OWLIndividual)individual.getOWLObject());
        }
        if (allFine) {
            toReturn = this.df.getOWLObjectOneOf(individualList.toArray(new OWLIndividual[individualList.size()]));
        }
        return toReturn;
    }

    public OWLObject getExactCardinalityRestriction(CommonTree expression, int i, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLDataExactCardinality toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (filler != null && filler.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    OWLDataExactCardinality oWLDataExactCardinality = toReturn = filler == null ? this.df.getOWLDataExactCardinality(i, (OWLDataPropertyExpression)propertyExpression.getOWLObject()) : this.df.getOWLDataExactCardinality(i, (OWLDataPropertyExpression)propertyExpression.getOWLObject(), (OWLDataRange)filler.getOWLObject());
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (filler != null && !filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = filler == null ? this.df.getOWLObjectExactCardinality(i, (OWLObjectPropertyExpression)propertyExpression.getOWLObject()) : this.df.getOWLObjectExactCardinality(i, (OWLObjectPropertyExpression)propertyExpression.getOWLObject(), (OWLClassExpression)filler.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLObject getMaxCardinalityRestriction(CommonTree expression, int cardinality, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLDataMaxCardinality toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (filler != null && filler.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    OWLDataMaxCardinality oWLDataMaxCardinality = toReturn = filler == null ? this.df.getOWLDataMaxCardinality(cardinality, (OWLDataPropertyExpression)propertyExpression.getOWLObject()) : this.df.getOWLDataMaxCardinality(cardinality, (OWLDataPropertyExpression)propertyExpression.getOWLObject(), (OWLDataRange)filler.getOWLObject());
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (filler != null && !filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = filler == null ? this.df.getOWLObjectMaxCardinality(cardinality, (OWLObjectPropertyExpression)propertyExpression.getOWLObject()) : this.df.getOWLObjectMaxCardinality(cardinality, (OWLObjectPropertyExpression)propertyExpression.getOWLObject(), (OWLClassExpression)filler.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLObject getMinCardinalityRestriction(CommonTree expression, int cardinality, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLDataMinCardinality toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (filler != null && filler.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    OWLDataMinCardinality oWLDataMinCardinality = toReturn = filler == null ? this.df.getOWLDataMinCardinality(cardinality, (OWLDataPropertyExpression)propertyExpression.getOWLObject()) : this.df.getOWLDataMinCardinality(cardinality, (OWLDataPropertyExpression)propertyExpression.getOWLObject(), (OWLDataRange)filler.getOWLObject());
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (filler != null && !filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = filler == null ? this.df.getOWLObjectMinCardinality(cardinality, (OWLObjectPropertyExpression)propertyExpression.getOWLObject()) : this.df.getOWLObjectMinCardinality(cardinality, (OWLObjectPropertyExpression)propertyExpression.getOWLObject(), (OWLClassExpression)filler.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLObject getAllValueRestriction(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLDataAllValuesFrom toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (filler.getEvalType() == null || !filler.getEvalType().accept(this.classDetector).booleanValue() && !filler.getEvalType().accept(this.dtDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(filler, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (!filler.getEvalType().accept(this.dtDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)propertyExpression, (OWLDataRange)filler);
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)propertyExpression.getOWLObject(), (OWLClassExpression)filler.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLObject getSomeValueRestriction(CommonTree expression, ManchesterOWLSyntaxTree propertyExpression, ManchesterOWLSyntaxTree filler) {
        OWLDataSomeValuesFrom toReturn = null;
        boolean rightKinds = true;
        if (propertyExpression.getEvalType() == null || !propertyExpression.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(propertyExpression, expression);
            rightKinds = false;
        }
        if (filler.getEvalType() == null || !filler.getEvalType().accept(this.classDetector).booleanValue() && !filler.getEvalType().accept(this.dtDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(filler, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (propertyExpression.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (!filler.getEvalType().accept(this.dtDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)propertyExpression.getOWLObject(), (OWLDataRange)filler.getOWLObject());
                }
            }
            if (propertyExpression.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!filler.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, propertyExpression, filler);
                } else {
                    toReturn = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)propertyExpression.getOWLObject(), (OWLClassExpression)filler.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLObject getInverseProperty(CommonTree expression, ManchesterOWLSyntaxTree property) {
        OWLObjectInverseOf toReturn = null;
        if (property.getEvalType() == null || !property.getEvalType().accept(this.opDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(property, expression);
        } else {
            OWLObjectPropertyExpression owlObject = (OWLObjectPropertyExpression)property.getOWLObject();
            if (owlObject instanceof OWLObjectInverseOf) {
                return owlObject.getNamedProperty();
            }
            toReturn = this.df.getOWLObjectInverseOf(owlObject.asOWLObjectProperty());
        }
        return toReturn;
    }

    public OWLObject getOWLObject(final ManchesterOWLSyntaxTree node) {
        Symbol symbol = this.symbols.get(node.getToken().getText());
        if (symbol == null) {
            symbol = this.getGlobalScope().resolve(node.getToken().getText());
            if (symbol == null && this.getErrorListener() != null) {
                this.reportUnrecognisedSymbol(node);
            } else if (symbol != null) {
                this.symbols.put(node.getToken().getText(), symbol);
            }
        }
        OWLObject toReturn = null;
        if (symbol != null) {
            toReturn = symbol.accept(new SymbolVisitorEx<OWLObject>(){

                @Override
                public OWLEntity visitOWLEntity(OWLEntitySymbol owlEntitySymbol) {
                    return owlEntitySymbol.getEntity();
                }

                @Override
                public OWLLiteral visitOWLLiteral(OWLLiteralSymbol owlConstantSymbol) {
                    return owlConstantSymbol.getOWLLiteral();
                }

                @Override
                public OWLObject visitIRI(IRISymbol iriSymbol) {
                    return iriSymbol.getIRI();
                }

                @Override
                public OWLEntity visitSymbol(Symbol s) {
                    SymbolTable.this.reportIncompatibleSymbolType(node, s.getType(), node);
                    return null;
                }
            });
        }
        return toReturn;
    }

    protected void reportUnrecognisedSymbol(ManchesterOWLSyntaxTree node) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().unrecognisedSymbol(node);
        }
    }

    public OWLObject getNegatedClassExpression(CommonTree expression, ManchesterOWLSyntaxTree node) {
        OWLObjectComplementOf toReturn = null;
        if (node.getEvalType() == null || !node.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(node, expression);
        } else {
            toReturn = this.df.getOWLObjectComplementOf((OWLClassExpression)node.getOWLObject());
        }
        return toReturn;
    }

    public OWLLiteral getOWLTypedConstant(final CommonTree expression, final ManchesterOWLSyntaxTree value, final ManchesterOWLSyntaxTree constantType) {
        Symbol typeSymbol = this.resolve(constantType);
        OWLLiteral toReturn = null;
        if (typeSymbol != null) {
            toReturn = typeSymbol.accept(new SymbolVisitorEx<OWLLiteral>(){

                @Override
                public OWLLiteral visitSymbol(Symbol symbol) {
                    SymbolTable.this.reportIncompatibleSymbolType(constantType, expression);
                    return null;
                }

                @Override
                public OWLLiteral visitOWLLiteral(OWLLiteralSymbol owlConstantSymbol) {
                    SymbolTable.this.reportIncompatibleSymbolType(constantType, expression);
                    return null;
                }

                @Override
                public OWLLiteral visitIRI(IRISymbol iriSymbol) {
                    return null;
                }

                @Override
                public OWLLiteral visitOWLEntity(OWLEntitySymbol owlEntitySymbol) {
                    if (owlEntitySymbol.getType() == OWLType.OWL_DATA_TYPE) {
                        return SymbolTable.this.df.getOWLLiteral(value.getToken().getText(), (OWLDatatype)owlEntitySymbol.getEntity());
                    }
                    return null;
                }
            });
        } else {
            this.errorListener.illegalToken(constantType, "The type is not amongst the available ones");
        }
        return toReturn;
    }

    public OWLLiteral getOWLUntypedConstant(ManchesterOWLSyntaxTree value, ManchesterOWLSyntaxTree lang) {
        return value == null ? null : (lang == null ? this.df.getOWLLiteral(value.getText()) : this.df.getOWLLiteral(value.getText(), lang.getText()));
    }

    public OWLObject getConjunction(CommonTree expression, ManchesterOWLSyntaxTree[] conjuncts) {
        boolean allFine = true;
        Object toReturn = null;
        ArrayList<OWLClassExpression> conjunctList = new ArrayList<OWLClassExpression>(conjuncts.length);
        ArrayList<OWLDataRange> owlDataRangeList = new ArrayList<OWLDataRange>(conjuncts.length);
        Type rest = null;
        for (ManchesterOWLSyntaxTree conjunct : conjuncts) {
            if (conjunct.getEvalType() == null || !this.isNAryDescriptionCompatible(rest, conjunct.getEvalType())) {
                allFine = false;
                this.reportIncompatibleSymbolType(conjunct, expression);
                continue;
            }
            Type type = rest = rest == null ? conjunct.getEvalType() : rest;
            if (rest == null) continue;
            if (rest.accept(this.classDetector).booleanValue()) {
                conjunctList.add((OWLClassExpression)conjunct.getOWLObject());
                continue;
            }
            owlDataRangeList.add((OWLDataRange)conjunct.getOWLObject());
        }
        if (allFine && rest != null) {
            toReturn = rest.accept(this.classDetector) != false ? this.df.getOWLObjectIntersectionOf(conjunctList.toArray(new OWLClassExpression[conjunctList.size()])) : this.df.getOWLDataIntersectionOf(owlDataRangeList.toArray(new OWLDataRange[owlDataRangeList.size()]));
        }
        return toReturn;
    }

    public OWLPropertyChain getPropertyChain(CommonTree expression, ManchesterOWLSyntaxTree[] chainItems) {
        boolean allFine;
        OWLPropertyChain toReturn = null;
        boolean bl = allFine = chainItems.length >= 2;
        if (allFine) {
            ArrayList<OWLObjectPropertyExpression> items = new ArrayList<OWLObjectPropertyExpression>(chainItems.length);
            for (ManchesterOWLSyntaxTree item : chainItems) {
                if (item.getEvalType() == null || !item.getEvalType().accept(this.opDetector).booleanValue()) {
                    allFine = false;
                    this.reportIncompatibleSymbolType(item, expression);
                    continue;
                }
                items.add((OWLObjectPropertyExpression)item.getOWLObject());
            }
            if (allFine) {
                toReturn = items.size() > 2 ? this.createOWLPropertyChain((OWLObjectPropertyExpression)items.get(0), (OWLObjectPropertyExpression)items.get(1), items.subList(2, items.size()).toArray(new OWLObjectPropertyExpression[items.size()])) : this.createOWLPropertyChain((OWLObjectPropertyExpression)items.get(0), (OWLObjectPropertyExpression)items.get(1), new OWLObjectPropertyExpression[0]);
            }
        } else {
            this.reportIllegalToken(expression, "The property chain contain at least two elements, in fact it contains " + chainItems.length);
        }
        return toReturn;
    }

    protected OWLPropertyChain createOWLPropertyChain(OWLObjectPropertyExpression firstPropertyExpression, OWLObjectPropertyExpression secondPropertyExpression, OWLObjectPropertyExpression ... others) {
        ArrayList<OWLObjectPropertyExpression> a = new ArrayList<OWLObjectPropertyExpression>(Arrays.asList(others));
        a.add(0, secondPropertyExpression);
        a.add(0, firstPropertyExpression);
        return new OWLPropertyChainImpl(a);
    }

    public OWLObject getDisjunction(CommonTree expression, ManchesterOWLSyntaxTree[] disjuncts) {
        boolean allFine = true;
        Object toReturn = null;
        ArrayList<OWLClassExpression> disjunctList = new ArrayList<OWLClassExpression>(disjuncts.length);
        ArrayList<OWLDataRange> owlDataRangeList = new ArrayList<OWLDataRange>(disjuncts.length);
        Type rest = null;
        for (ManchesterOWLSyntaxTree disjunct : disjuncts) {
            if (disjunct.getEvalType() == null || !this.isNAryDescriptionCompatible(rest, disjunct.getEvalType())) {
                allFine = false;
                this.reportIncompatibleSymbolType(disjunct, expression);
                continue;
            }
            Type type = rest = rest == null ? disjunct.getEvalType() : rest;
            if (rest == null) continue;
            if (rest.accept(this.classDetector).booleanValue()) {
                disjunctList.add((OWLClassExpression)disjunct.getOWLObject());
                continue;
            }
            owlDataRangeList.add((OWLDataRange)disjunct.getOWLObject());
        }
        if (allFine && rest != null) {
            toReturn = rest.accept(this.classDetector) != false ? this.df.getOWLObjectUnionOf(disjunctList.toArray(new OWLClassExpression[disjunctList.size()])) : this.df.getOWLDataUnionOf(owlDataRangeList.toArray(new OWLDataRange[owlDataRangeList.size()]));
        }
        return toReturn;
    }

    public OWLAxiom getNegatedAssertion(CommonTree expression, ManchesterOWLSyntaxTree assertion) {
        OWLNegativeObjectPropertyAssertionAxiom toReturn = null;
        boolean rightKinds = true;
        if (assertion.getEvalType() == null || !assertion.getEvalType().accept(this.simpleAssertionDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(assertion, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (assertion.getEvalType() == OWLAxiomType.OBJECT_PROPERTY_ASSERTION) {
                OWLObjectPropertyAssertionAxiom owlObjectPropertyAssertionAxiom = (OWLObjectPropertyAssertionAxiom)assertion.getOWLObject();
                toReturn = this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)owlObjectPropertyAssertionAxiom.getProperty(), owlObjectPropertyAssertionAxiom.getSubject(), (OWLIndividual)owlObjectPropertyAssertionAxiom.getObject());
            } else if (assertion.getEvalType() == OWLAxiomType.DATA_PROPERTY_ASSERTION) {
                OWLDataPropertyAssertionAxiom owlObjectPropertyAssertionAxiom = (OWLDataPropertyAssertionAxiom)assertion.getOWLObject();
                toReturn = this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)owlObjectPropertyAssertionAxiom.getProperty(), owlObjectPropertyAssertionAxiom.getSubject(), (OWLLiteral)owlObjectPropertyAssertionAxiom.getObject());
            }
        }
        return toReturn;
    }

    public OWLAxiom getTransitiveProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject());
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public OWLAxiom getSymmetricProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject());
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public OWLAxiom getAsymmetricProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject());
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public OWLAxiom getReflexiveProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject());
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public OWLAxiom getIrreflexiveProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject());
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public OWLAxiom getInverseFunctionalProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        if (OWLType.OWL_OBJECT_PROPERTY.match(p.getEvalType())) {
            return this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject());
        }
        this.reportIncompatibleSymbolType(p, expression);
        return null;
    }

    public OWLAxiom getFunctionalProperty(CommonTree expression, ManchesterOWLSyntaxTree p) {
        OWLFunctionalObjectPropertyAxiom toReturn = null;
        boolean rightKinds = true;
        if (p.getEvalType() == null || p.getEvalType() != OWLType.OWL_OBJECT_PROPERTY && p.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(p, expression);
        }
        if (rightKinds) {
            toReturn = p.getEvalType() == OWLType.OWL_OBJECT_PROPERTY ? this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p.getOWLObject()) : this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p.getOWLObject());
        }
        return toReturn;
    }

    public OWLAxiom getDifferentIndividualsAxiom(CommonTree expression, ManchesterOWLSyntaxTree anIndividual, ManchesterOWLSyntaxTree anotherIndividual) {
        OWLDifferentIndividualsAxiom toReturn = null;
        boolean rightKinds = true;
        if (anIndividual.getEvalType() == null || anIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anIndividual, expression);
        }
        if (anotherIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anotherIndividual, expression);
        }
        if (rightKinds) {
            toReturn = this.df.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{(OWLIndividual)anIndividual.getOWLObject(), (OWLIndividual)anotherIndividual.getOWLObject()});
        }
        return toReturn;
    }

    public OWLAxiom getSameIndividualsAxiom(CommonTree expression, ManchesterOWLSyntaxTree anIndividual, ManchesterOWLSyntaxTree anotherIndividual) {
        OWLSameIndividualAxiom toReturn = null;
        boolean rightKinds = true;
        if (anIndividual.getEvalType() == null || anIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anIndividual, expression);
        }
        if (anotherIndividual.getEvalType() == null || anotherIndividual.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(anotherIndividual, expression);
        }
        if (rightKinds) {
            toReturn = this.df.getOWLSameIndividualAxiom(new OWLIndividual[]{(OWLIndividual)anIndividual.getOWLObject(), (OWLIndividual)anotherIndividual.getOWLObject()});
        }
        return toReturn;
    }

    public OWLAxiom getRangeAxiom(CommonTree expression, ManchesterOWLSyntaxTree p, ManchesterOWLSyntaxTree range) {
        OWLObjectPropertyRangeAxiom toReturn = null;
        boolean rightKinds = true;
        if (p.getEvalType() == null || p.getEvalType() != OWLType.OWL_OBJECT_PROPERTY && p.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
            this.reportIncompatibleSymbolType(p, expression);
            rightKinds = false;
        }
        if (range.getEvalType() == null || !range.getEvalType().accept(this.classDetector).booleanValue() && range.getEvalType() != OWLType.OWL_DATA_TYPE) {
            this.reportIncompatibleSymbolType(range, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (p.getEvalType() == OWLType.OWL_OBJECT_PROPERTY) {
                if (!range.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, p, range);
                } else {
                    toReturn = this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)p.getOWLObject(), (OWLClassExpression)range.getOWLObject());
                }
            } else if (p.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (range.getEvalType() != OWLType.OWL_DATA_TYPE) {
                    this.reportIncompatibleSymbols(expression, p, range);
                } else {
                    toReturn = this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)p.getOWLObject(), (OWLDataRange)range.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLAxiom getDomainAxiom(CommonTree expression, ManchesterOWLSyntaxTree p, ManchesterOWLSyntaxTree domain) {
        OWLObjectPropertyDomainAxiom toReturn = null;
        boolean rightKinds = true;
        if (p.getEvalType() == null || p.getEvalType() != OWLType.OWL_OBJECT_PROPERTY && p.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
            this.reportIncompatibleSymbolType(p, expression);
            rightKinds = false;
        }
        if (domain.getEvalType() == null || !domain.getEvalType().accept(this.classDetector).booleanValue() && domain.getEvalType() != OWLType.OWL_DATA_TYPE) {
            this.reportIncompatibleSymbolType(domain, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (p.getEvalType() == OWLType.OWL_OBJECT_PROPERTY) {
                if (!domain.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, p, domain);
                } else {
                    toReturn = this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p.getOWLObject(), (OWLClassExpression)domain.getOWLObject());
                }
            } else if (p.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (!domain.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, p, domain);
                } else {
                    toReturn = this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)p.getOWLObject(), (OWLClassExpression)domain.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLAxiom getClassAssertionAxiom(CommonTree expression, ManchesterOWLSyntaxTree description, ManchesterOWLSyntaxTree subject) {
        OWLClassAssertionAxiom toReturn = null;
        boolean rightKinds = true;
        if (description.getEvalType() == null || !description.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(description, expression);
            rightKinds = false;
        }
        if (subject.getEvalType() == null || subject.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            this.reportIncompatibleSymbolType(subject, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            toReturn = this.df.getOWLClassAssertionAxiom((OWLClassExpression)description.getOWLObject(), (OWLIndividual)subject.getOWLObject());
        }
        return toReturn;
    }

    public OWLAxiom getRoleAssertionAxiom(CommonTree expression, ManchesterOWLSyntaxTree subject, ManchesterOWLSyntaxTree property, ManchesterOWLSyntaxTree object) {
        OWLObjectPropertyAssertionAxiom toReturn = null;
        boolean rightKinds = true;
        if (subject.getEvalType() == null || subject.getEvalType() != OWLType.OWL_INDIVIDUAL) {
            this.reportIncompatibleSymbolType(subject, expression);
            rightKinds = false;
        }
        if (property.getEvalType() == null || !property.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(property, expression);
            rightKinds = false;
        }
        if (object.getEvalType() == null || object.getEvalType() != OWLType.OWL_INDIVIDUAL && object.getEvalType() != OWLType.OWL_CONSTANT) {
            this.reportIncompatibleSymbolType(object, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (property.getEvalType().accept(this.opDetector).booleanValue()) {
                if (object.getEvalType() != OWLType.OWL_INDIVIDUAL) {
                    this.reportIncompatibleSymbols(expression, property, object);
                } else {
                    toReturn = this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)property.getOWLObject(), (OWLIndividual)subject.getOWLObject(), (OWLIndividual)object.getOWLObject());
                }
            } else if (property.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (object.getEvalType() != OWLType.OWL_CONSTANT) {
                    this.reportIncompatibleSymbols(expression, property, object);
                } else {
                    toReturn = this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)property.getOWLObject(), (OWLIndividual)subject.getOWLObject(), (OWLLiteral)object.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLAxiom getSubPropertyAxiom(CommonTree expression, ManchesterOWLSyntaxTree subProperty, ManchesterOWLSyntaxTree superProperty) {
        boolean areChildrenCompatible;
        OWLSubPropertyChainOfAxiom toReturn = null;
        boolean rightKinds = true;
        if (subProperty.getEvalType() == null || !subProperty.getEvalType().accept(this.pDetector).booleanValue() && subProperty.getEvalType() != OWLType.OWL_PROPERTY_CHAIN) {
            this.reportIncompatibleSymbolType(subProperty, expression);
            rightKinds = false;
        }
        if (superProperty.getEvalType() == null || !superProperty.getEvalType().accept(this.pDetector).booleanValue()) {
            rightKinds = false;
            this.reportIncompatibleSymbolType(superProperty, expression);
        }
        boolean bl = areChildrenCompatible = subProperty.getEvalType() == superProperty.getEvalType() || subProperty.getEvalType() == OWLType.OWL_PROPERTY_CHAIN && superProperty.getEvalType() == OWLType.OWL_OBJECT_PROPERTY;
        if (rightKinds && areChildrenCompatible) {
            if (areChildrenCompatible) {
                OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom = toReturn = subProperty.getEvalType() == OWLType.OWL_PROPERTY_CHAIN ? this.df.getOWLSubPropertyChainOfAxiom(((OWLPropertyChain)subProperty.getOWLObject()).list(), (OWLObjectPropertyExpression)superProperty.getOWLObject()) : toReturn;
                if (toReturn == null) {
                    toReturn = subProperty.getEvalType().accept(this.opDetector) != false ? this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)subProperty.getOWLObject(), (OWLObjectPropertyExpression)superProperty.getOWLObject()) : this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)subProperty.getOWLObject(), (OWLDataPropertyExpression)superProperty.getOWLObject());
                }
            } else {
                this.reportIncompatibleSymbols(expression, subProperty, superProperty);
            }
        } else {
            this.reportIncompatibleSymbols(expression, subProperty, superProperty);
        }
        return toReturn;
    }

    public OWLAxiom getDisjointAxiom(CommonTree expression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        OWLDisjointClassesAxiom toReturn = null;
        boolean rightKinds = true;
        if (lhs.getEvalType() == null || !lhs.getEvalType().accept(this.classDetector).booleanValue() && !lhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(lhs, expression);
            rightKinds = false;
        }
        if (rhs.getEvalType() == null || !rhs.getEvalType().accept(this.classDetector).booleanValue() && !rhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(rhs, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (lhs.getEvalType().accept(this.classDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)lhs.getOWLObject(), (OWLClassExpression)rhs.getOWLObject()});
                }
            } else if (lhs.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.opDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = this.df.getOWLDisjointObjectPropertiesAxiom(new OWLObjectPropertyExpression[]{(OWLObjectPropertyExpression)lhs.getOWLObject(), (OWLObjectPropertyExpression)rhs.getOWLObject()});
                }
            } else if (lhs.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (rhs.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = this.df.getOWLDisjointDataPropertiesAxiom(new OWLDataPropertyExpression[]{(OWLDataPropertyExpression)lhs.getOWLObject(), (OWLDataPropertyExpression)rhs.getOWLObject()});
                }
            }
        }
        return toReturn;
    }

    public OWLAxiom getInverseOfAxiom(CommonTree expression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        OWLInverseObjectPropertiesAxiom toReturn = null;
        boolean rightKinds = true;
        if (lhs.getEvalType() == null || !lhs.getEvalType().accept(this.opDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(lhs, expression);
            rightKinds = false;
        }
        if (rhs.getEvalType() == null || !rhs.getEvalType().accept(this.opDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(rhs, expression);
            rightKinds = false;
        }
        if (rightKinds && lhs.getEvalType().accept(this.opDetector).booleanValue()) {
            if (!rhs.getEvalType().accept(this.opDetector).booleanValue()) {
                this.reportIncompatibleSymbols(expression, lhs, rhs);
            } else {
                toReturn = this.df.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)lhs.getOWLObject(), (OWLObjectPropertyExpression)rhs.getOWLObject());
            }
        }
        return toReturn;
    }

    public OWLAxiom getEquivalentAxiom(CommonTree expression, ManchesterOWLSyntaxTree lhs, ManchesterOWLSyntaxTree rhs) {
        OWLEquivalentClassesAxiom toReturn = null;
        boolean rightKinds = true;
        if (lhs.getEvalType() == null || !lhs.getEvalType().accept(this.classDetector).booleanValue() && !lhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(lhs, expression);
            rightKinds = false;
        }
        if (rhs.getEvalType() == null || !rhs.getEvalType().accept(this.classDetector).booleanValue() && !rhs.getEvalType().accept(this.pDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(rhs, expression);
            rightKinds = false;
        }
        if (rightKinds) {
            if (lhs.getEvalType().accept(this.classDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.classDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)lhs.getOWLObject(), (OWLClassExpression)rhs.getOWLObject());
                }
            } else if (lhs.getEvalType().accept(this.opDetector).booleanValue()) {
                if (!rhs.getEvalType().accept(this.opDetector).booleanValue()) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = this.df.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)lhs.getOWLObject(), (OWLObjectPropertyExpression)rhs.getOWLObject());
                }
            } else if (lhs.getEvalType() == OWLType.OWL_DATA_PROPERTY) {
                if (rhs.getEvalType() != OWLType.OWL_DATA_PROPERTY) {
                    this.reportIncompatibleSymbols(expression, lhs, rhs);
                } else {
                    toReturn = this.df.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)lhs.getOWLObject(), (OWLDataPropertyExpression)rhs.getOWLObject());
                }
            }
        }
        return toReturn;
    }

    public OWLAxiom getSubClassAxiom(CommonTree expression, ManchesterOWLSyntaxTree subClass, ManchesterOWLSyntaxTree superClass) {
        OWLSubClassOfAxiom toReturn = null;
        if (subClass.getEvalType() == null || !subClass.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(subClass, expression);
        } else if (superClass.getEvalType() == null || !superClass.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIncompatibleSymbolType(superClass, expression);
        } else {
            toReturn = this.df.getOWLSubClassOfAxiom((OWLClassExpression)subClass.getOWLObject(), (OWLClassExpression)superClass.getOWLObject());
        }
        return toReturn;
    }

    public Set<String> match(String prefix) {
        return OWLAPIStreamUtils.asSet(this.getGlobalScope().match(prefix).stream().map(Symbol::getName));
    }

    public Set<String> getOWLObjectPropertyCompletions() {
        return this.getAllCompletions(OWLType.OWL_OBJECT_PROPERTY);
    }

    public Set<String> getOWLDataPropertyCompletions() {
        return this.getAllCompletions(OWLType.OWL_DATA_PROPERTY);
    }

    public Set<String> getOWLClassCompletions() {
        return this.getAllCompletions(OWLType.OWL_CLASS);
    }

    public Set<String> getCompletions(Type type) {
        HashSet<String> toReturn = new HashSet<String>();
        if (OWLType.isClassExpression(type)) {
            toReturn.addAll(this.getOWLClassCompletions());
        }
        if (OWLType.isObjectPropertyExpression(type)) {
            toReturn.addAll(this.getOWLObjectPropertyCompletions());
        }
        if (OWLType.OWL_DATA_PROPERTY == type) {
            toReturn.addAll(this.getOWLDataPropertyCompletions());
        }
        if (OWLType.OWL_INDIVIDUAL == type) {
            toReturn.addAll(this.getOWLIndividualCompletions());
        }
        return toReturn;
    }

    public Set<String> getOWLPropertyCompletions(Type type) {
        HashSet<String> toReturn = new HashSet<String>();
        if (OWLType.isObjectPropertyExpression(type)) {
            toReturn.addAll(this.getOWLObjectPropertyCompletions());
        }
        if (OWLType.OWL_DATA_PROPERTY == type) {
            toReturn.addAll(this.getOWLDataPropertyCompletions());
        }
        return toReturn;
    }

    public Set<String> getOWLIndividualCompletions() {
        return this.getAllCompletions(OWLType.OWL_INDIVIDUAL);
    }

    public Set<String> getAllCompletions(Type ... types) {
        HashSet<String> toReturn = new HashSet<String>();
        for (Type type : types) {
            OWLAPIStreamUtils.add(toReturn, this.getGlobalScope().getAllSymbols(type).stream().map(Symbol::getName));
        }
        return toReturn;
    }

    protected void storeSymbol(Token token, Symbol symbol) {
        this.symbols.put(ArgCheck.checkNotNull(token, "token").getText(), ArgCheck.checkNotNull(symbol, "symbol"));
    }

    protected void storeSymbol(String name, Symbol symbol) {
        this.symbols.put(ArgCheck.checkNotNull(name, "name"), ArgCheck.checkNotNull(symbol, "symbol"));
    }

    protected Symbol removeSymbol(Token token) {
        return this.symbols.remove(token.getText());
    }

    @Deprecated
    public Set<Symbol> getDefinedSymbols() {
        return new HashSet<Symbol>(this.symbols.values());
    }

    public Stream<Symbol> definedSymbols() {
        return this.symbols.values().stream();
    }

    public void dispose() {
        this.getGlobalScope().dispose();
    }

    public OWLType getOWLFacetRestrictionType(ManchesterOWLSyntaxTree facet, ManchesterOWLSyntaxTree value, CommonTree parentExpression) {
        OWLType toReturn = null;
        OWLFacet facetByShortName = OWLFacet.getFacetBySymbolicName((String)facet.getText());
        if (facetByShortName == null) {
            this.reportIllegalToken(facet, "Invalid facet token");
        } else if (value.getEvalType() != OWLType.OWL_CONSTANT) {
            this.reportIncompatibleSymbolType(value, parentExpression);
        } else {
            toReturn = OWLType.OWL_DATA_FACET;
        }
        return toReturn;
    }

    public OWLFacetRestriction getOWLFacetRestriction(ManchesterOWLSyntaxTree facet, ManchesterOWLSyntaxTree value, CommonTree parentExpression) {
        OWLFacetRestriction toReturn = null;
        OWLFacet facetByShortName = OWLFacet.getFacetBySymbolicName((String)facet.getText());
        if (facetByShortName == null) {
            this.reportIllegalToken(facet, "Invalid facet token");
        } else if (value.getEvalType() != OWLType.OWL_CONSTANT) {
            this.reportIncompatibleSymbolType(value, parentExpression);
        } else {
            toReturn = this.df.getOWLFacetRestriction(facetByShortName, (OWLLiteral)value.getOWLObject());
        }
        return toReturn;
    }

    public OWLType getOWLDataRangeType(ManchesterOWLSyntaxTree dataType, ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree ... facets) {
        OWLType toReturn = null;
        if (dataType.getEvalType() != OWLType.OWL_DATA_TYPE) {
            this.reportIncompatibleSymbolType(dataType, parentExpression);
        } else {
            boolean allFine = true;
            for (ManchesterOWLSyntaxTree facet : facets) {
                if (facet == null || facet.getOWLObject() == null) {
                    allFine = false;
                    this.reportIllegalToken(facet, "NUll facet ");
                    continue;
                }
                if (facet.getEvalType() == OWLType.OWL_DATA_FACET && facet.getOWLObject() instanceof OWLFacetRestriction) continue;
                allFine = false;
                this.reportIncompatibleSymbolType(facet, parentExpression);
            }
            if (allFine) {
                toReturn = OWLType.OWL_DATA_TYPE_RESTRICTION;
            }
        }
        return toReturn;
    }

    public OWLDatatypeRestriction getOWLDataRange(ManchesterOWLSyntaxTree dataType, ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree ... facets) {
        OWLDatatypeRestriction toReturn = null;
        if (dataType.getEvalType() != OWLType.OWL_DATA_TYPE) {
            this.reportIncompatibleSymbolType(dataType, parentExpression);
        } else {
            HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>(facets.length);
            boolean allFine = true;
            for (ManchesterOWLSyntaxTree facet : facets) {
                if (facet == null || facet.getOWLObject() == null) {
                    allFine = false;
                    this.reportIllegalToken(facet, "NUll facet ");
                    continue;
                }
                if (facet.getEvalType() != OWLType.OWL_DATA_FACET || !(facet.getOWLObject() instanceof OWLFacetRestriction)) {
                    allFine = false;
                    this.reportIncompatibleSymbolType(facet, parentExpression);
                    continue;
                }
                facetRestrictions.add((OWLFacetRestriction)facet.getOWLObject());
            }
            if (allFine) {
                toReturn = this.df.getOWLDatatypeRestriction((OWLDatatype)dataType.getOWLObject(), facetRestrictions);
            }
        }
        return toReturn;
    }

    public Type getHasKeyType(ManchesterOWLSyntaxTree node, Set<ManchesterOWLSyntaxTree> propertyExpressions) {
        OWLAxiomType toReturn = null;
        if (node.getEvalType() == null || !node.getEvalType().accept(this.classDetector).booleanValue()) {
            this.reportIllegalToken(node, "A class expression is expected here");
        } else {
            boolean allFine = true;
            Iterator<ManchesterOWLSyntaxTree> iterator = propertyExpressions.iterator();
            while (allFine && iterator.hasNext()) {
                ManchesterOWLSyntaxTree propertyNode = iterator.next();
                allFine = propertyNode.getEvalType() != null && propertyNode.getEvalType().accept(this.pDetector) != false;
            }
            if (allFine) {
                toReturn = OWLAxiomType.HAS_KEY;
            }
        }
        return toReturn;
    }

    public OWLHasKeyAxiom getHasKey(ManchesterOWLSyntaxTree node, Set<ManchesterOWLSyntaxTree> propertyExpressions) {
        OWLHasKeyAxiom toReturn = null;
        OWLClassExpression ce = null;
        if (node.getEvalType() == null || !node.getEvalType().accept(this.classDetector).booleanValue() || node.getOWLObject() == null) {
            this.reportIllegalToken(node, "A class expression is expected here");
        } else {
            ce = (OWLClassExpression)node.getOWLObject();
            boolean allFine = true;
            Iterator<ManchesterOWLSyntaxTree> iterator = propertyExpressions.iterator();
            HashSet<OWLPropertyExpression> pes = new HashSet<OWLPropertyExpression>();
            while (allFine && iterator.hasNext()) {
                ManchesterOWLSyntaxTree propertyNode = iterator.next();
                allFine = propertyNode.getEvalType() != null && propertyNode.getEvalType().accept(this.pDetector) != false && propertyNode.getOWLObject() != null;
                if (!allFine) continue;
                pes.add((OWLPropertyExpression)propertyNode.getOWLObject());
            }
            if (allFine) {
                toReturn = this.df.getOWLHasKeyAxiom(ce, pes);
            }
        }
        return toReturn;
    }

    public Type getAnnotationAssertionType(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree iri, ManchesterOWLSyntaxTree annotationPropertyNode, ManchesterOWLSyntaxTree object) {
        OWLAxiomType toReturn = null;
        Symbol test = this.retrieveSymbol(iri.getText());
        IRI subjectIRI = this.getIRI(test, iri, parentExpression);
        if (subjectIRI != null) {
            this.storeSymbol(iri.getToken(), (Symbol)new IRISymbol(iri.getText(), subjectIRI));
        }
        if (subjectIRI == null) {
            this.reportIllegalToken(iri, "Illegal IRI");
        } else if (annotationPropertyNode.getEvalType() == null || annotationPropertyNode.getEvalType() != OWLType.OWL_ANNOTATION_PROPERTY) {
            this.reportIncompatibleSymbolType(annotationPropertyNode, parentExpression);
        } else if (object.getEvalType() == null || !object.getEvalType().accept(this.annDetector).booleanValue()) {
            this.reportIncompatibleSymbols(parentExpression, object);
        } else {
            toReturn = OWLAxiomType.ANNOTATION_ASSERTION;
        }
        return toReturn;
    }

    IRI getIRI(Symbol test, final ManchesterOWLSyntaxTree iri, final ManchesterOWLSyntaxTree parentExpression) {
        return test == null ? IRI.create((String)iri.getText()) : test.accept(new SymbolVisitorEx<IRI>(){

            @Override
            public IRI visitSymbol(Symbol s) {
                SymbolTable.this.reportIncompatibleSymbolType(iri, s.getType(), parentExpression);
                return null;
            }

            @Override
            public IRI visitOWLLiteral(OWLLiteralSymbol c) {
                SymbolTable.this.reportIncompatibleSymbolType(iri, c.getType(), parentExpression);
                return null;
            }

            @Override
            public IRI visitOWLEntity(OWLEntitySymbol e) {
                SymbolTable.this.reportIncompatibleSymbolType(iri, e.getType(), parentExpression);
                return null;
            }

            @Override
            public IRI visitIRI(IRISymbol iriSymbol) {
                return iriSymbol.getIRI();
            }
        });
    }

    public OWLAnnotationAssertionAxiom getAnnotationAssertion(ManchesterOWLSyntaxTree parentExpression, ManchesterOWLSyntaxTree iri, final ManchesterOWLSyntaxTree annotationPropertyNode, ManchesterOWLSyntaxTree object) {
        OWLAnnotationAssertionAxiom toReturn = null;
        Symbol test = this.resolve(iri);
        IRI subjectIRI = this.getIRI(test, iri, parentExpression);
        if (subjectIRI == null) {
            this.reportIllegalToken(iri, "Illegal IRI");
        } else if (annotationPropertyNode.getEvalType() == null || annotationPropertyNode.getEvalType() != OWLType.OWL_ANNOTATION_PROPERTY) {
            this.reportIncompatibleSymbolType(annotationPropertyNode, parentExpression);
        } else if (annotationPropertyNode.getOWLObject() == null) {
            this.reportIllegalToken(annotationPropertyNode, "Invalid annotation property");
        } else if (object.getEvalType() == null || !object.getEvalType().accept(this.annDetector).booleanValue()) {
            this.reportIncompatibleSymbols(parentExpression, object);
        } else if (object.getOWLObject() == null) {
            this.reportIllegalToken(object, "Invalid object");
        } else {
            OWLAnnotation annotation = (OWLAnnotation)object.getOWLObject().accept((OWLObjectVisitorEx)new OWLObjectVisitorEx<OWLAnnotation>(){

                public OWLAnnotation visit(IRI i) {
                    return SymbolTable.this.df.getOWLAnnotation((OWLAnnotationProperty)annotationPropertyNode.getOWLObject(), (OWLAnnotationValue)i);
                }

                public OWLAnnotation visit(OWLLiteral literal) {
                    return SymbolTable.this.df.getOWLAnnotation((OWLAnnotationProperty)annotationPropertyNode.getOWLObject(), (OWLAnnotationValue)literal);
                }
            });
            toReturn = this.df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)subjectIRI, annotation);
        }
        return toReturn;
    }

    public Symbol resolveIRI(ManchesterOWLSyntaxTree node) {
        Symbol toReturn = this.retrieveSymbol(node.getText());
        if (toReturn == null) {
            String name = node.getToken().getText();
            if (!name.isEmpty()) {
                IRI iri = IRI.create((String)node.getText());
                toReturn = new IRISymbol(name, iri);
            }
            this.symbols.put(name, toReturn);
        }
        return toReturn;
    }

    private static abstract class OWLAxiomTypeOnlyVisitor
    implements TypeVisitorEx<Boolean> {
        @Override
        public Boolean visitOWLType(OWLType owlType) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitNonOWLType(Type type) {
            return Boolean.FALSE;
        }
    }

    private static abstract class OWLTypeOnlyVisitor
    implements TypeVisitorEx<Boolean> {
        @Override
        public Boolean visitOWLAxiomType(OWLAxiomType owlAxiomType) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitNonOWLType(Type type) {
            return Boolean.FALSE;
        }
    }
}

