/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.OWLEntityRenderer;
import org.coode.parsers.OWLEntityRenderingCache;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLEntityRenderingCacheImpl
implements OWLEntityRenderingCache {
    protected Map<String, OWLClass> owlClassMap = new HashMap<String, OWLClass>();
    protected Map<String, OWLObjectProperty> owlObjectPropertyMap = new HashMap<String, OWLObjectProperty>();
    protected Map<String, OWLDataProperty> owlDataPropertyMap = new HashMap<String, OWLDataProperty>();
    protected Map<String, OWLNamedIndividual> owlIndividualMap = new HashMap<String, OWLNamedIndividual>();
    protected Map<String, OWLDatatype> owlDatatypeMap = new HashMap<String, OWLDatatype>();
    protected Map<String, OWLAnnotationProperty> owlAnnotationPropertyMap = new HashMap<String, OWLAnnotationProperty>();
    protected Map<OWLEntity, String> entityRenderingMap = new HashMap<OWLEntity, String>();
    protected final OWLOntologyManager manager;
    protected final OWLEntityRenderer entityRenderer;
    protected OWLOntologyChangeListener listener = this::processChanges;

    public OWLEntityRenderingCacheImpl(OWLOntologyManager manager, OWLEntityRenderer entityRenderer) {
        this.manager = ArgCheck.checkNotNull(manager, "manager");
        this.entityRenderer = ArgCheck.checkNotNull(entityRenderer, "entityRenderer");
        this.manager.addOntologyChangeListener(this.listener);
        this.rebuild();
    }

    protected void processChanges(List<? extends OWLOntologyChange> changes) {
        changes.stream().filter(OWLOntologyChange::isAxiomChange).map(c -> (OWLAxiomChange)c).flatMap(OWLAxiomChange::signature).forEach(this::updateRendering);
    }

    @Override
    public void rebuild() {
        this.clear();
        OWLClass thing = this.manager.getOWLDataFactory().getOWLThing();
        this.owlClassMap.put(this.entityRenderer.render((OWLEntity)thing), thing);
        this.entityRenderingMap.put((OWLEntity)thing, this.entityRenderer.render((OWLEntity)thing));
        OWLClass nothing = this.manager.getOWLDataFactory().getOWLNothing();
        this.entityRenderingMap.put((OWLEntity)nothing, this.entityRenderer.render((OWLEntity)nothing));
        this.owlClassMap.put(this.entityRenderer.render((OWLEntity)nothing), nothing);
        this.manager.ontologies().forEach(ont -> {
            ont.classesInSignature().forEach(cls -> this.addRendering((OWLEntity)cls, (Map)this.owlClassMap));
            ont.objectPropertiesInSignature().forEach(prop -> this.addRendering((OWLEntity)prop, (Map)this.owlObjectPropertyMap));
            ont.dataPropertiesInSignature().forEach(prop -> this.addRendering((OWLEntity)prop, (Map)this.owlDataPropertyMap));
            ont.individualsInSignature().forEach(ind -> this.addRendering((OWLEntity)ind, (Map)this.owlIndividualMap));
        });
        EnumSet<OWL2Datatype> allDataTypes = EnumSet.allOf(OWL2Datatype.class);
        for (OWL2Datatype dt : allDataTypes) {
            OWLDatatype owlDatatype = this.manager.getOWLDataFactory().getOWLDatatype(dt.getIRI());
            this.addRendering(owlDatatype, this.owlDatatypeMap);
        }
    }

    public void dispose() {
        this.clear();
        this.manager.removeOntologyChangeListener(this.listener);
    }

    private void clear() {
        this.owlClassMap.clear();
        this.owlObjectPropertyMap.clear();
        this.owlDataPropertyMap.clear();
        this.owlIndividualMap.clear();
        this.owlDatatypeMap.clear();
        this.entityRenderingMap.clear();
    }

    @Override
    public OWLClass getOWLClass(String rendering) {
        return this.owlClassMap.get(rendering);
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String rendering) {
        return this.owlObjectPropertyMap.get(rendering);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String rendering) {
        return this.owlDataPropertyMap.get(rendering);
    }

    public OWLNamedIndividual getOWLIndividual(String rendering) {
        return this.owlIndividualMap.get(rendering);
    }

    @Override
    public OWLDatatype getOWLDataType(String rendering) {
        return this.owlDatatypeMap.get(rendering);
    }

    @Override
    public String getRendering(OWLEntity owlEntity) {
        return this.entityRenderingMap.get(owlEntity);
    }

    @Override
    public OWLEntity getOWLEntity(String rendering) {
        OWLClass entity = this.getOWLClass(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLObjectProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDataProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLIndividual(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDataType(rendering);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    @Override
    public void addRendering(OWLEntity owlEntity) {
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlDataPropertyMap);
            }

            public void visit(OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap);
            }

            public void visit(OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlIndividualMap);
            }

            public void visit(OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlClassMap);
            }

            public void visit(OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.addRendering(entity, OWLEntityRenderingCacheImpl.this.owlDatatypeMap);
            }

            public void visit(OWLAnnotationProperty property) {
                OWLEntityRenderingCacheImpl.this.addRendering(property, OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap);
            }
        });
    }

    protected <T extends OWLEntity> void addRendering(T entity, Map<String, T> map) {
        if (!this.entityRenderingMap.containsKey(entity)) {
            String rendering = this.entityRenderer.render(entity);
            map.put(rendering, entity);
            this.entityRenderingMap.put(entity, rendering);
        }
    }

    @Override
    public void removeRendering(OWLEntity owlEntity) {
        final String oldRendering = this.entityRenderingMap.get(owlEntity);
        this.entityRenderingMap.remove(owlEntity);
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.owlClassMap.remove(oldRendering);
            }

            public void visit(OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlDataPropertyMap.remove(oldRendering);
            }

            public void visit(OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap.remove(oldRendering);
            }

            public void visit(OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.owlIndividualMap.remove(oldRendering);
            }

            public void visit(OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.owlDatatypeMap.remove(oldRendering);
            }

            public void visit(OWLAnnotationProperty property) {
                OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap.remove(oldRendering);
            }
        });
    }

    @Override
    public void updateRendering(OWLEntity ent) {
        boolean updateRendering = this.renderingNeedsUpdating(ent);
        this.removeRendering(ent);
        if (updateRendering) {
            this.addRendering(ent);
        }
    }

    protected boolean renderingNeedsUpdating(OWLEntity ent) {
        return this.manager.ontologies().anyMatch(o -> o.containsEntityInSignature(ent));
    }

    @Override
    public Set<String> getOWLClassRenderings() {
        return this.owlClassMap.keySet();
    }

    @Override
    public Set<String> getOWLObjectPropertyRenderings() {
        return this.owlObjectPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLDataPropertyRenderings() {
        return this.owlDataPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLIndividualRenderings() {
        return this.owlIndividualMap.keySet();
    }

    @Override
    public Set<String> getOWLDatatypeRenderings() {
        return this.owlDatatypeMap.keySet();
    }

    @Override
    public Set<String> getOWLEntityRenderings() {
        HashSet<String> renderings = new HashSet<String>(this.owlClassMap.size() + this.owlObjectPropertyMap.size() + this.owlDataPropertyMap.size() + this.owlIndividualMap.size() + this.owlDatatypeMap.size());
        renderings.addAll(this.owlClassMap.keySet());
        renderings.addAll(this.owlObjectPropertyMap.keySet());
        renderings.addAll(this.owlDataPropertyMap.keySet());
        renderings.addAll(this.owlIndividualMap.keySet());
        renderings.addAll(this.owlDatatypeMap.keySet());
        return renderings;
    }
}

