/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.Set;
import java.util.stream.Stream;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.DisposableOWLEntityChecker;
import org.coode.parsers.EntityFinder;
import org.coode.parsers.OWLAxiomType;
import org.coode.parsers.OWLEntityRenderer;
import org.coode.parsers.OWLEntitySymbol;
import org.coode.parsers.OWLType;
import org.coode.parsers.Scope;
import org.coode.parsers.Symbol;
import org.coode.parsers.Type;
import org.coode.parsers.TypeVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLEntityCheckerScope
implements Scope {
    private final DisposableOWLEntityChecker owlEntityChecker;
    private final EntityFinder entityFinder;
    private final OWLEntityRenderer owlEntityRenderer;
    private final VariableFinder finder;

    public OWLEntityCheckerScope(DisposableOWLEntityChecker owlEntityChecker, EntityFinder entityFinder, OWLEntityRenderer owlEntityRenderer) {
        this.owlEntityChecker = ArgCheck.checkNotNull(owlEntityChecker, "owlEntityChecker");
        this.entityFinder = ArgCheck.checkNotNull(entityFinder, "entityFinder");
        this.owlEntityRenderer = ArgCheck.checkNotNull(owlEntityRenderer, "owlEntityRenderer");
        this.finder = new VariableFinder(entityFinder, owlEntityRenderer);
    }

    @Override
    public void define(Symbol symbol) {
    }

    @Override
    public Scope getEnclosingScope() {
        return null;
    }

    @Override
    public String getScopeName() {
        return "global";
    }

    @Override
    public Symbol resolve(String name) {
        OWLEntitySymbol toReturn = null;
        OWLClass owlEntity = this.getOWLEntityChecker().getOWLClass(name);
        if (owlEntity != null) {
            toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
        } else {
            owlEntity = this.getOWLEntityChecker().getOWLDataProperty(name);
            if (owlEntity != null) {
                toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
            } else {
                owlEntity = this.getOWLEntityChecker().getOWLObjectProperty(name);
                if (owlEntity != null) {
                    toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                } else {
                    owlEntity = this.getOWLEntityChecker().getOWLIndividual(name);
                    if (owlEntity != null) {
                        toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                    } else {
                        owlEntity = this.getOWLEntityChecker().getOWLDatatype(name);
                        if (owlEntity != null) {
                            toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                        } else {
                            owlEntity = this.getOWLEntityChecker().getOWLAnnotationProperty(name);
                            if (owlEntity != null) {
                                toReturn = new OWLEntitySymbol(name, (OWLEntity)owlEntity);
                            }
                        }
                    }
                }
            }
        }
        return toReturn;
    }

    @Override
    public Set<Symbol> match(String prefix) {
        return OWLAPIStreamUtils.asSet(this.getEntityFinder().getEntities(ArgCheck.checkNotNull(prefix, "prefix")).stream().map(o -> new OWLEntitySymbol(this.getOWLEntityRenderer().render((OWLEntity)o), (OWLEntity)o)));
    }

    public DisposableOWLEntityChecker getOWLEntityChecker() {
        return this.owlEntityChecker;
    }

    public EntityFinder getEntityFinder() {
        return this.entityFinder;
    }

    public OWLEntityRenderer getOWLEntityRenderer() {
        return this.owlEntityRenderer;
    }

    @Override
    public Set<Symbol> getAllSymbols() {
        return OWLAPIStreamUtils.asSet(this.getEntityFinder().getEntities("").stream().map(o -> new OWLEntitySymbol(this.getOWLEntityRenderer().render((OWLEntity)o), (OWLEntity)o)));
    }

    @Override
    public Set<Symbol> getAllSymbols(Type type) {
        return OWLAPIStreamUtils.asSet(type.accept(this.finder));
    }

    @Override
    public void dispose() {
        this.getOWLEntityChecker().dispose();
    }

    static class VariableFinder
    implements TypeVisitorEx<Stream<Symbol>> {
        private OWLEntityRenderer renderer;
        private EntityFinder finder;

        public VariableFinder(EntityFinder f, OWLEntityRenderer r) {
            this.finder = f;
            this.renderer = r;
        }

        @Override
        public Stream<Symbol> visitOWLAxiomType(OWLAxiomType owlAxiomType) {
            return Stream.empty();
        }

        @Override
        public Stream<Symbol> visitNonOWLType(Type t) {
            return Stream.empty();
        }

        @Override
        public Stream<Symbol> visitOWLType(OWLType owlType) {
            switch (owlType) {
                case OWL_CLASS: {
                    return this.finder.getMatchingOWLClasses("*").stream().map(o -> new OWLEntitySymbol(this.renderer.render((OWLEntity)o), (OWLEntity)o));
                }
                case OWL_DATA_PROPERTY: {
                    return this.finder.getMatchingOWLDataProperties("*").stream().map(o -> new OWLEntitySymbol(this.renderer.render((OWLEntity)o), (OWLEntity)o));
                }
                case OWL_OBJECT_PROPERTY: {
                    return this.finder.getMatchingOWLObjectProperties("*").stream().map(o -> new OWLEntitySymbol(this.renderer.render((OWLEntity)o), (OWLEntity)o));
                }
                case OWL_INDIVIDUAL: {
                    return this.finder.getMatchingOWLIndividuals("*").stream().map(o -> new OWLEntitySymbol(this.renderer.render((OWLEntity)o), (OWLEntity)o));
                }
            }
            return Stream.empty();
        }
    }
}

