/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.coode.oppl.utils.ArgCheck;
import org.coode.parsers.EntityFinder;
import org.coode.parsers.OWLEntityRenderingCache;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class EntityFinderImpl
implements EntityFinder {
    private final OWLEntityRenderingCache renderingCache;
    private final OWLOntologyManager manager;
    private final boolean useRegularExpressions;
    private static final String WILDCARD = "*";

    public EntityFinderImpl(OWLOntologyManager mngr, OWLEntityRenderingCache renderingCache, boolean useRegularExpressions) {
        this.renderingCache = ArgCheck.checkNotNull(renderingCache, "renderingCache");
        this.manager = ArgCheck.checkNotNull(mngr, "mngr");
        this.useRegularExpressions = useRegularExpressions;
    }

    @Override
    public Set<OWLClass> getMatchingOWLClasses(String match) {
        return this.getEntities(match, OWLClass.class, this.useRegularExpressions);
    }

    @Override
    public Set<OWLClass> getMatchingOWLClasses(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLClass.class, fullRegExp);
    }

    @Override
    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String match) {
        return this.getEntities(match, OWLObjectProperty.class, this.useRegularExpressions);
    }

    @Override
    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLObjectProperty.class, fullRegExp);
    }

    @Override
    public Set<OWLDataProperty> getMatchingOWLDataProperties(String match) {
        return this.getEntities(match, OWLDataProperty.class, this.useRegularExpressions);
    }

    @Override
    public Set<OWLDataProperty> getMatchingOWLDataProperties(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLDataProperty.class, fullRegExp);
    }

    @Override
    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String match) {
        return this.getEntities(match, OWLNamedIndividual.class, this.useRegularExpressions);
    }

    @Override
    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLNamedIndividual.class, fullRegExp);
    }

    @Override
    public Set<OWLDatatype> getMatchingOWLDataTypes(String match) {
        return this.getEntities(match, OWLDatatype.class, this.useRegularExpressions);
    }

    @Override
    public Set<OWLDatatype> getMatchingOWLDataTypes(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLDatatype.class, fullRegExp);
    }

    @Override
    public Set<OWLEntity> getEntities(String match) {
        return this.getEntities(match, OWLEntity.class, this.useRegularExpressions);
    }

    @Override
    public Set<OWLEntity> getEntities(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLEntity.class, fullRegExp);
    }

    private <T extends OWLEntity> Set<T> getEntities(String match, Class<T> type, boolean fullRegExp) {
        if (match.length() == 0) {
            return Collections.emptySet();
        }
        if (fullRegExp) {
            return this.doRegExpSearch(match, type);
        }
        return this.doWildcardSearch(match, type);
    }

    private <T extends OWLEntity> Set<T> doRegExpSearch(String match, Class<T> type) {
        HashSet<T> results = new HashSet<T>();
        try {
            Pattern pattern = Pattern.compile(match);
            for (String rendering : this.getRenderings(type)) {
                T ent;
                Matcher m = pattern.matcher(rendering);
                if (!m.find() || (ent = this.getEntity(rendering, type)) == null) continue;
                results.add(ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private <T extends OWLEntity> Set<T> doWildcardSearch(String _match, Class<T> type) {
        SimpleWildCardMatcher matcher;
        String match = _match;
        if (match.equals(WILDCARD)) {
            return this.getAllEntities(type);
        }
        HashSet<T> results = new HashSet<T>();
        if (match.startsWith(WILDCARD)) {
            if (match.length() > 1 && match.endsWith(WILDCARD)) {
                matcher = (rendering, s) -> rendering.indexOf(s) != -1;
                match = match.substring(1, match.length() - 1);
            } else {
                matcher = (rendering, s) -> rendering.indexOf(s) != -1;
                match = match.substring(1, match.length());
            }
        } else {
            if (match.endsWith(WILDCARD) && match.length() > 1) {
                match = match.substring(0, match.length() - 1);
            }
            matcher = (rendering, s) -> rendering.startsWith(s) || rendering.startsWith("'" + s);
        }
        if (match.trim().length() != 0) {
            match = match.toLowerCase();
            for (String rendering2 : this.getRenderings(type)) {
                if (rendering2.length() <= 0 || !matcher.matches(rendering2.toLowerCase(), match)) continue;
                results.add(this.getEntity(rendering2, type));
            }
        }
        return results;
    }

    private <T extends OWLEntity> Set<T> getAllEntities(Class<T> type) {
        HashSet entities = new HashSet();
        this.manager.ontologies().forEach(ont -> {
            if (type.equals(OWLClass.class)) {
                OWLAPIStreamUtils.add((Collection)entities, (Stream)ont.classesInSignature());
            } else if (type.equals(OWLObjectProperty.class)) {
                OWLAPIStreamUtils.add((Collection)entities, (Stream)ont.objectPropertiesInSignature());
            } else if (type.equals(OWLDataProperty.class)) {
                OWLAPIStreamUtils.add((Collection)entities, (Stream)ont.dataPropertiesInSignature());
            } else if (type.equals(OWLIndividual.class)) {
                OWLAPIStreamUtils.add((Collection)entities, (Stream)ont.individualsInSignature());
            } else if (type.equals(OWLDatatype.class)) {
                OWLAPIStreamUtils.add((Collection)entities, (Stream)ont.datatypesInSignature());
            }
        });
        return entities;
    }

    private <T extends OWLEntity> T getEntity(String rendering, Class<T> type) {
        if (type.equals(OWLClass.class)) {
            return (T)this.renderingCache.getOWLClass(rendering);
        }
        if (type.equals(OWLObjectProperty.class)) {
            return (T)this.renderingCache.getOWLObjectProperty(rendering);
        }
        if (type.equals(OWLDataProperty.class)) {
            return (T)this.renderingCache.getOWLDataProperty(rendering);
        }
        if (type.equals(OWLIndividual.class)) {
            return (T)((OWLEntity)this.renderingCache.getOWLIndividual(rendering));
        }
        if (type.equals(OWLDatatype.class)) {
            return (T)this.renderingCache.getOWLDataType(rendering);
        }
        return (T)this.renderingCache.getOWLEntity(rendering);
    }

    private <T extends OWLEntity> Set<String> getRenderings(Class<T> type) {
        if (type.equals(OWLClass.class)) {
            return this.renderingCache.getOWLClassRenderings();
        }
        if (type.equals(OWLObjectProperty.class)) {
            return this.renderingCache.getOWLObjectPropertyRenderings();
        }
        if (type.equals(OWLDataProperty.class)) {
            return this.renderingCache.getOWLDataPropertyRenderings();
        }
        if (type.equals(OWLIndividual.class)) {
            return this.renderingCache.getOWLIndividualRenderings();
        }
        if (type.equals(OWLDatatype.class)) {
            return this.renderingCache.getOWLDatatypeRenderings();
        }
        return this.renderingCache.getOWLEntityRenderings();
    }

    private static interface SimpleWildCardMatcher {
        public boolean matches(String var1, String var2);
    }
}

