/*
 * Decompiled with CFR 0.152.
 */
package org.coode.parsers;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.CachingBidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class BidirectionalShortFormProviderAdapter
extends CachingBidirectionalShortFormProvider
implements OWLEntitySetProvider<OWLEntity> {
    private final ShortFormProvider shortFormProvider;
    private OWLOntologyManager man;

    public BidirectionalShortFormProviderAdapter(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public BidirectionalShortFormProviderAdapter(OWLOntologyManager man, ShortFormProvider shortFormProvider) {
        this.man = man;
        this.shortFormProvider = shortFormProvider;
        this.rebuild(this.entities());
        this.addWellKnownEntities(man.getOWLDataFactory());
    }

    private void addWellKnownEntities(OWLDataFactory dataFactory) {
        this.add((OWLEntity)dataFactory.getOWLThing());
        this.add((OWLEntity)dataFactory.getOWLNothing());
        this.add((OWLEntity)dataFactory.getTopDatatype());
        this.add((OWLEntity)dataFactory.getOWLTopObjectProperty());
        this.add((OWLEntity)dataFactory.getOWLTopDataProperty());
        for (OWL2Datatype datatype : EnumSet.allOf(OWL2Datatype.class)) {
            this.add((OWLEntity)dataFactory.getOWLDatatype(datatype.getIRI()));
        }
    }

    protected String generateShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    public void dispose() {
    }

    public Set<OWLEntity> getEntities() {
        if (this.man == null) {
            return Collections.emptySet();
        }
        return OWLAPIStreamUtils.asSet(this.man.ontologies().flatMap(HasSignature::signature));
    }

    public Stream<OWLEntity> entities() {
        if (this.man == null) {
            return Stream.empty();
        }
        return this.man.ontologies().flatMap(HasSignature::signature).distinct();
    }
}

