/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.variabletypes;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.variabletypes.ANNOTATIONPROPERTYVariableType;
import org.coode.oppl.variabletypes.CLASSVariableType;
import org.coode.oppl.variabletypes.CONSTANTVariableType;
import org.coode.oppl.variabletypes.DATAPROPERTYVariableType;
import org.coode.oppl.variabletypes.INDIVIDUALVariableType;
import org.coode.oppl.variabletypes.OBJECTPROPERTYVariableType;
import org.coode.oppl.variabletypes.VariableType;
import org.coode.oppl.variabletypes.VariableTypeName;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

public class VariableTypeFactory {
    private static final EnumMap<VariableTypeName, VariableType<?>> typesCache = VariableTypeFactory.cache();
    private static final Set<VariableType<?>> allTypes = Collections.unmodifiableSet(new HashSet(typesCache.values()));

    static EnumMap<VariableTypeName, VariableType<?>> cache() {
        EnumMap map = new EnumMap(VariableTypeName.class);
        map.put(VariableTypeName.CLASS, new CLASSVariableType(VariableTypeName.CLASS));
        map.put(VariableTypeName.OBJECTPROPERTY, new OBJECTPROPERTYVariableType(VariableTypeName.OBJECTPROPERTY));
        map.put(VariableTypeName.DATAPROPERTY, new DATAPROPERTYVariableType(VariableTypeName.DATAPROPERTY));
        map.put(VariableTypeName.ANNOTATIONPROPERTY, new ANNOTATIONPROPERTYVariableType(VariableTypeName.ANNOTATIONPROPERTY));
        map.put(VariableTypeName.INDIVIDUAL, new INDIVIDUALVariableType(VariableTypeName.INDIVIDUAL));
        map.put(VariableTypeName.CONSTANT, new CONSTANTVariableType(VariableTypeName.CONSTANT));
        return map;
    }

    public static VariableType<?> getVariableType(OWLObject owlObject) {
        return (VariableType)owlObject.accept(new OWLObjectVisitorEx<VariableType<?>>(){

            public VariableType<OWLClassExpression> visit(OWLClass ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectUnionOf ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectComplementOf ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectSomeValuesFrom ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectAllValuesFrom ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectHasValue ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectMinCardinality ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectExactCardinality ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectMaxCardinality ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectHasSelf ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLObjectOneOf ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLDataSomeValuesFrom ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLDataAllValuesFrom ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLDataHasValue ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLDataMinCardinality ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLDataExactCardinality ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLClassExpression> visit(OWLDataMaxCardinality ce) {
                return VariableTypeFactory.getCLASSVariableType();
            }

            public VariableType<OWLDataPropertyExpression> visit(OWLDataProperty property) {
                return VariableTypeFactory.getDATAPROPERTYVariableType();
            }

            public VariableType<OWLObjectPropertyExpression> visit(OWLObjectProperty property) {
                return VariableTypeFactory.getOBJECTPROPERTYTypeVariableType();
            }

            public VariableType<OWLObjectPropertyExpression> visit(OWLObjectInverseOf property) {
                return VariableTypeFactory.getOBJECTPROPERTYTypeVariableType();
            }

            public VariableType<OWLIndividual> visit(OWLAnonymousIndividual individual) {
                return VariableTypeFactory.getINDIVIDUALVariableType();
            }

            public VariableType<OWLIndividual> visit(OWLNamedIndividual individual) {
                return VariableTypeFactory.getINDIVIDUALVariableType();
            }

            public VariableType<OWLLiteral> visit(OWLLiteral literal) {
                return VariableTypeFactory.getCONSTANTVariableType();
            }

            public VariableType<?> visit(OWLAnnotationProperty property) {
                return VariableTypeFactory.getANNOTATIONPROPERTYVariableType();
            }
        });
    }

    public static VariableType<OWLClassExpression> getCLASSVariableType() {
        return VariableTypeFactory.getVariableType(VariableTypeName.CLASS);
    }

    public static VariableType<OWLObjectPropertyExpression> getOBJECTPROPERTYTypeVariableType() {
        return VariableTypeFactory.getVariableType(VariableTypeName.OBJECTPROPERTY);
    }

    public static VariableType<OWLDataPropertyExpression> getDATAPROPERTYVariableType() {
        return VariableTypeFactory.getVariableType(VariableTypeName.DATAPROPERTY);
    }

    public static VariableType<OWLAnnotationProperty> getANNOTATIONPROPERTYVariableType() {
        return VariableTypeFactory.getVariableType(VariableTypeName.ANNOTATIONPROPERTY);
    }

    public static VariableType<OWLIndividual> getINDIVIDUALVariableType() {
        return VariableTypeFactory.getVariableType(VariableTypeName.INDIVIDUAL);
    }

    public static VariableType<OWLLiteral> getCONSTANTVariableType() {
        return VariableTypeFactory.getVariableType(VariableTypeName.CONSTANT);
    }

    public static VariableType<?> getVariableType(VariableTypeName variableTypeName) {
        return variableTypeName == null ? null : typesCache.get((Object)variableTypeName);
    }

    public static VariableType<?> getVariableType(String variableTypeName) {
        return VariableTypeFactory.getVariableType(VariableTypeName.getVariableTypeName(variableTypeName));
    }

    public static Set<VariableType<?>> getAllVariableTypes() {
        return allTypes;
    }
}

