/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.VariableVisitorEx;
import org.coode.oppl.datafactory.OPPLOWLDifferentIndividualsAxiom;
import org.coode.oppl.datafactory.OPPLOWLDisjointClassesAxiom;
import org.coode.oppl.datafactory.OPPLOWLDisjointDataPropertiesAxiom;
import org.coode.oppl.datafactory.OPPLOWLDisjointObjectPropertiesAxiom;
import org.coode.oppl.datafactory.OPPLOWLSameIndividualAxiom;
import org.coode.oppl.function.Aggregandum;
import org.coode.oppl.function.Aggregation;
import org.coode.oppl.function.Constant;
import org.coode.oppl.function.Create;
import org.coode.oppl.function.Expression;
import org.coode.oppl.function.GroupVariableAttribute;
import org.coode.oppl.function.IRIVariableAttribute;
import org.coode.oppl.function.OPPLFunction;
import org.coode.oppl.function.OPPLFunctionVisitorEx;
import org.coode.oppl.function.RenderingVariableAttribute;
import org.coode.oppl.function.ToLowerCaseStringManipulationOPPLFunction;
import org.coode.oppl.function.ToUpperCaseStringManipulationOPPLFunction;
import org.coode.oppl.function.ValuesVariableAtttribute;
import org.coode.oppl.function.inline.InlineSet;
import org.coode.oppl.generated.GeneratedVariable;
import org.coode.oppl.generated.RegexpGeneratedVariable;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.IRIVisitorExAdapter;
import org.coode.oppl.variabletypes.InputVariable;
import org.coode.parsers.oppl.VariableIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;

public class VariableExtractor {
    protected final ConstraintSystem cs;
    private final boolean includeGenerated;

    public VariableExtractor(ConstraintSystem constraintSystem, boolean includeGenerated) {
        this.cs = ArgCheck.checkNotNull(constraintSystem, "constraintSystem");
        this.includeGenerated = includeGenerated;
    }

    public ConstraintSystem getConstraintSystem() {
        return this.cs;
    }

    public boolean isIncludeGenerated() {
        return this.includeGenerated;
    }

    public Set<Variable<?>> extractVariables(OWLObject owlObject) {
        return (Set)owlObject.accept((OWLObjectVisitorEx)new Visitor());
    }

    public Set<Variable<?>> extractVariables(OPPLFunction<?> opplFunction) {
        return opplFunction.accept((VariableExtractor)this.new Visitor().extractor);
    }

    private final class Visitor
    implements OWLObjectVisitorEx<Set<Variable<?>>> {
        protected final Set<Variable<?>> set = new HashSet();
        protected final OPPLFunctionVisitorEx<Set<Variable<?>>> extractor = new OPPLFunctionVisitorEx<Set<Variable<?>>>(){

            @Override
            public <O, I> Set<Variable<?>> visitAggregation(Aggregation<O, I> a) {
                a.toAggregate().flatMap(Aggregandum::opplFunctions).forEach(f -> {
                    Set cfr_ignored_0 = (Set)f.accept(this);
                });
                return Visitor.this.set;
            }

            @Override
            public <O extends OWLObject> Set<Variable<?>> visitInlineSet(InlineSet<O> a) {
                a.aggregandums().flatMap(Aggregandum::opplFunctions).forEach(f -> {
                    Set cfr_ignored_0 = (Set)f.accept(this);
                });
                return Visitor.this.set;
            }

            @Override
            public <P extends OWLObject> Set<Variable<?>> visitGenericOPPLFunction(OPPLFunction<P> a) {
                return Visitor.this.set;
            }

            @Override
            public <O> Set<Variable<?>> visitConstant(Constant<O> a) {
                Variable<?> variable;
                O value = a.getValue();
                if (value instanceof Variable) {
                    return Visitor.this.vetoVariableIntoCollection((Variable)value);
                }
                if (value instanceof OWLEntity && (variable = VariableExtractor.this.cs.getVariable(((OWLEntity)value).getIRI())) != null) {
                    Visitor.this.set.add(variable);
                }
                return Visitor.this.set;
            }

            @Override
            public <O, I extends OPPLFunction<?>> Set<Variable<?>> visitCreate(Create<I, O> a) {
                return (Set)a.getInput().accept(this);
            }

            @Override
            public <O extends OWLObject> Set<Variable<?>> visitExpression(Expression<O> a) {
                return (Set)a.getExpression().accept((OWLObjectVisitorEx)Visitor.this);
            }

            @Override
            public Set<Variable<?>> visitToLowerCaseStringManipulationOPPLFunction(ToLowerCaseStringManipulationOPPLFunction a) {
                return (Set)a.accept(this);
            }

            @Override
            public Set<Variable<?>> visitToUpperCaseStringManipulationOPPLFunction(ToUpperCaseStringManipulationOPPLFunction a) {
                return (Set)a.accept(this);
            }

            @Override
            public <O extends OWLObject> Set<Variable<?>> visitGroupVariableAttribute(GroupVariableAttribute<O> a) {
                return Visitor.this.vetoVariableIntoCollection(a.getVariable());
            }

            @Override
            public Set<Variable<?>> visitRenderingVariableAttribute(RenderingVariableAttribute a) {
                return Visitor.this.vetoVariableIntoCollection(a.getVariable());
            }

            @Override
            public Set<Variable<?>> visitIRIVariableAttribute(IRIVariableAttribute i) {
                return Visitor.this.vetoVariableIntoCollection(i.getVariable());
            }

            @Override
            public <O extends OWLObject> Set<Variable<?>> visitValuesVariableAtttribute(ValuesVariableAtttribute<O> a) {
                return Visitor.this.vetoVariableIntoCollection(a.getVariable());
            }
        };

        public <T> Set<Variable<?>> doDefault(T object) {
            return Collections.emptySet();
        }

        public Set<Variable<?>> visit(OWLSubClassOfAxiom axiom) {
            axiom.getSuperClass().accept((OWLObjectVisitorEx)this);
            axiom.getSubClass().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitorEx)this);
            axiom.getSubject().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLAnnotationAssertionAxiom axiom) {
            ((OWLAnnotationSubject)axiom.getSubject()).accept((OWLObjectVisitorEx)this);
            axiom.getAnnotation().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(IRI iri) {
            return (Set)iri.accept((OWLObjectVisitorEx)new IRIVisitorExAdapter<Set<Variable<?>>>(this.set){

                @Override
                public Set<Variable<?>> visitVariableIRI(VariableIRI i) {
                    return i.getAttribute().accept(Visitor.this.extractor);
                }
            });
        }

        public Set<Variable<?>> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLDisjointClassesAxiom axiom) {
            if (OPPLOWLDisjointClassesAxiom.class.isAssignableFrom(axiom.getClass())) {
                ((OPPLOWLDisjointClassesAxiom)axiom).getInlineSet().accept(this.extractor);
            } else {
                axiom.classExpressions().forEach(c -> {
                    Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
                });
            }
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataPropertyDomainAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectPropertyDomainAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            axiom.properties().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitorEx)this);
            axiom.getSubject().accept((OWLObjectVisitorEx)this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDifferentIndividualsAxiom axiom) {
            if (OPPLOWLDifferentIndividualsAxiom.class.isAssignableFrom(axiom.getClass())) {
                return ((OPPLOWLDifferentIndividualsAxiom)axiom).getInlineSet().accept(this.extractor);
            }
            axiom.individuals().forEach(i -> {
                Set cfr_ignored_0 = (Set)i.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDisjointDataPropertiesAxiom axiom) {
            if (OPPLOWLDisjointDataPropertiesAxiom.class.isAssignableFrom(axiom.getClass())) {
                return ((OPPLOWLDisjointDataPropertiesAxiom)axiom).getInlineSet().accept(this.extractor);
            }
            axiom.properties().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (OPPLOWLDisjointObjectPropertiesAxiom.class.isAssignableFrom(axiom.getClass())) {
                return ((OPPLOWLDisjointObjectPropertiesAxiom)axiom).getInlineSet().accept(this.extractor);
            }
            axiom.properties().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectPropertyRangeAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectPropertyAssertionAxiom axiom) {
            axiom.getSubject().accept((OWLObjectVisitorEx)this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLSubObjectPropertyOfAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDisjointUnionAxiom axiom) {
            axiom.classExpressions().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLDataPropertyRangeAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return (Set)((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            axiom.properties().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLClassAssertionAxiom axiom) {
            axiom.getIndividual().accept((OWLObjectVisitorEx)this);
            axiom.getClassExpression().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLEquivalentClassesAxiom axiom) {
            axiom.classExpressions().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataPropertyAssertionAxiom axiom) {
            axiom.getSubject().accept((OWLObjectVisitorEx)this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLSubDataPropertyOfAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitorEx)this);
            ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return (Set)((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLSameIndividualAxiom axiom) {
            if (OPPLOWLSameIndividualAxiom.class.isAssignableFrom(axiom.getClass())) {
                return ((OPPLOWLSameIndividualAxiom)axiom).getInlineSet().accept(this.extractor);
            }
            axiom.individuals().forEach(i -> {
                Set cfr_ignored_0 = (Set)i.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLSubPropertyChainOfAxiom axiom) {
            axiom.getSuperProperty().accept((OWLObjectVisitorEx)this);
            axiom.getPropertyChain().forEach(o -> {
                Set cfr_ignored_0 = (Set)o.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLInverseObjectPropertiesAxiom axiom) {
            axiom.getFirstProperty().accept((OWLObjectVisitorEx)this);
            axiom.getSecondProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLClass e) {
            return this.vetoVariableIntoCollection(VariableExtractor.this.cs.getVariable(e.getIRI()));
        }

        public Set<Variable<?>> visit(OWLAnnotationProperty e) {
            return this.vetoVariableIntoCollection(VariableExtractor.this.cs.getVariable(e.getIRI()));
        }

        public Set<Variable<?>> visit(OWLAnnotation annotation) {
            annotation.getProperty().accept((OWLObjectVisitorEx)this);
            annotation.getValue().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        protected Set<Variable<?>> vetoVariableIntoCollection(Variable<?> variable) {
            if (variable == null) {
                return this.set;
            }
            VariableVisitorEx variableVetoer = new VariableVisitorEx<Set<Variable<?>>>(){

                @Override
                public <O extends OWLObject> Set<Variable<?>> visit(GeneratedVariable<O> v) {
                    v.getOPPLFunction().accept(Visitor.this.extractor);
                    if (VariableExtractor.this.isIncludeGenerated()) {
                        Visitor.this.set.add(v);
                    }
                    return Visitor.this.set;
                }

                @Override
                public <O extends OWLObject> Set<Variable<?>> visit(InputVariable<O> v) {
                    Visitor.this.set.add(v);
                    return Visitor.this.set;
                }

                @Override
                public <O extends OWLObject> Set<Variable<?>> visit(RegexpGeneratedVariable<O> rexp) {
                    Visitor.this.set.add(rexp);
                    return Visitor.this.set;
                }
            };
            return (Set)variable.accept(variableVetoer);
        }

        public Set<Variable<?>> visit(OWLObjectIntersectionOf desc) {
            desc.operands().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectUnionOf desc) {
            desc.operands().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectComplementOf desc) {
            return (Set)desc.getOperand().accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLObjectSomeValuesFrom desc) {
            ((OWLClassExpression)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectAllValuesFrom desc) {
            ((OWLClassExpression)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectHasValue desc) {
            ((OWLIndividual)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectMinCardinality desc) {
            ((OWLClassExpression)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectExactCardinality desc) {
            ((OWLClassExpression)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectMaxCardinality desc) {
            ((OWLClassExpression)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLObjectHasSelf desc) {
            return (Set)desc.getProperty().accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLObjectOneOf desc) {
            desc.individuals().forEach(i -> {
                Set cfr_ignored_0 = (Set)i.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataSomeValuesFrom desc) {
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            ((OWLDataRange)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataAllValuesFrom desc) {
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            ((OWLDataRange)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataHasValue desc) {
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            ((OWLLiteral)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataMinCardinality desc) {
            ((OWLDataRange)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataExactCardinality desc) {
            ((OWLDataRange)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataMaxCardinality desc) {
            ((OWLDataRange)desc.getFiller()).accept((OWLObjectVisitorEx)this);
            desc.getProperty().accept((OWLObjectVisitorEx)this);
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDataComplementOf node) {
            return (Set)node.getDataRange().accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLDataOneOf node) {
            node.values().forEach(c -> {
                Set cfr_ignored_0 = (Set)c.accept((OWLObjectVisitorEx)this);
            });
            return this.set;
        }

        public Set<Variable<?>> visit(OWLDatatypeRestriction node) {
            return (Set)node.getDatatype().accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLLiteral node) {
            return this.vetoVariableIntoCollection(VariableExtractor.this.cs.getVariable(node.getLiteral()));
        }

        public Set<Variable<?>> visit(OWLObjectProperty e) {
            return this.vetoVariableIntoCollection(VariableExtractor.this.cs.getVariable(e.getIRI()));
        }

        public Set<Variable<?>> visit(OWLObjectInverseOf property) {
            return (Set)property.getInverse().accept((OWLObjectVisitorEx)this);
        }

        public Set<Variable<?>> visit(OWLDataProperty e) {
            return this.vetoVariableIntoCollection(VariableExtractor.this.cs.getVariable(e.getIRI()));
        }

        public Set<Variable<?>> visit(OWLNamedIndividual e) {
            return this.vetoVariableIntoCollection(VariableExtractor.this.cs.getVariable(e.getIRI()));
        }
    }
}

