/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.stream.Stream;
import org.coode.oppl.utils.ArgCheck;
import org.coode.oppl.utils.OWLPrimitiveSelector;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryBooleanClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public final class OWLObjectExtractor<O extends OWLObject>
implements OWLObjectVisitorEx<Stream<O>> {
    private final OWLObjectVisitorEx<Boolean> selector;

    private OWLObjectExtractor(OWLObjectVisitorEx<Boolean> selector) {
        this.selector = ArgCheck.checkNotNull(selector, "selector");
    }

    public <T> Stream<O> doDefault(T object) {
        return Stream.empty();
    }

    public Stream<O> visit(OWLDeclarationAxiom axiom) {
        return this.visitPrimitive((OWLObject)axiom.getEntity());
    }

    public Stream<O> visit(OWLAnnotationAssertionAxiom axiom) {
        return Stream.of(axiom.getSubject(), axiom.getAnnotation()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLAnnotation annotation) {
        return Stream.of(annotation.getProperty(), annotation.getValue()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLSubClassOfAxiom axiom) {
        return Stream.of(axiom.getSubClass(), axiom.getSuperClass()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    private Stream<O> visitOWLPropertyAssertionAxiom(OWLPropertyAssertionAxiom<?, ?> axiom) {
        return Stream.of(axiom.getProperty(), axiom.getSubject(), axiom.getObject()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    private Stream<O> visitCharacteristicAxiom(OWLUnaryPropertyAxiom<?> axiom) {
        return (Stream)((OWLPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitorEx)this);
    }

    public Stream<O> visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLDisjointClassesAxiom axiom) {
        return this.visitOWLNAryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    private Stream<O> visitOWLNAryClassAxiom(OWLNaryClassAxiom axiom) {
        return axiom.classExpressions().flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLDataPropertyDomainAxiom axiom) {
        return this.visitOWLPropertyDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
    }

    private Stream<O> visitOWLPropertyDomainAxiom(OWLPropertyDomainAxiom<?> axiom) {
        return Stream.of(axiom.getProperty(), axiom.getDomain()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.visitOWLPropertyDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    private Stream<O> visitOWLNaryPropertyAxiom(OWLNaryPropertyAxiom<?> axiom) {
        return axiom.properties().flatMap(p -> (Stream)p.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Stream<O> visit(OWLDifferentIndividualsAxiom axiom) {
        return this.visitOWLNaryIndividualAxiom((OWLNaryIndividualAxiom)axiom);
    }

    private Stream<O> visitOWLNaryIndividualAxiom(OWLNaryIndividualAxiom axiom) {
        return axiom.individuals().flatMap(i -> (Stream)i.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLDisjointDataPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.visitOWLPropertyRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    private Stream<O> visitOWLPropertyRangeAxiom(OWLPropertyRangeAxiom<?, ?> axiom) {
        return Stream.of(axiom.getProperty(), axiom.getRange()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLObjectPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Stream<O> visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLSubObjectPropertyOfAxiom axiom) {
        return this.visitOWLSubPropertyAxiom((OWLSubPropertyAxiom<?>)axiom);
    }

    private Stream<O> visitOWLSubPropertyAxiom(OWLSubPropertyAxiom<?> axiom) {
        return Stream.of(axiom.getSubProperty(), axiom.getSuperProperty()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLDisjointUnionAxiom axiom) {
        return axiom.classExpressions().flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLDataPropertyRangeAxiom axiom) {
        return this.visitOWLPropertyRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    public Stream<O> visit(OWLFunctionalDataPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLClassAssertionAxiom axiom) {
        return Stream.of(axiom.getClassExpression(), axiom.getIndividual()).flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLEquivalentClassesAxiom axiom) {
        return this.visitOWLNAryClassAxiom((OWLNaryClassAxiom)axiom);
    }

    public Stream<O> visit(OWLDataPropertyAssertionAxiom axiom) {
        return this.visitOWLPropertyAssertionAxiom((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public Stream<O> visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLSubDataPropertyOfAxiom axiom) {
        return this.visitOWLSubPropertyAxiom((OWLSubPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return this.visitCharacteristicAxiom((OWLUnaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(OWLSameIndividualAxiom axiom) {
        return this.visitOWLNaryIndividualAxiom((OWLNaryIndividualAxiom)axiom);
    }

    public Stream<O> visit(OWLSubPropertyChainOfAxiom axiom) {
        return Stream.concat((Stream)axiom.getSuperProperty().accept((OWLObjectVisitorEx)this), axiom.getPropertyChain().stream().flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this)));
    }

    public Stream<O> visit(OWLInverseObjectPropertiesAxiom axiom) {
        return this.visitOWLNaryPropertyAxiom((OWLNaryPropertyAxiom<?>)axiom);
    }

    public Stream<O> visit(SWRLRule rule) {
        return Stream.empty();
    }

    public Stream<O> visit(OWLClass desc) {
        return this.visitPrimitive((OWLObject)desc);
    }

    public Stream<O> visit(OWLAnnotationProperty property) {
        return this.visitPrimitive((OWLObject)property);
    }

    private Stream<O> visitPrimitive(OWLObject owlObject) {
        if (((Boolean)owlObject.accept(this.getSelector())).booleanValue()) {
            return Stream.of(owlObject);
        }
        return Stream.empty();
    }

    public Stream<O> visit(OWLObjectIntersectionOf desc) {
        return this.visitOWLNaryBooleanExpression((OWLNaryBooleanClassExpression)desc);
    }

    private Stream<O> visitOWLNaryBooleanExpression(OWLNaryBooleanClassExpression desc) {
        return desc.operands().flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLObjectUnionOf desc) {
        return this.visitOWLNaryBooleanExpression((OWLNaryBooleanClassExpression)desc);
    }

    public Stream<O> visit(OWLObjectComplementOf desc) {
        return (Stream)desc.getOperand().accept((OWLObjectVisitorEx)this);
    }

    public Stream<O> visit(OWLObjectSomeValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?>)desc);
    }

    private Stream<O> visitOWLQuantifiedRestriction(OWLQuantifiedRestriction<?> desc) {
        return Stream.concat((Stream)desc.getProperty().accept((OWLObjectVisitorEx)this), (Stream)((OWLPropertyRange)desc.getFiller()).accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLObjectAllValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?>)desc);
    }

    public Stream<O> visit(OWLObjectHasValue desc) {
        return this.visitOWLValueRestriction((OWLHasValueRestriction<?>)desc);
    }

    private Stream<O> visitOWLValueRestriction(OWLHasValueRestriction<?> desc) {
        return Stream.concat((Stream)desc.getProperty().accept((OWLObjectVisitorEx)this), (Stream)desc.getFiller().accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLObjectMinCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?>)desc);
    }

    public Stream<O> visit(OWLObjectExactCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?>)desc);
    }

    public Stream<O> visit(OWLObjectMaxCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?>)desc);
    }

    private Stream<O> visitOWLCardinalityRestriction(OWLCardinalityRestriction<?> desc) {
        return Stream.concat((Stream)desc.getProperty().accept((OWLObjectVisitorEx)this), (Stream)((OWLPropertyRange)desc.getFiller()).accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLObjectHasSelf desc) {
        return (Stream)desc.getProperty().accept((OWLObjectVisitorEx)this);
    }

    public Stream<O> visit(OWLObjectOneOf desc) {
        return desc.individuals().flatMap(c -> (Stream)c.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLDataSomeValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?>)desc);
    }

    public Stream<O> visit(OWLDataAllValuesFrom desc) {
        return this.visitOWLQuantifiedRestriction((OWLQuantifiedRestriction<?>)desc);
    }

    public Stream<O> visit(OWLDataHasValue desc) {
        return this.visitOWLValueRestriction((OWLHasValueRestriction<?>)desc);
    }

    public Stream<O> visit(OWLDataMinCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?>)desc);
    }

    public Stream<O> visit(OWLDataExactCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?>)desc);
    }

    public Stream<O> visit(OWLDataMaxCardinality desc) {
        return this.visitOWLCardinalityRestriction((OWLCardinalityRestriction<?>)desc);
    }

    public Stream<O> visit(OWLDatatype node) {
        return this.visitPrimitive((OWLObject)node);
    }

    public Stream<O> visit(OWLDataComplementOf node) {
        return (Stream)node.getDataRange().accept((OWLObjectVisitorEx)this);
    }

    public Stream<O> visit(OWLDataOneOf node) {
        return node.values().flatMap(o -> (Stream)o.accept((OWLObjectVisitorEx)this));
    }

    public Stream<O> visit(OWLLiteral node) {
        return this.visitPrimitive((OWLObject)node);
    }

    public Stream<O> visit(OWLObjectProperty property) {
        return this.visitPrimitive((OWLObject)property);
    }

    public Stream<O> visit(OWLObjectInverseOf property) {
        return (Stream)property.getInverse().accept((OWLObjectVisitorEx)this);
    }

    public Stream<O> visit(OWLDataProperty property) {
        return this.visitPrimitive((OWLObject)property);
    }

    public Stream<O> visit(OWLNamedIndividual individual) {
        return this.visitPrimitive((OWLObject)individual);
    }

    public OWLObjectVisitorEx<Boolean> getSelector() {
        return this.selector;
    }

    public static Stream<OWLClass> getAllClasses(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLClassSelector());
    }

    public static Stream<OWLObjectProperty> getAllOWLObjectProperties(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLObjectPropertySelector());
    }

    public static Stream<OWLDataProperty> getAllOWLDataProperties(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLDataPropertySelector());
    }

    public static Stream<OWLNamedIndividual> getAllOWLIndividuals(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLIndividualSelector());
    }

    public static Stream<OWLDatatype> getAllOWLDatatypes(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLDatatypeSelector());
    }

    public static Stream<OWLLiteral> getAllOWLLiterals(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLConstantSelector());
    }

    public static Stream<OWLEntity> getAllOWLEntities(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLEntitySelector());
    }

    public static Stream<OWLObject> getAllOWLPrimitives(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllPrimitiveSelector());
    }

    public static Stream<OWLAnnotationProperty> getAllAnnotationProperties(OWLObject owlObject) {
        return OWLObjectExtractor.getAll(owlObject, OWLPrimitiveSelector.getAllOWLAnnotationPropertySelector());
    }

    private static <T extends OWLObject> Stream<T> getAll(OWLObject owlObject, OWLObjectVisitorEx<Boolean> extractor) {
        return (Stream)owlObject.accept(new OWLObjectExtractor(extractor));
    }
}

