/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import org.coode.oppl.ConstraintSystem;
import org.coode.oppl.Variable;
import org.coode.oppl.utils.AbstractVariableDetector;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class NamedVariableDetector
extends AbstractVariableDetector {
    private final Variable<?> variable;

    public NamedVariableDetector(Variable<?> variable, ConstraintSystem constraintSystem) {
        super(constraintSystem);
        this.variable = variable;
    }

    public Boolean visit(OWLClass desc) {
        return this.constraintSystem.isVariableIRI(desc.getIRI()) && this.constraintSystem.getVariable(desc.getIRI()).equals(this.variable);
    }

    public Boolean visit(OWLLiteral node) {
        return this.constraintSystem.isVariable(node) && this.constraintSystem.getVariable(node.getLiteral()).equals(this.variable);
    }

    public Boolean visit(OWLObjectProperty property) {
        return this.constraintSystem.isVariable((OWLObject)property) && this.constraintSystem.getVariable(property.getIRI()).equals(this.variable);
    }

    public Boolean visit(OWLDataProperty property) {
        return this.constraintSystem.isVariable((OWLObject)property) && this.constraintSystem.getVariable(property.getIRI()).equals(this.variable);
    }

    public Boolean visit(OWLNamedIndividual individual) {
        return this.constraintSystem.isVariable((OWLObject)individual) && this.constraintSystem.getVariable(individual.getIRI()).equals(this.variable);
    }
}

