/*
 * Decompiled with CFR 0.152.
 */
package org.coode.oppl.utils;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public final class ConstantCollector
implements OWLAxiomVisitor {
    private final Set<OWLLiteral> toReturn;
    private final OWLClassExpressionVisitor constantExtractor;

    public ConstantCollector(Set<OWLLiteral> toReturn, OWLClassExpressionVisitor constantExtractor) {
        this.toReturn = toReturn;
        this.constantExtractor = constantExtractor;
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getClassExpression().accept(this.constantExtractor);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.toReturn.add((OWLLiteral)axiom.getObject());
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        axiom.classExpressions().forEach(c -> c.accept(this.constantExtractor));
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        axiom.classExpressions().forEach(c -> c.accept(this.constantExtractor));
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.toReturn.add((OWLLiteral)axiom.getObject());
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this.constantExtractor);
        axiom.getSuperClass().accept(this.constantExtractor);
    }
}

